package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.FaultCase;
import com.yeejoin.equipmanage.common.enums.EmergencyLevelEum;
import com.yeejoin.equipmanage.mapper.FaultCaseMapper;
import com.yeejoin.equipmanage.service.IFaultCaseService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 信号分类量测枚举表服务实现类
 *
 * @author system_generator
 * @date 2022-02-18
 */
@Service
public class FaultCaseServiceImpl extends ServiceImpl<FaultCaseMapper, FaultCase> implements IFaultCaseService {

    @Override
    public Page<FaultCase> listPage(Page page, FaultCase faultCase) {
        Page<FaultCase> pages = this.baseMapper.listPage(page, faultCase);
        if (!pages.getRecords().isEmpty()) {
            pages.getRecords().forEach(x -> x.setFaultLevel(EmergencyLevelEum.getNameByCode(x.getFaultLevel())));
        }
        return pages;
    }

    @Override
    public List<Map<String, Object>> getFaultCaseList() {
        return this.baseMapper.getFaultCaseList();
    }
}