package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.entity.CommonTree;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.enums.NodeTypeEum;
import com.yeejoin.equipmanage.common.enums.TreeTypeEum;
import com.yeejoin.equipmanage.common.vo.CommonTreeVo;
import com.yeejoin.equipmanage.service.ICommonTreeService;
import com.yeejoin.equipmanage.service.IEquipmentCategoryService;
import com.yeejoin.equipmanage.service.IFireResourceService;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class FireResourceServiceImpl implements IFireResourceService {

    @Autowired
    ICommonTreeService iCommonTreeService;
    @Autowired
    IEquipmentCategoryService iEquipmentCategoryService;

    @Override
    public List<CommonTreeVo> getFireResourceTree() {
        //1. 原始树节点数据
        List<CommonTree> treeList = iCommonTreeService.listSpecial(TreeTypeEum.fireResource.getCode());
        //2.子树节点数据，目前只有消防设备有
        List<EquipmentCategory> equipmentCategoryList = iEquipmentCategoryService.list();
        //3.将分类的树节点挂到（parentId修改）树的node节点为fireEquip上面
        Optional<CommonTree> op = treeList.stream().filter(t -> NodeTypeEum.fireEquipment.getCode().equals(t.getNodeType())).findFirst();
        if(!op.isPresent()){
            throw new RuntimeException("后端数据不完整");
        }
        CommonTree equipmentNode = op.get();
        List<CommonTreeVo> categories = this.changeRootParentId(equipmentCategoryList, equipmentNode);
        List<CommonTreeVo> treeListVo = treeList.stream().map(s -> {
            CommonTreeVo t = new CommonTreeVo();
            Bean.copyExistPropertis(s, t);
            return t;
        }).collect(Collectors.toList());
        List<CommonTreeVo> allTrees = ListUtils.union(categories, treeListVo);
        //4.list to tree 返回
        return allTrees.stream().filter(t -> t.getParentId() == null || t.getParentId() == 0).map(root -> {
            CommonTreeVo vo = new CommonTreeVo();
            Bean.copyExistPropertis(root, vo);
            vo.setChildren(this.findChildren(root.getId(), allTrees));
            return vo;
        }).collect(Collectors.toList());
    }

    private List<CommonTreeVo> findChildren(Long parentId, List<CommonTreeVo> allTrees) {
        List<CommonTreeVo> children = new ArrayList<>();
        allTrees.stream().filter(t -> t.getParentId().equals(parentId)).forEach(c -> {
            c.setChildren(this.findChildren(c.getId(), allTrees));
            children.add(c);
        });
        return children;
    }

    private List<CommonTreeVo> changeRootParentId(List<EquipmentCategory> equipmentCategoryList, CommonTree equipmentNode) {
        return equipmentCategoryList.stream().map(s -> {
            CommonTreeVo t = new CommonTreeVo();
            t.setId(s.getId());//前端查询条件
            t.setName(s.getName());
            t.setCode(s.getCode());//前端查询条件
            t.setNodeType(NodeTypeEum.fireEquipment.getCode());//前端查询条件
            t.setParentId(s.getParentId());
            if (s.getParentId() == null || s.getParentId() == 0) {
                t.setParentId(equipmentNode.getId());
            }
            return t;
        }).collect(Collectors.toList());
    }
}
