package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.SocialPower;
import com.yeejoin.equipmanage.common.entity.dto.FireResourceStatsDTO;
import com.yeejoin.equipmanage.mapper.SocialPowerMapper;
import com.yeejoin.equipmanage.service.ISocialPowerService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 社会力量表服务实现类
 *
 * @author system_generator
 * @date 2022-02-18
 */
@Service
public class SocialPowerServiceImpl extends ServiceImpl<SocialPowerMapper, SocialPower> implements ISocialPowerService {

    @Override
    public Page<SocialPower> listPage(Page page, SocialPower socialPower) {
        Page<SocialPower> pages = this.baseMapper.listPage(page, socialPower);
        return pages;
    }

    @Override
    public List<Map<String, Object>> getSocialPowerList() {
        return this.baseMapper.getSocialPowerList();
    }

    @Override
    public FireResourceStatsDTO getStatistics(String bizOrgCode) {
        return this.baseMapper.getStatistics(bizOrgCode);
    }
}