package com.yeejoin.amos.fas.business.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.fas.business.dao.repository.IFmeaDao;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.business.param.RiskFmeaParam;
import com.yeejoin.amos.fas.business.service.intfc.IFmeaService;
import com.yeejoin.amos.fas.business.service.intfc.IRiskSourceService;
import com.yeejoin.amos.fas.business.util.CommonPageParamUtil;
import com.yeejoin.amos.fas.client.invoke.RsDataQueue;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.common.request.CommonRequest;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.dao.entity.Fmea;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import com.yeejoin.amos.fas.exception.YeeException;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;

@RestController
@RequestMapping("/api/riskModel")
@Api(tags = "风险模型api")
public class RiskModelController extends AbstractBaseController {

    private final Logger log = LoggerFactory.getLogger(RiskModelController.class);

    @Autowired
    private IRiskSourceService riskSourceService;
    
    @Autowired
    private IFmeaService fmeaService;

    @Autowired
    private IFmeaDao iFmeaDao;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据父类编号获取子类风险点类型", notes = "根据父类编号获取子类风险点类型")
    @GetMapping(value = "/riskSource/getChildTypeByPid")
    public CommonResponse getChildTypeByPid(@ApiParam(value = "风险模型对象", required = true) @RequestParam Long riskSourceId) {
        try {
            Integer type = riskSourceService.getChildTypeByPid(riskSourceId);
            return CommonResponseUtil.success(type);
        } catch (Exception e) {
            log.error("根据父类编号获取子类风险点类型异常", e);
            return CommonResponseUtil.failure("系统繁忙，请稍后再试");
        }
    }


    /**
     * 风险模型新增及维护
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "风险模型新增及维护", notes = "风险模型新增及维护")
    @RequestMapping(value = "/riskSource/editRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse editRiskSource(@ApiParam(value = "风险模型对象", required = true) @RequestBody RiskSource param) {
        try {
            Integer type = riskSourceService.getChildTypeByPid(param.getParentId());
            String isRegion = param.getIsRegion();
            if (type.equals(1) && isRegion.equals("FALSE")) {
                return CommonResponseUtil.failure("该区域下只能添加区域");
            }
            if (type.equals(2) && isRegion.equals("TRUE")) {
                return CommonResponseUtil.failure("该区域下只能添加风险点");
            }
            
            Long id = param.getId();
            if (id == 0) {//新增
               
            } else {
                // 更新的话，就放到前面，更新失败直接阻止本地
                // 如果对于新增修改有什么约束，请添加到远程同步之前
//                String synMsg = riskSourceService.saveToEquipManage(getAppKey(), getProduct(), getToken(), SUCCESS,
//                        param.getId(), param.getCode(), param.getName(), param.getParentId());
//                if (synMsg != null) {
//                    return CommonResponseUtil.failure(synMsg);
//                }
            }
            
            AgencyUserModel user = getUserInfo();
			ReginParams reginParams =getSelectedOrgInfo();
			String compCode=getOrgCode(reginParams);
            HashMap<String, Object> map = new HashMap<>();
            map.put("org_code", compCode);
            map.put("user_id", user.getUserId());
            map.put("param", param);
            
            CommonResponse cr = CommonResponseUtil.success(riskSourceService.editRiskSource(map));
            if (id == 0) {//新增 新增的话，只能放到本地之后，因为必须拿到新增之后的ID才行
                // 如果对于新增修改有什么约束，请添加到远程同步之前
//                String synMsg = riskSourceService.saveToEquipManage(getAppKey(), getProduct(), getToken(), SUCCESS,
//                        param.getId(), param.getCode(), param.getName(), param.getParentId());
//                if (synMsg != null) {
//                    //远程新增失败，就把本地删了，有点绕，但是没办法
//                    //由于是刚刚新建的，就直接删除，不做任何不能删校验。
//                    riskSourceService.deleteById(param.getId());
//                    return CommonResponseUtil.failure(synMsg);
//                }
            }
            return cr;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险模型新增及维护失败：" + e.getMessage());
        }
    }

   
    /**
     * 风险模型删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "风险模型删除", notes = "风险模型删除")
    @RequestMapping(value = "/riskSource/deleteRiskSource", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteRiskSource(@ApiParam(value = "风险模型id", required = true) @RequestBody Long[] riskSourceId) {
        try {
            riskSourceService.deleteRiskSource(getAppKey(), getProduct(), getToken(), "SUCCESS", riskSourceId);
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("风险模型删除失败：" + e.getMessage());
        }
    }

    /**
     * 风险点列表分页查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "风险点列表分页查询", notes = "风险点列表分页查询")
    @RequestMapping(value = "/riskSource/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryRiskSourceByPage(
            @ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
            @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> riskSourceList = riskSourceService.queryRiskSourceByPage(param);
        return CommonResponseUtil.success(riskSourceList);
    }

    /**
     * Fmea模型新增及维护
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "Fmea模型新增及维护", notes = "Fmea模型新增及维护")
    @RequestMapping(value = "/fmea/editFmea", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse editFmea(@ApiParam(value = "Fmea模型对象", required = true) @RequestBody List<Fmea> params) {
        try {
            params.forEach(param -> {
                int i = iFmeaDao.checkIdAndName(param.getRiskSourceId(), param.getRiskFactorsId(),param.getId());
                if (i>0){
                    throw new YeeException("危险因素重复");
                }
            });
        	AgencyUserModel user = getUserInfo();
            HashMap<String, Object> map = new HashMap<>();
            map.put("user_id", user.getUserId());
            map.put("fmeas", params);
            fmeaService.editFmea(map);
            RsDataQueue rs = RsDataQueue.getInstance();
            params.forEach(param -> {
                if (!ObjectUtils.isEmpty(param.getId())) {
                    rs.addUpdateMessage(param.getId(),user.getRealName());
                }
            });
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("Fmea模型新增及维护失败：" + e.getMessage());
        }
    }

    /**
     * Fmea模型删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "Fmea模型删除", notes = "Fmea模型删除")
    @RequestMapping(value = "/fmea/deleteFmea", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse deleteFmea(@ApiParam(value = "Fmea模型id", required = true) @RequestBody RiskFmeaParam param) {
        try {
            Long[] fmeaIds = param.getFmeaIds();
            fmeaService.deleteFmea(fmeaIds);
            if (fmeaIds.length > 0 && param.getRiskSourceId() != null) {
                RsDataQueue rsDataQueue = RsDataQueue.getInstance();
                rsDataQueue.addDeleteMessage(param.getRiskSourceId());
            }
            return CommonResponseUtil.success();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return CommonResponseUtil.failure("Fmea模型删除失败：" + e.getMessage());
        }
    }

    /**
     * Fmea列表分页查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "Fmea列表分页查询", notes = "Fmea列表分页查询")
    @RequestMapping(value = "/fmea/list", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse queryFmeaByPage(@ApiParam(value = "查询条件") @RequestBody(required = false) List<CommonRequest> queryRequests,
                                          @ApiParam(value = "分页参数", required = true) CommonPageable commonPageable) {
        CommonPageInfoParam param = CommonPageParamUtil.fillCommonPageInfoParam(queryRequests, commonPageable);
        Page<HashMap<String, Object>> fmeaList = fmeaService.queryFmeaList(param,getToken(),getProduct(),getAppKey());
        return CommonResponseUtil.success(fmeaList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "Fmea是否关联对象查询", notes = "Fmea是否关联对象查询")
    @GetMapping(value = "/fmea/{ids}/controlObjCount")
    public CommonResponse queryFmeaControlObj(@ApiParam(value = "fmea ids") @PathVariable(value = "ids", required = true) String[] ids) {
        return CommonResponseUtil.success(fmeaService.queryControlObjCount(ids));
    }
}
