package com.yeejoin.amos.kgd.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.kgd.service.LiveDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.DateTimeUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.SimpleDateFormat;
import java.util.*;

@RestController
@Api(tags = "数据Api")
@RequestMapping(value = "/data")
public class DataManagerController  extends BaseController{

	@Autowired
	LiveDataService liveDataService;
	
	

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "列表查询数据")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ResponseModel query(
            @RequestParam(value = "timeStart") String timeStart,
            @RequestParam(value = "timeEnd") String timeEnd,
            @RequestParam(value = "measurement") String measurement,
            @RequestParam(value = "fieldKey", required = false) String fieldKey) {

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));

        Date start = DateTimeUtil.format(timeStart, DateTimeUtil.ISO_DATE_HOUR24_MIN_SEC);
        Date end = DateTimeUtil.format(timeEnd, DateTimeUtil.ISO_DATE_HOUR24_MIN_SEC);

        String startUTC = df.format(start);
        String endUTC = df.format(end);

        Map<String, Object> variables = new HashMap<>();
		Enumeration<String> keys = request.getParameterNames();
		while(keys.hasMoreElements()){
			String name = (String)keys.nextElement();
			String value = request.getParameter(name);
			variables.put(name, value);
		}
		variables.remove("timeStart");
		variables.remove("timeEnd");
		variables.remove("measurement");
		variables.remove("fieldKey");
        
        return ResponseHelper.buildResponse(liveDataService.queryHistoryDataForList(measurement, startUTC, endUTC, fieldKey, variables));
    }
    
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "分页查询数据")
    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public ResponseModel page(
            @RequestParam(value = "timeStart") String timeStart,
            @RequestParam(value = "timeEnd") String timeEnd,
            @RequestParam(value = "measurement") String measurement,
            @RequestParam(value = "fieldKey", required = false) String fieldKey,
            @RequestParam(value = "current") int current, 
            @RequestParam(value = "size") int size) {

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));

        Date start = DateTimeUtil.format(timeStart, DateTimeUtil.ISO_DATE_HOUR24_MIN_SEC);
        Date end = DateTimeUtil.format(timeEnd, DateTimeUtil.ISO_DATE_HOUR24_MIN_SEC);

        String startUTC = df.format(start);
        String endUTC = df.format(end);

        Map<String, Object> variables = new HashMap<>();
		Enumeration<String> keys = request.getParameterNames();
		while(keys.hasMoreElements()){
			String name = (String)keys.nextElement();
			String value = request.getParameter(name);
			variables.put(name, value);
		}
		variables.remove("timeStart");
		variables.remove("timeEnd");
		variables.remove("measurement");
		variables.remove("fieldKey");
		variables.remove("current");
		variables.remove("size");
        return ResponseHelper.buildResponse(liveDataService.queryHistoryDataForPage(measurement, startUTC, endUTC, fieldKey, variables, current, size));
    }
    
    
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "最新数据")
    @RequestMapping(value = "/realTime", method = RequestMethod.GET)
    public ResponseModel realTime(
            @RequestParam(value = "measurement") String measurement) {
    	return ResponseHelper.buildResponse(liveDataService.queryrealTimeData(measurement));
    }
}
