package com.yeejoin.amos.patrol.config;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.patrol.business.feign.JcsFeignClient;
import com.yeejoin.amos.patrol.exception.PermissionException;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * @author DELL
 */
@Aspect
@Component
@ResponseBody
@Order(value = 1)
public class PersonIdentifyAspect {

    @Autowired
    RedisUtils redisUtils;
    @Autowired
    private JcsFeignClient jcsFeignClient;

    @Value("${logic}")
    Boolean logic;

    @Pointcut("execution(public * com.yeejoin.amos.*.business.controller..*(..))")
    public void userDate() {

    }


    @Before("userDate()")
    public void personIdentity(JoinPoint joinPoint) throws PermissionException {


        //定时任务没有token
        if(RequestContext.getExeUserId()==null|| RequestContext.getToken()==null){

        }else {
        ReginParams reginParam = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (reginParam != null ) {
            if (reginParam.getPersonIdentity() == null || StringUtils.isEmpty(reginParam.getPersonIdentity().getBizOrgCode()) || StringUtils.isEmpty(reginParam.getPersonIdentity().getCompanyBizOrgCode())) {
                String userId = reginParam.getUserModel().getUserId();

                if (userId != null) {
                    FeignClientResult responseModel = jcsFeignClient.selectById(userId);


                    if (ObjectUtils.isEmpty(responseModel.getResult()) || responseModel.getStatus() != HttpStatus.OK.value()) {
                        throw new RuntimeException(responseModel.getDevMessage());
                    }
                    String s = JSONObject.toJSONString(responseModel.getResult());
                    ReginParams.PersonIdentity personIdentity = JSONObject.parseObject(s, ReginParams.PersonIdentity.class);
                    //    ReginParams.PersonIdentity personIdentity = (ReginParams.PersonIdentity) Bean.mapToBean((Map<String, Object>) responseModel.getResult(), ReginParams.PersonIdentity.class);
                    //电力默认走公司权限
                    if (!logic){
                        personIdentity.setBizOrgCode(StringUtils.isEmpty(personIdentity.getCompanyBizOrgCode()) ? "-1" : personIdentity.getCompanyBizOrgCode());
                    }

                    reginParam.setPersonIdentity(personIdentity);
                    redisUtils.set(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken()), JSONObject.toJSONString(reginParam));

                }
            }
         }
        }
    }

}

