package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CompanyDepartmentDto;
import com.yeejoin.precontrol.common.entity.CompanyDepartment;
import com.yeejoin.precontrol.common.service.ICompanyDepartmentService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

/**
 * 部门信息
 *
 * @author duanwei
 * @date 2021-09-07
 */
@RestController
@Api(tags = "部门信息Api")
@RequestMapping(value = "/company-department", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class CompanyDepartmentController {

	@Autowired
	ICompanyDepartmentService iCompanyDepartmentService;

	/**
	 * 新增部门信息
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增部门信息", notes = "新增部门信息")
	public boolean saveCompanyDepartment(HttpServletRequest request, @RequestBody CompanyDepartment companyDepartment) {
		return iCompanyDepartmentService.saveOne(companyDepartment);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iCompanyDepartmentService.removeTreeById(id);
	}

	/**
	 * 修改部门信息
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改部门信息", notes = "修改部门信息")
	public boolean updateByIdCompanyDepartment(HttpServletRequest request,
			@RequestBody CompanyDepartment companyDepartment) {
		return iCompanyDepartmentService.updateOneById(companyDepartment);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public CompanyDepartment selectById(HttpServletRequest request, @PathVariable Long id) {
		return iCompanyDepartmentService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<CompanyDepartment> listPage(String pageNum, String pageSize, CompanyDepartment companyDepartment) {

		Page<CompanyDepartment> pageBean;
		QueryWrapper<CompanyDepartment> companyDepartmentQueryWrapper = new QueryWrapper<>();
		Class<? extends CompanyDepartment> aClass = companyDepartment.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				ReflectionUtils.makeAccessible(field);
				Object o = field.get(companyDepartment);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(companyDepartment);
						companyDepartmentQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(companyDepartment);
						companyDepartmentQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(companyDepartment);
						companyDepartmentQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(companyDepartment);
						companyDepartmentQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<CompanyDepartment> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iCompanyDepartmentService.page(pageBean, companyDepartmentQueryWrapper);
		return page;
	}

	/**
	 * 查询部门树
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/tree/{companyId}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public List<CompanyDepartmentDto> treeById(HttpServletRequest request, @PathVariable Long companyId, String name) {
		return iCompanyDepartmentService.treeByCompanyId(companyId, name);
	}
}
