/*package com.yeejoin.amos.maintenance.business.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

import javax.persistence.SecondaryTable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.yeejoin.amos.maintenance.business.constants.XJConstant;
import com.yeejoin.amos.maintenance.business.controller.CheckController;
import com.yeejoin.amos.maintenance.business.feign.CompanyUserFeignServer;
import com.yeejoin.amos.maintenance.business.feign.IAMOSSecurityServer;
import com.yeejoin.amos.maintenance.business.service.intfc.OtherDeptService;
import com.yeejoin.amos.maintenance.core.util.StringUtil;

import net.sf.json.JSONObject;

@Service("otherDeptService")
public class OtherDeptServiceImpl implements OtherDeptService {

	private final Logger log = LoggerFactory.getLogger(OtherDeptServiceImpl.class);
	@Autowired
	private IAMOSSecurityServer amosSecurityServer;

	@Override
	public List<LinkedHashMap<String, Object>> queryDeptUsers(String deptId, String loginOrgCode) {
		ServletRequestAttributes sra = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
		RequestContextHolder.setRequestAttributes(sra, true);
		List<LinkedHashMap<String, Object>> userList = null;
		if ("-1".equals(deptId)) { // 部门ID为 -1
									// 时，所选择的的时《其他》，获取本公司没有部门的人员和上级公司用户类型为ADMIN的人员
			// String loginOrgCode = "1*4";
			String[] orgs = loginOrgCode.split("\\*");
			String reqOrg = orgs[orgs.length - 2];
			String owerOrg = orgs[orgs.length - 1];
			CountDownLatch latch = new CountDownLatch(2);
			CompanyUserFeignServer upsTask = new CompanyUserFeignServer(amosSecurityServer, latch, reqOrg,
					XJConstant.ADMIN_ORG_CODE);
			CompanyUserFeignServer tast = new CompanyUserFeignServer(amosSecurityServer, latch, owerOrg, null);
			upsTask.start();
			tast.start();
			try {
				latch.await();
			} catch (InterruptedException e) {
				log.error(e.getMessage());
			}
			List<LinkedHashMap<String, Object>> tasklist = (List<LinkedHashMap<String, Object>>) tast.getResponse()
					.getDataList();

			List<LinkedHashMap<String, Object>> upsUsers = (List<LinkedHashMap<String, Object>>) upsTask.getResponse()
					.getDataList();
			userList = paraseData(upsUsers);
			if (!ObjectUtils.isEmpty(tasklist)) {
				for (LinkedHashMap<String, Object> map : tasklist) {
					if (map.get("department") == null) {
						userList.add(parseData(map));
					}
				}
			}

		}
		return userList;
	}

	private LinkedHashMap<String, Object> parseData(LinkedHashMap<String, Object> map) {
		LinkedHashMap<String, Object> user = new LinkedHashMap<String, Object>();
		user.put("id", map.get("id"));
		user.put("key", map.get("id"));
		user.put("value", map.get("id"));
		user.put("checked", false);
		user.put("state", "open");
		user.put("label", map.get("name"));
		user.put("label", map.get("name"));
		user.put("name", map.get("name"));
		user.put("desc", null);
		user.put("writeable", 0);
		user.put("userName", map.get("userName"));
		user.put("email", map.get("email"));
		user.put("mobile", map.get("mobile"));
		user.put("telephone", map.get("telephone"));
		return user;
	}

	private List<LinkedHashMap<String, Object>> paraseData(List<LinkedHashMap<String, Object>> list) {
		return paraseData(list, null);
	}

	private List<LinkedHashMap<String, Object>> paraseData(List<LinkedHashMap<String, Object>> list, String userNmae) {
		List<LinkedHashMap<String, Object>> userList = new ArrayList<>();
		if (!ObjectUtils.isEmpty(list)) {
			for (LinkedHashMap<String, Object> map : list) {
				LinkedHashMap<String, Object> user = new LinkedHashMap<>();
				List<LinkedHashMap<String, Object>> children = (List<LinkedHashMap<String, Object>>) map
						.get("children");
				List<LinkedHashMap<String, Object>> tempChildren = new ArrayList<LinkedHashMap<String, Object>>();
				if (children != null && children.size() > 0) {
					children.forEach(action -> {
						tempChildren.add(paraseData(action));
					});
				}
				if (!ObjectUtils.isEmpty(tempChildren) || "department".equals(map.get("type"))) {
					if (!ObjectUtils.isEmpty(userNmae) && map.get("label").toString().indexOf(userNmae) != -1) {
						List<LinkedHashMap<String, Object>> temp = filterUser(tempChildren, userNmae);
						user.put("children", temp);
						user.put("type", "department");
					} else {
						user.put("children", tempChildren);
						user.put("type", "department");
					}
				} else {
					user.put("type", "user");
					if (!ObjectUtils.isEmpty(userNmae) && map.get("name").toString().indexOf(userNmae) == -1) {
						continue;
					}
				}

				user.put("id", map.get("id"));
				user.put("key", map.get("id"));
				user.put("value", map.get("id"));
				user.put("checked", false);
				user.put("state", "open");
				if (ObjectUtils.isEmpty(map.get("label"))) {
					user.put("label", map.get("name"));
				} else {
					user.put("label", map.get("label"));
				}
				if (ObjectUtils.isEmpty(map.get("label"))) {
					user.put("title", map.get("name"));
				} else {
					user.put("title", map.get("label"));
				}
				user.put("name", map.get("name"));
				user.put("desc", null);
				user.put("writeable", 0);
				user.put("userName", map.get("userName"));
				user.put("mobile", map.get("mobile"));
				user.put("telephone", map.get("telephone"));

				if (map != null && map.get("children") != null) {
					List<LinkedHashMap<String, Object>> li = (List) map.get("children");
					if (li.size() > 0) {
						for (LinkedHashMap<String, Object> linkedHashMap : li) {
							String st = linkedHashMap.get("id").toString();
							String sstr = amosSecurityServer.queryUserById(Long.parseLong(st));
							if (!StringUtil.isNotEmpty(sstr)) {
								continue;
							}
							JSONObject jasonObject = JSONObject.fromObject(sstr);
							Map userInfo = (Map) jasonObject;
							if (userInfo != null) {
								if (ObjectUtils.isEmpty(userInfo.get("email"))
										|| userInfo.get("email").toString().equals("null")) {
									linkedHashMap.put("email", null);
								} else {
									linkedHashMap.put("email", userInfo.get("email").toString());
								}
								if (userInfo.get("department") != null) {
									Map dept = (Map) userInfo.get("department");
									linkedHashMap.put("departmentName", dept.get("departmentName"));
								}
								if (ObjectUtils.isEmpty(userInfo.get("mobile"))
										|| userInfo.get("mobile").toString().equals("null")) {
									linkedHashMap.put("mobile", userInfo.get("userName"));
								} else {
									linkedHashMap.put("mobile", userInfo.get("mobile").toString());
								}

								if (ObjectUtils.isEmpty(userInfo.get("telephone"))
										|| userInfo.get("telephone").toString().equals("null")) {
									linkedHashMap.put("telephone", userInfo.get("userName"));
								} else {
									linkedHashMap.put("telephone", userInfo.get("telephone").toString());
								}

							}

						}
					}

					user.put("children", li);
				}

				userList.add(user);

			}
		}

		return userList;
	}

	private LinkedHashMap<String, Object> paraseData(LinkedHashMap<String, Object> map) {

		LinkedHashMap<String, Object> user = new LinkedHashMap<>();

		user.put("id", map.get("id"));
		user.put("key", map.get("id"));
		user.put("value", map.get("id"));
		user.put("checked", false);
		user.put("state", "open");
		user.put("type", "user");
		user.put("label", map.get("label"));
		user.put("title", map.get("label"));
		user.put("name", map.get("name"));
		user.put("desc", null);
		user.put("writeable", 0);
		user.put("userName", map.get("userName"));
		user.put("mobile", map.get("mobile"));
		user.put("telephone", map.get("telephone"));

		String sstr = amosSecurityServer.queryUserById(Long.parseLong(map.get("id").toString()));
		if (StringUtil.isNotEmpty(sstr)) {
			JSONObject jasonObject = JSONObject.fromObject(sstr);
			Map userInfo = (Map) jasonObject;
			if (userInfo != null && userInfo.get("email") != null && !userInfo.get("email").toString().equals("null")) {
				user.put("email", userInfo.get("email").toString());
			} else {
				user.put("email", null);
			}

			user.put("departmentName", "其他");
			if (ObjectUtils.isEmpty(userInfo.get("mobile")) || userInfo.get("mobile").toString().equals("null")) {
				user.put("mobile", userInfo.get("userName"));
			} else {
				user.put("mobile", userInfo.get("mobile").toString());
			}
			if (ObjectUtils.isEmpty(userInfo.get("telephone")) || userInfo.get("telephone").toString().equals("null")) {
				user.put("telephone", userInfo.get("userName"));
			} else {
				user.put("telephone", userInfo.get("telephone").toString());
			}
		}
		return user;
	}

	private List<LinkedHashMap<String, Object>> filterUser(List<LinkedHashMap<String, Object>> tempChildren,
			String userNmae) {
		List<LinkedHashMap<String, Object>> userList = new ArrayList<LinkedHashMap<String, Object>>();
		if (ObjectUtils.isEmpty(tempChildren)) {
			return userList;
		}
		userList.forEach((item) -> {
			if (!ObjectUtils.isEmpty(userNmae) && item.get("label").toString().indexOf(userNmae) != -1) {
				userList.add(item);
			}
		});
		return userList;
	}
}
*/