package com.yeejoin.amos.boot.module.tzs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchPaper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 派遣单携带动态表单值
 *
 * @author kongfm
 * @date 2021-08-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="DispatchPaperFormDto", description="派遣单携带动态表单值")
public class DispatchPaperFormDto extends BaseDto {

   private static final long serialVersionUID = 1L;

   @ApiModelProperty(value = "派遣单")
   private DispatchPaper dispatchPaper;

   @ApiModelProperty(value = "动态表单值")
    private List<AlertFormValue> dynamicFormAlert;

    public DispatchPaperFormDto(DispatchPaper dispatchPaper, List<AlertFormValue> formValue) {
      this.dispatchPaper = dispatchPaper;
      this.dynamicFormAlert = formValue;
    }

    public DispatchPaperFormDto() {

    }

}
