package com.yeejoin.amos;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;

import java.net.InetAddress;
import java.net.UnknownHostException;
//import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

/**
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: YeeAMOSPatrolStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({"org.typroject","com.yeejoin.amos"})
public class JpushApplication {

    private static final Logger logger = LoggerFactory.getLogger(JpushApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext context = SpringApplication.run(JpushApplication.class, args);
        Environment env = context.getEnvironment();
        logger.info("\n----------------------------------------------------------\n\t"
                + "Application Amos-Biz-Boot is running!\n\t"
                + "----------------------------------------------------------");
    }
}