package com.yeejoin.amos;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;

import java.net.InetAddress;
import java.net.UnknownHostException;


@SpringBootApplication
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@MapperScan({"org.typroject.tyboot.demo.face.orm.dao*",
    "org.typroject.tyboot.face.*.orm.dao*",
    "org.typroject.tyboot.core.auth.face.orm.dao*",
    "org.typroject.tyboot.component.*.face.orm.dao*",
    "com.yeejoin.amos.video.mapper",
    "com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan({"org.typroject","com.yeejoin.amos"})
public class VideoApplication {
	 private static final Logger logger = LoggerFactory.getLogger(VideoApplication.class);

	    public static void main(String[] args) {
	        ConfigurableApplicationContext context = SpringApplication.run(VideoApplication.class, args);
			Environment env = context.getEnvironment();
			String appName = env.getProperty("spring.application.name");
			logger.info(
					"\n----------------------------------------------------------\n\t"
							+ "Application {} is running!\n"
							+ "----------------------------------------------------------\n"
					, appName
			);
	    }
}
