package com.yeejoin.amos.boot.module.cylinder.flc.api.dto;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 企业信息表
 *
 * @author system_generator
 * @date 2021-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="UnitInfoDto", description="企业信息表")
public class UnitInfoDto extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "单位名称")
    private String orgName;

    @ApiModelProperty(value = "证照类型")
    private String licenceType;

    @ApiModelProperty(value = "证照类型code")
    private String licenceTypeCode;

    @ApiModelProperty(value = "组织机构编码")
    private String organizationCode;

    @ApiModelProperty(value = "单位类型")
    private String unitType;

    @ApiModelProperty(value = "单位类型code")
    private String unitTypeCode;

    @ApiModelProperty(value = "主管部门")
    private String comptentDept;

    @ApiModelProperty(value = "主管部门编号")
    private String comptentDeptCode;

    @ApiModelProperty(value = "批准成立机关")
    private String approveOrg;

    @ApiModelProperty(value = "登记机构")
    private String registrationAuthority;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "县区")
    private String district;

    @ApiModelProperty(value = "街道")
    private String stree;

    @ApiModelProperty(value = "小区")
    private String community;

    @ApiModelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private String longitude;

    @ApiModelProperty(value = "纬度")
    private String latitude;

    @ApiModelProperty(value = "管辖单位")
    private String managementUnit;

    @ApiModelProperty(value = "管辖单位id")
    private Long managementUnitId;

    @ApiModelProperty(value = "资质等级")
    private String qualificationLevel;

    @ApiModelProperty(value = "资质等级编号")
    private String qualificationLevelCode;

    @ApiModelProperty(value = "成立日期")
    private Date createTime;

    @ApiModelProperty(value = "单位法人")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonTel;

    @ApiModelProperty(value = "单位联系人")
    private String contactPerson;

    @ApiModelProperty(value = "联系人电话")
    private String contactPersonTel;

    @ApiModelProperty(value = "单位电话")
    private String unitTel;

    @ApiModelProperty(value = "管理员姓名")
    private String adminName;

    @ApiModelProperty(value = "管理员用户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

    @ApiModelProperty(value = "管理员手机号")
    private String adminTel;

    @ApiModelProperty(value = "org_user_id")
    private Long orgUserId;

    @ApiModelProperty(value = "审批状态 0 审批中 1 审批结束 2 驳回")
    private Integer unitStatus;

   @ApiModelProperty(value = "证照图片")
   private List<AttachmentDto> licencePic;

   @ApiModelProperty(value = "管理员身份证")
   private List<AttachmentDto> adminLicensePic;

   @ApiModelProperty(value = "是否变更 0 未变更 1 变更中")
   private Boolean isChange;

  @ApiModelProperty(value = "提交时间开始")
  private String submitTimeStart ;

  @ApiModelProperty(value = "提交时间结束")
  private String submitTimeEnd ;

 @ApiModelProperty(value = "分类名称")
  private String typeStr;

 @ApiModelProperty(value = "状态名称")
  private String statusStr;

 @ApiModelProperty(value = "企业二维码")
  private List<AttachmentDto> qrcode;

 @ApiModelProperty(value = "详细地址全部")
 private String fullAddress;

 @ApiModelProperty(value = "企业入驻时间")
 private Date approvedTime;

 @ApiModelProperty(value = "提交时间")
 private Date submitTime;

 @ApiModelProperty(value = "驳回id")
 private String callbackId;

}
