package com.yeejoin.amos.boot.module.tcm.biz.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tcm.api.enums.PlatformOpTopicEnum;
import com.yeejoin.amos.boot.module.tcm.api.service.IEquipmentCategoryService;
import com.yeejoin.amos.boot.module.tcm.api.service.ITzBaseEnterpriseInfoService;
import com.yeejoin.amos.boot.module.tcm.biz.service.impl.StartPlatformTokenService;
import com.yeejoin.amos.boot.module.tcm.flc.api.service.IRegUnitInfoService;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Objects;

@Component
@Slf4j
public class PlatformUserTopicMessage extends EmqxListener {
    @Resource
    protected EmqKeeper emqKeeper;

    @Value("${amos.operation.log}")
    private String amosOperationLog;

    @Value("${amos.orgCode.update:amos/company/orgCode/update}")
    private String amosOrgCodeUpdateTopic;

    @Value("${spring.application.name}")
    private String applicationName;

    @PostConstruct
    void init() throws Exception {
        emqKeeper.subscript(amosOperationLog, 2, this);
        emqKeeper.subscript(buildShareTopic(amosOrgCodeUpdateTopic), 2, this);
    }

    @Value("${amos.agency.code}")
    String amosAgencyCode;

    @Autowired
    RedisUtils redisUtil;

    @Autowired
    IEquipmentCategoryService equipmentCategoryService;

    @Autowired
    IRegUnitInfoService regUnitInfoService;

    @Autowired
    StartPlatformTokenService platformTokenService;

    @Autowired
    ITzBaseEnterpriseInfoService tzBaseEnterpriseInfoService;

    @Override
    public void processMessage(String topic, MqttMessage message) {
        log.info("平台推送消息开始同步");
        switch (Objects.requireNonNull(PlatformOpTopicEnum.getEnumByCode(topic))) {
            case OPERATION_LOG:
                // 处理 平台操作日志
                processOpMessage(message);
                break;
            case COMPANY_ORG_CODE_UPDATE:
                // 处理 单位orgCode变更
                processOrgCodeUpdateMessage(message);
                break;
        }
        log.info("平台推送消息同步完成");
    }

    protected void processOrgCodeUpdateMessage(MqttMessage message) {
        log.info("平台推送组织架构层级变动消息开始: " + message);
        try {
            if (ValidationUtil.isEmpty(message)) {
                return;
            }
            JSONObject jsonObject = JSON.parseObject(message.toString());
            String newOrgCode = jsonObject.getString("newOrgCode");
            String oldOrgCode = jsonObject.getString("oldOrgCode");
            tzBaseEnterpriseInfoService.refreshSupervisionOrgCode(jsonObject, newOrgCode, oldOrgCode);
        } catch (Exception e) {
            log.info("处理平台推送组织架构层级变动消息失败:{}", e.getMessage());
            e.printStackTrace();
        }
        log.info("平台推送组织架构层级变动消息结束");
    }

    protected void processOpMessage(MqttMessage message) {
        try {
            if (ValidationUtil.isEmpty(message)) {
                return;
            }
            JSONObject jsonObject = JSON.parseObject(message.toString());
            JSONObject result = jsonObject.getJSONObject("result");
            JSONArray dataResultList = null;
            JSONObject dataResult = null;
            if (!ValidationUtil.isEmpty(result) && result.get("result") instanceof JSONArray) {
                dataResultList = JSON.parseArray(result.get("result").toString());
            } else if (!ValidationUtil.isEmpty(result) && result.get("result") instanceof JSONObject) {
                dataResult = result.getJSONObject("result");
            }
            String path = result.getString("path");
            String method = jsonObject.getString("methodName");
            String agencyCode = jsonObject.getString("agencyCode");
            if (!amosAgencyCode.equals(agencyCode)) {
                return;
            }
            if (!ValidationUtil.isEmpty(dataResult) && StringUtils.isNotEmpty(path)) {
                if (path.contains("company")) {
                    if ("监管机构".equals(dataResult.get("companyType"))) {
                        equipmentCategoryService.deleteAllRegulatorUnitTree();
                    }
                    tzBaseEnterpriseInfoService.refreshCompanyInfo(dataResult, method);
                } else if (path.contains("agencyuser")) {
                    regUnitInfoService.updateAdminInfo(dataResult);
                }
            }
        } catch (Exception e) {
            log.info("平台同步消息失败:{}", e.getMessage());
            e.printStackTrace();
        }
    }

    private String buildShareTopic(String topic) {
        return "$share/" + applicationName + "/" + topic;
    }
}
