package com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl;

import com.yeejoin.amos.boot.module.cylinder.api.enums.TagTypeEnums;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderTagsDataUnit;
import com.yeejoin.amos.boot.module.cylinder.flc.api.mapper.CylinderTagsDataUnitMapper;
import com.yeejoin.amos.boot.module.cylinder.flc.api.service.ICylinderTagsDataUnitService;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderTagsDataUnitDto;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 气瓶及标签数量比表-企业服务实现类
 *
 * @author system_generator
 * @date 2022-03-11
 */
@Service
public class CylinderTagsDataUnitServiceImpl extends BaseService<CylinderTagsDataUnitDto,CylinderTagsDataUnit,CylinderTagsDataUnitMapper> implements ICylinderTagsDataUnitService {
    /**
     * 分页查询
     */
    public Page<CylinderTagsDataUnitDto> queryForCylinderTagsDataUnitPage(Page<CylinderTagsDataUnitDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderTagsDataUnitDto> queryForCylinderTagsDataUnitList()   {
        return this.queryForList("" , false);
    }

    public List<Map<String, Object>> selectForTagsStatisticsData(String regionCode) {
        List<Map<String, Object>> result = new ArrayList<>();
        if (ObjectUtils.isEmpty(regionCode)) {
            Map<String, Object> stringObjectMap = this.getBaseMapper().selectForTagsStatisticsData(null);
            return getTagTypeMaps(result, stringObjectMap);
        }
        CompanyModel company = Privilege.companyClient.queryByCompanyCode(regionCode).getResult();
        if (ObjectUtils.isEmpty(company)) {
            return null;
        }
        Map<String, Object> stringObjectMap = this.getBaseMapper().selectForTagsStatisticsData(company.getOrgCode());

        return getTagTypeMaps(result, stringObjectMap);
    }

    private List<Map<String, Object>> getTagTypeMaps(List<Map<String, Object>> result, Map<String, Object> stringObjectMap) {
        for (TagTypeEnums enums : TagTypeEnums.values()) {
            Map<String, Object> item = new HashMap<>();
            item.put("name", enums.getName());
            item.put("value", stringObjectMap.get(enums.getKey()));
            result.add(item);
        }
        return result;
    }
}