package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @author Administrator
 */
@Getter
public enum DPMapStatisticsItemEnum {
    /**
     * 大屏统计项
     */

    TOTAL("特种设备总量 (台)", "total", ""),
    GAS("气瓶 (台)", "gas", ""),
    ELEVATORS("电梯 (台)", "elevators", "3000"),
    PRESSURE_VESSELS("压力容器 (台)", "pressureVessels", "2000"),
    ON_SITE_MOTOR_VEHICLES("场（厂）内机动车 (台)", "onSiteMotorVehicles", "5000"),
    BOILERS("锅炉 (台)", "boilers", "1000"),
    LIFTING_MACHINERY("起重机械 (台)", "liftingMachinery", "4000"),
    LARGE_AMUSEMENT_FACILITIES("大型游乐设施 (台)", "largeAmusementFacilities", "6000"),
    PRESSURE_PIPELINES("压力管道 (千米)", "pressurePipelines", "8000"),
    PASSENGER_ROPEWAYS("客运索道 (台)", "passengerRopeways", "9000"),
    MANUFACTURING_UNITS("制造单位 (家)", "manufacturingUnits", ""),
    CONSTRUCTION_UNITS("安改维单位 (家)", "constructionUnits", ""),
    USERS_UNITS("使用单位 (家)", "usersUnits", ""),
    GAS_UNITS("充装单位 (家)", "gasUnits", ""),
    OPERATORS("作业人员 (人)", "operators", "");
    private String label;
    private String code;
    private String category;

    DPMapStatisticsItemEnum(String label, String code, String category) {
        this.label = label;
        this.code = code;
        this.category = category;
    }

    public static DPMapStatisticsItemEnum getInstanceByCategory(String category) {
        Optional<DPMapStatisticsItemEnum> op = Arrays.stream(DPMapStatisticsItemEnum.values()).filter(e -> e.category.equals(category)).findAny();
        return op.orElseThrow(() -> new RuntimeException("未知的类型"));
    }


}
