package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.DPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@RequestMapping("/db/statistics")
@Api(tags = "大屏统计")
public class DPStatisticsController {


    private DPStatisticsServiceImpl statisticsService;

    public DPStatisticsController(DPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧检验检测次数统计", notes = "按照维度设备种类、检验类型进行统计")
    @PostMapping(value = "/inspectTime/count/byEquListAndInspectType")
    public ResponseModel<Map<String, Object>> inspectTimeCountByTypeAndEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if(!fieldErrors.isEmpty()){
           throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCountByTypeAndEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏8大类-气瓶检验检测次数统计", notes = "气瓶检验检测次数统计")
    @PostMapping(value = "/inspectTimeCount")
    public ResponseModel<Map<String, Object>> inspectTimeCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if(!fieldErrors.isEmpty()){
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.inspectTimeCount(dpFilterParamDto));
    }

}
