package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionPlanModel;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @author Administrator
 */
@Service
public class InspectionPlanServiceImpl {

    private JyjcInspectionApplicationServiceImpl inspectionApplicationService;

    private JyjcInspectionApplicationEquipServiceImpl applicationEquipService;

    private ESEquipmentCategory esEquipmentCategory;

    public InspectionPlanServiceImpl(JyjcInspectionApplicationServiceImpl inspectionApplicationService,
                                     JyjcInspectionApplicationEquipServiceImpl applicationEquipService,
                                     ESEquipmentCategory  esEquipmentCategory) {
        this.inspectionApplicationService = inspectionApplicationService;
        this.applicationEquipService = applicationEquipService;
        this.esEquipmentCategory = esEquipmentCategory;
    }


    public InspectionPlanModel savePlanData(String applicationSeq, InspectionPlanModel model) {
        LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(JyjcInspectionApplication::getPlanData, JSONObject.toJSONString(model));
        updateWrapper.eq(BaseEntity::getSequenceNbr, applicationSeq);
        inspectionApplicationService.update(updateWrapper);
        return model;
    }

    public JSONObject getDetail(String applicationSeq) {
        JyjcInspectionApplication inspectionApplication = inspectionApplicationService.getById(applicationSeq);
        // 初始时查询设备地址关联设备表
        JSONObject jsonObject = inspectionApplication.getPlanData();
        if(jsonObject == null){
            jsonObject = new JSONObject();
            String address = this.getOneEquipAddress(applicationSeq);
            jsonObject.put("address", address);
        }
        return jsonObject;
    }

    private String getOneEquipAddress(String applicationSeq) {
        // 查询报检的设备，返回地址，目前是单台报检，applicationEquips长度只有1，后续会多个
        List<JyjcInspectionApplicationEquip> applicationEquips = applicationEquipService.list(new LambdaQueryWrapper<JyjcInspectionApplicationEquip>().eq(JyjcInspectionApplicationEquip::getApplicationSeq, applicationSeq));
        // 拼接地址
        List<String> allAddress = new ArrayList<>();
        applicationEquips.forEach(e->{
            String record = e.getEquipUnicode();
            Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
            if(optional.isPresent()){
                ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
                allAddress.add(this.concatDetailAddress(esEquipmentCategoryDto));
            }
        });
        return String.join(",", allAddress);
    }

    private String concatDetailAddress(ESEquipmentCategoryDto esEquipmentCategoryDto) {
        // 省、市、区
        String usePlace = esEquipmentCategoryDto.getUSE_PLACE();
        // 详细地址
        String address = esEquipmentCategoryDto.getADDRESS();
        return String.format("%s%s",usePlace, address);
    }
}
