package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipTechParamPipeline;
import org.apache.ibatis.annotations.Param;

public interface EquipTechParamPipelineMapper extends BaseMapper<EquipTechParamPipeline> {
    /**
     * 在用的最新需求整理的技术参数--需求未出
     *
     * @param record 设备唯一标识
     * @return EquipTechParamVessel
     */
    EquipTechParamPipeline queryTechParamInUse(@Param("record") String record);

    /**
     * 统计压力管道长度
     *
     * @param cityCode 区域code
     * @return 数量
     */
    String sumPipeLengthByArea(String cityCode);
}
