package com.yeejoin.amos.fas.business.action.model;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import lombok.Data;

import java.math.BigDecimal;

@RuleFact(value = "风险点-关联巡检点",project = "风险管控")
@Data
public class RiskSourceRuleRo extends BasicsRo {

    private static final long serialVersionUID = -1029442967802232957L;
    /**
     * patrol、equipment、update、delete
     */
    @Label("触发来源")
    private String type;
    @Label("序号")
    private Long id;
    @Label("rpnr")
    private BigDecimal rpnr;
    @Label("rpni")
    private BigDecimal rpni;

    /**
     * 风险增益
     */
    @Label("风险增益")
    private String rg;
    /**
     * up、down、no
     */
    @Label("等级变更类型")
    private String levelChangeType;

    /**
     * 消息内容
     */
    @Label("消息内容")
    private String content;

    /**
     * 消息标题
     */
    @Label("消息标题")
    private String title;
}
