package com.yeejoin.amos.boot.module.jg.biz.event.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jg.api.dto.ESDataChangeLogDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgBizChangeLog;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import com.yeejoin.amos.boot.module.jg.biz.event.ChangeDataEvent;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgBizChangeLogServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgInstallationNoticeServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.UseRegisterDataChangeHandleImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Date;
import java.util.Set;

@Component
@RequiredArgsConstructor
@Slf4j
public class InstallNoticeChangeEventHandler implements IChangeEventBizHandler<ChangeDataEvent> {

    private final JgInstallationNoticeServiceImpl jgInstallationNoticeService;

    private final JgBizChangeLogServiceImpl jgBizChangeLogService;

    @Override
    @Async
    public void handle(ChangeDataEvent event) {
        log.info("开始更新安装告知json数据：{}", event);
        // 查询关联的单据-未删除且已完成状态
        Set<Long> installationNoticeIds = this.getRelationInstallNoticeList(event);
        // 更新历史json
        installationNoticeIds.forEach(seq -> {
            // 更新json
            JgInstallationNotice installationNotice = jgInstallationNoticeService.getById(seq);
            // 查询之前数据json
            JSONObject beforeData = jgInstallationNoticeService.getHisData(installationNotice);
            jgInstallationNoticeService.saveHisDataBeforeUpdate(installationNotice);
            // 查询之后数据json
            JSONObject afterData = jgInstallationNoticeService.getHisData(installationNotice);
            // es记录日志
            this.log2es(beforeData, afterData, installationNotice, event);
        });
        log.info("更新安装告知的单据数量：{}", installationNoticeIds.size());
    }

    private void log2es(JSONObject beforeData, JSONObject afterData, JgInstallationNotice installationNotice, ChangeDataEvent event) {
        Date date = DateUtil.date();
        JgBizChangeLog changeLog = new JgBizChangeLog();
        BeanUtil.copyProperties(event.getBizRelationData(), changeLog);
        changeLog.setBizTable("tzs_jg_installation_notice");
        changeLog.setRecDate(date);
        changeLog.setBizId(installationNotice.getApplyNo());
        // todo 与原始编辑进行关联
        changeLog.setOId(event.getRequestContext().getTraceId());
        changeLog.setBizType("installationNotice");
        changeLog.setRecUserId(event.getRequestContext().getExcutedUserId());
        ESDataChangeLogDto esDataChangeLogDto = new ESDataChangeLogDto();
        esDataChangeLogDto.setColumnKey("changeData");
        esDataChangeLogDto.setColumnKeyLabel("历史json数据");
        esDataChangeLogDto.setBeforeData(beforeData.toJSONString());
        esDataChangeLogDto.setAfterData(afterData.toJSONString());
        esDataChangeLogDto.setUserId(event.getRequestContext().getExcutedUserId());
        esDataChangeLogDto.setCreateDate(date.getTime());
        esDataChangeLogDto.setRequestDate(DateUtil.formatDateTime(date));
        esDataChangeLogDto.setChangeId(installationNotice.getApplyNo());
        esDataChangeLogDto.setColumnFamily("tzs_jg_installation_notice");
        esDataChangeLogDto.setBizType(changeLog.getBizType());
        jgBizChangeLogService.save2DbAndEs(changeLog, Collections.singletonList(esDataChangeLogDto));
    }

    private Set<Long> getRelationInstallNoticeList(ChangeDataEvent event) {
        // 变化的设备
        Set<String> records = event.getBizRelationData().getRecords();
        // 查询关联的单据-已完成时更新其json
        return jgInstallationNoticeService.getBaseMapper().queryListByEqsAndStatus(records, FlowStatusEnum.TO_BE_FINISHED.getCode() + "");
    }

    @Override
    public Boolean supports(ChangeDataEvent event) {
        return UseRegisterDataChangeHandleImpl.BIZ_TYPE.equals(event.getBizRelationData().getBizType());
    }

}
