package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.entity.TzsBaseEntity;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.CommonMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationManageMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgUseRegistrationMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgUseRegistrationService;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.biz.config.LocalBadRequest;
import com.yeejoin.amos.boot.module.jg.biz.context.EquipUsedCheckStrategyContext;
import com.yeejoin.amos.boot.module.jg.biz.context.FlowingEquipRedisContext;
import com.yeejoin.amos.boot.module.jg.biz.event.CancellationEvent;
import com.yeejoin.amos.boot.module.jg.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.feign.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.biz.service.ICompensateFlowDataOfRedis;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgInspectionDetectionInfoService;
import com.yeejoin.amos.boot.module.jg.biz.utils.CodeUtil;
import com.yeejoin.amos.boot.module.ymt.api.common.StringUtil;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.*;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.seata.spring.annotation.GlobalTransactional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.IOUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Collectors.toSet;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Service
@Slf4j
public class JgUseRegistrationServiceImpl extends BaseService<JgUseRegistrationDto, JgUseRegistration, JgUseRegistrationMapper> implements IJgUseRegistrationService, ICompensateFlowDataOfRedis<JgUseRegistration>, ApplicationContextAware {

    private static final String DEFINITION_KEY = "useRegistration";
    private final List<String> NOT_FLOWING_STATE = Arrays.asList("使用单位待提交", "一级受理已驳回", "使用单位已撤回", "已作废");
    private final List<String> NOT_FLOWING_STATE_FINISH = new ArrayList<String>(NOT_FLOWING_STATE) {{
        add("已完成");
    }};
    private static final String CITY = "CITY";
    private static final String COUNTY = "COUNTY";
    private static final String REGION = "REGION";
    private static final String STREET = "STREET";
    public static final String carNumber = "carNumber";
    private ApplicationContext applicationContext;
    @Autowired
    RedisUtils redisUtils;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    JgRegistrationHistoryServiceImpl jgRegistrationHistoryService;
    @Autowired
    IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;
    @Autowired
    IdxBizJgDesignInfoMapper idxBizJgDesignInfoMapper;
    @Autowired
    IdxBizJgDesignInfoServiceImpl idxBizJgDesignInfoService;
    @Autowired
    ICommonService commonService;
    @Autowired
    CommonServiceImpl commonServiceImpl;
    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;
    @Autowired
    IdxBizJgSupervisionInfoMapper idxBizJgSupervisionInfoMapper;
    @Autowired
    TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;
    @Autowired
    EventPublisher eventPublisher;

    @Autowired
    IdxBizJgMaintenanceRecordInfoMapper maintenanceRecordInfoMapper;

    @Autowired
    DataDictionaryServiceImpl iDataDictionaryService;
    public static final String[] jsonFields = {"productPhoto", "factoryStandard", "productQualityYieldProve", "insUseMaintainExplain",
            "inspectReport", "designStandard", "designDoc", "longitudeLatitude", "otherAccessoriesDes", "otherAccessoriesFact",
            "otherAccessoriesReg", "installProxyStatementAttachment", "installContractAttachment", "insOtherAccessories",
            "maintenanceContract", "maintOtherAccessories", "installProxyStatementAttachment", "installContractAttachment",
            "insOtherAccessories", "maintenanceContract", "factSupervisionInspectionReport", "boilerEnergyEfficiencyCertificate"};
    @Autowired
    CodeUtil codeUtil;
    @Autowired
    WorkFlowFeignService workFlowFeignService;
    @Autowired
    private IdxBizJgUseInfoMapper useInfoMapper;
    @Autowired
    private InspectionDetectionInfoMapper inspectionDetectionInfoMapper;
    @Autowired
    private IdxBizJgOtherInfoMapper otherInfoMapper;
    @Autowired
    private JgUseRegistrationEqMapper jgRelationEquipMapper;
    @Autowired
    private ProduceInfoMapper produceInfoMapper;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;
    @Autowired
    private IdxBizJgFactoryInfoMapper idxBizJgFactoryInfoMapper;
    @Autowired
    IIdxBizJgInspectionDetectionInfoService iIdxBizJgInspectionDetectionInfoService;
    @Autowired
    private IdxBizJgMaintenanceRecordInfoServiceImpl idxBizJgMaintenanceRecordInfoService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private SnowflakeIdUtil sequence;
    @Autowired
    private JgUseRegistrationEqServiceImpl jgUseRegistrationEqService;
    @Autowired
    private JgUseRegistrationMapper jgUseRegistrationMapper;
    @Autowired
    private ESEquipmentCategory esEquipmentCategory;
    @Autowired
    private JgResumeInfoServiceImpl jgResumeInfoService;
    @Autowired
    private JgCertificateChangeRecordServiceImpl certificateChangeRecordService;
    @Autowired
    private JgUseRegistrationManageMapper jgUseRegistrationManageMapper;
    @Autowired
    private JgCertificateChangeRecordEqServiceImpl certificateChangeRecordEqService;
    @Autowired
    private JgUseRegistrationManageServiceImpl jgUseRegistrationManageService;
    @Autowired
    private IdxBizJgConstructionInfoServiceImpl idxBizJgConstructionInfoService;
    @Autowired
    private IdxBizJgConstructionInfoMapper constructionInfoMapper;
    @Autowired
    private SuperviseInfoMapper superviseInfoMapper;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;

    @Autowired
    IdxBizJgProjectContraptionServiceImpl jgProjectContraptionService;

    @Autowired
    IdxBizJgProjectConstructionMapper idxBizJgProjectConstructionMapper;

    @Autowired
    IdxBizJgProjectInspectionMapper projectInspectionMapper;

    @Autowired
    private DataDictionaryServiceImpl dataDictionaryServiceImpl;
    @Autowired
    private IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;
    @Autowired
    private RegistrationInfoMapper registrationInfoMapper;
    @Autowired
    private CommonMapper commonMapper;


    /**
     * @param auditPassDate   通过时间
     * @param exportParamsMap 参数map
     */
    static void getAuditPassedDate(Date auditPassDate, Map<String, Object> exportParamsMap) {
        LocalDate today;
        if (ValidationUtil.isEmpty(auditPassDate)) {
            // 发证日期为空取当前时间
            today = LocalDate.now();
        } else {
            today = auditPassDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        exportParamsMap.put("giveOutYear", today.getYear());
        exportParamsMap.put("giveOutMonth", String.format("%02d",today.getMonthValue()));
        exportParamsMap.put("giveOutDay", String.format("%02d",today.getDayOfMonth()));
    }

    static void getReissueDate(Date reissueDate, Map<String, Object> exportParamsMap) {
        if (!ValidationUtil.isEmpty(reissueDate)) {
            LocalDate date = reissueDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            exportParamsMap.put("reissueDateYear", date.getYear());
            exportParamsMap.put("reissueDateMonth", String.format("%02d",date.getMonthValue()));
            exportParamsMap.put("reissueDateDay", String.format("%02d",date.getDayOfMonth()));
        }
    }

    private static void toZipFile(HttpServletResponse response, List<CompletableFuture<byte[]>> futures, String filePrefix, String customFileName) {
        // 打包zip
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             ZipOutputStream zip = new ZipOutputStream(outputStream)) {

            for (int i = 0; i < futures.size(); i++) {
                try {
                    zip.putNextEntry(new ZipEntry(filePrefix + "第" + (i + 1) + "页" + ".pdf"));
                    IOUtils.write(futures.get(i).join(), zip);
                    zip.closeEntry(); // 每个条目结束后关闭
                } catch (IOException e) {
                    log.error("打包zip失败：" + e.getMessage());
                    throw new BadRequest("打包zip失败");
                }
            }
            // 所有条目写入完成后关闭 ZipOutputStream
            zip.finish();
            // 设置响应头并将压缩文件写入 HttpServletResponse
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/zip");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(customFileName, "UTF-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            IOUtils.write(outputStream.toByteArray(), response.getOutputStream());
        } catch (IOException e) {
            throw new RuntimeException("导出异常：", e);
        }
    }

    /**
     * 将 年月日 日期转为 年月 格式返回
     *
     * @param originalDateStr
     * @return
     */
    private static String timeToMonths(String originalDateStr) {
        if (StringUtils.isEmpty(originalDateStr)) {
            return "";
        }
        // 定义输入的日期格式
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        // 将字符串解析为LocalDate对象
        LocalDate date = LocalDate.parse(originalDateStr, inputFormatter);
        // 定义输出的日期格式
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM", Locale.CHINA);
        // 将LocalDate对象格式化为所需的字符串
        return date.format(outputFormatter);
    }

    public Page<Map<String, Object>> getList(JgUseRegistrationDto dto, String sort, Page<Map<String, Object>> page, List<String> roleIds, String client) {
        SortVo sortMap = commonServiceImpl.sortFieldConversionNoToUnderline(sort);
        return this.baseMapper.getListPage(page, sortMap, dto, roleIds, client);
    }

    public Page<Map<String, Object>> getEquipList(Page<Map<String, Object>> page, String factoryNum, String equList, String equCategory) {
        return this.baseMapper.getEquipListPage(page, factoryNum, equList, equCategory);
    }

    public void updateEquipMessage(String currentDocumentId, JgUseRegistration jgUseRegistration, JSONObject map,
                                   IdxBizJgRegisterInfo registerInfo, IdxBizJgOtherInfo otherInfo, Boolean flag, String useRegistrationCode, Map<String, Object> equipment) {
        String useOrgCode = jgUseRegistration.getUseRegistrationCode();
        // 市
        List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
        // 区
        List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
        // 街道
        List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");

        map.remove("status");
        map.remove("instanceId");
        // 安全管理员
        if (map.containsKey("safetyManagerName")) {
            map.put("safetyManager", map.get("safetyManagerName"));
            map.put("safetyManagerId", map.get("safetyManagerId"));
        }

        IdxBizJgUseInfo useInfo = new IdxBizJgUseInfo();
        BeanUtil.copyProperties(map, useInfo);
        if (map.containsKey("isXixian")) {
            useInfo.setIsNotXiXian(map.get("isXixian").toString());
        }
        // 城市
        if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
            city.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("city")))) {
                    useInfo.setCityName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 区县
        if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
            region.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("county")))) {
                    useInfo.setCountyName(String.valueOf(item.get("regionName")));
                }
            });
        }
        // 街道
        if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
            street.forEach(item -> {
                if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("factoryUseSiteStreet")))) {
                    useInfo.setStreetName(String.valueOf(item.get("regionName")));
                }
            });
        }
        useInfo.setProvince("610000");
        useInfo.setProvinceName("陕西省");
        LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
        lambda.eq(IdxBizJgUseInfo::getRecord, map.get("equipId"));
        // 产权单位信息
        if (map.containsKey("estateUnitName")) {
            String[] data = String.valueOf(map.getString("estateUnitName")).split("_");
            useInfo.setEstateUnitCreditCode(data[0]);
            useInfo.setEstateUnitName(data[1]);
        }
        // 修改设备使用状态为在用
        useInfo.setEquState(String.valueOf(EquimentEnum.ZAIYONG.getCode()));
        // 更新使用信息
        useInfoMapper.update(useInfo, lambda);
        // 更新检验检测信息
        this.updateOrCreateInspectionDetection(equipment, jgUseRegistration, registerInfo);
        // 更新注册登记信息表
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> IdxBizJgRegLambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
        IdxBizJgRegLambda.eq(IdxBizJgRegisterInfo::getRecord, map.get("equipId"))
                .set(IdxBizJgRegisterInfo::getRegisterState, this.getRegCode()).set(IdxBizJgRegisterInfo::getCylinderCategory, map.get("cylinderCategory"));
        idxBizJgRegisterInfoService.update(IdxBizJgRegLambda);
        // 更新设备监管部门
        IdxBizJgSupervisionInfo idxBizJgSupervisionInfo = new IdxBizJgSupervisionInfo();
        if (map.containsKey("orgBranchCode") && !ObjectUtils.isEmpty(map.get("orgBranchCode"))) {
            String[] data = String.valueOf(map.getString("orgBranchCode")).split("_");

            HashMap<String, Object> parentMessage = (HashMap<String, Object>) Privilege.companyClient.queryByOrgcode(data[0]).getResult();
            // 目前平台返回key为compnay(存在拼写错误)
            CompanyModel parentModel = JSON.parseObject(JSON.toJSONString(parentMessage.get("compnay")), CompanyModel.class);

            idxBizJgSupervisionInfo.setOrgBranchCode(data[0]);
            idxBizJgSupervisionInfo.setOrgBranchName(data[1]);
            idxBizJgSupervisionInfo.setCompanyOrgBranchCode(parentModel.getCompanyCode());
            LambdaQueryWrapper<IdxBizJgSupervisionInfo> eq = new QueryWrapper<IdxBizJgSupervisionInfo>().lambda().eq(IdxBizJgSupervisionInfo::getRecord, map.get("equipId"));
            idxBizJgSupervisionInfoMapper.update(idxBizJgSupervisionInfo, eq);
        }
        // 更新设备使用登记证
        idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(String.valueOf(map.get("equipId")), flag ? useRegistrationCode : useOrgCode);
        // 生成监管码、96333码(管道合并到有证不生成)
        createCode(map, jgUseRegistration, registerInfo, useInfo, otherInfo);
        if ("2".equals(jgUseRegistration.getRegType()) && "3000".equals(map.getString("equList"))) {
            // 电梯处理维保信息
            this.historyEquUpdateMaintenanceInfo(map);
        }
    }

    private void updateOrCreateInspectionDetection(Map<String, Object> equipment, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo registerInfo) {
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        BeanUtil.copyProperties(equipment, inspectionDetectionInfo);
        if("unit".equals(jgUseRegistration.getManageType())){
            if (registerInfo.getEquList().equals(EquipmentClassifityEnum.YLGD.getCode())){
                // 压力管道逻辑，根据设备record + 检验报告编号判定唯一一条检验流水，有进行更新，无则进行插入
                String record = (String) equipment.get("record");
                inspectionDetectionInfo.setInspectConclusion((String) equipment.get("inspectConclusionCode"));
                inspectionDetectionInfo.setSequenceNbr((String) equipment.get("jySeq"));
                saveEquipOfPieLineInspectData(record, inspectionDetectionInfo);
            }
        } else {
            // 其他逻辑
            if (equipment.get("jySeq") != null) {
                // 更新逻辑
                InspectionDetectionInfo inspectionDetectionInfoDb = inspectionDetectionInfoMapper.selectById(equipment.get("jySeq").toString());
                String inspectionSeq = inspectionDetectionInfoDb.getSequenceNbr();
                String record = inspectionDetectionInfoDb.getRecord();
                Bean.copyExistPropertis(inspectionDetectionInfo, inspectionDetectionInfoDb);
                inspectionDetectionInfoDb.setSequenceNbr(inspectionSeq);
                inspectionDetectionInfoDb.setRecord(record);
                inspectionDetectionInfoDb.setRecDate(new Date());
                inspectionDetectionInfoMapper.updateById(inspectionDetectionInfoDb);
            } else {
                String record = Optional.ofNullable(equipment.get("equipId"))
                        .map(Object::toString)
                        .orElse("");
                // 插入逻辑
                if (inspectionDetectionInfo.getInspectType() != null && inspectionDetectionInfo.getInspectConclusion() != null) {
                    inspectionDetectionInfo.setRecord(record);
                    inspectionDetectionInfo.setRecDate(new Date());
                    inspectionDetectionInfo.setSequenceNbr(sequence.nextId() + "");
                    inspectionDetectionInfoMapper.insert(inspectionDetectionInfo);
                }
            }
        }
    }

    private void saveEquipOfPieLineInspectData(String record, InspectionDetectionInfo inspectionDetectionInfo) {
        // 检验机构 + 设备+ 检验报告编号时 ， 是唯一的为了防止老数据有重复的，程序健壮，故使用list进行处理
        // LambdaQueryWrapper<InspectionDetectionInfo> wrapper = new LambdaQueryWrapper<>();
        // wrapper.eq(AbstractEquipBaseEntity::getRecord, record)
        //      .eq(!StringUtils.isEmpty(inspectionDetectionInfo.getInspectReportNo()), InspectionDetectionInfo::getInspectReportNo, inspectionDetectionInfo.getInspectReportNo())
        //    .eq(InspectionDetectionInfo::getInspectOrgCode, inspectionDetectionInfo.getInspectOrgCode());
        // List<InspectionDetectionInfo> inspectionDetectionInfos = inspectionDetectionInfoMapper.selectList(wrapper);
        inspectionDetectionInfo.setRecDate(new Date());
        if (Objects.isNull(inspectionDetectionInfo.getSequenceNbr())) {
            inspectionDetectionInfo.setSequenceNbr(sequence.nextId() + "");
            inspectionDetectionInfo.setRecord(record);
            inspectionDetectionInfoMapper.insert(inspectionDetectionInfo);
        } else {
            inspectionDetectionInfoMapper.updateById(inspectionDetectionInfo);
        }
    }

    /**
     * 获取类型为ZC的“已注册”的字典值
     *
     * @return code
     */
    private String getRegCode() {
        QueryWrapper<DataDictionary> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", "ZC");
        queryWrapper.eq("name", "已注册");
        queryWrapper.eq("is_delete", false);
        List<DataDictionary> list = iDataDictionaryService.list(queryWrapper);
        if (!list.isEmpty() && list.get(0) != null) {
            DataDictionary dictionary = list.get(0);
            return Optional.ofNullable(dictionary).map(DataDictionary::getCode).orElse("");
        }
        return "";
    }

    public void updateHistory(JSONObject map, String equipId, String currentDocumentId, String supervisoryCode) {
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        // lambda.eq(JgRegistrationHistory::getEquId, equipId);
        lambda.eq(JgRegistrationHistory::getCurrentDocumentId, currentDocumentId);
        lambda.eq(JgRegistrationHistory::getRegistrationClass, "使用登记");
        lambda.eq(JgRegistrationHistory::getIsDelete, false);
        Integer integer = jgRegistrationHistoryService.getBaseMapper().selectCount(lambda);
        if (integer > 0) {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistoryService.update(jgRegistrationHistory, lambda);
        } else {
            jgRegistrationHistory.setChangeData(JSON.toJSONString(map));
            jgRegistrationHistory.setStatus("new");
            jgRegistrationHistory.setRegistrationClass("使用登记");
            jgRegistrationHistory.setSupervisoryCode(supervisoryCode);
            jgRegistrationHistory.setEquId(equipId);
            jgRegistrationHistory.setCurrentDocumentId(currentDocumentId);
            jgRegistrationHistoryService.save(jgRegistrationHistory);
        }

    }

    /**
     * 按单位办理或按台套办理
     *
     * @param map map
     * @return list
     */
    public List<Map<String, Object>> save(JSONObject map) {
        Map<String, Function<JSONObject, List<Map<String, Object>>>> functionMap = MapBuilder.<String, Function<JSONObject, List<Map<String, Object>>>>create()
                .put("unit", this::handleUnitUseRegistration).build();
        Function<JSONObject, List<Map<String, Object>>> function = functionMap.getOrDefault(map.getString("manageType"), this::handleUseRegistration);
        return function.apply(map);
    }

    /**
     * 按台套办理
     *
     * @param map map
     * @return list
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<Map<String, Object>> handleUseRegistration(JSONObject map) {
        try {
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 校验登记表字段是否有值
                JSONArray useRegistrationFormFile = map.getJSONArray("useRegistrationFormFile");
                if (CollUtil.isEmpty(useRegistrationFormFile)) {
                    throw new BadRequest("请上传使用登记表（签章后）附件！");
                }
            }
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            // 提交时进行校验设备是否在流程中使用（并发及同时打开多个相同的页面时才会出现此种情况）
            checkForRepeatUsedEquip(map, company);
            // 使用登记信息
            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            jgUseRegistration.setRegDate(new Date());
            jgUseRegistration.setCreateDate(new Date());
            LambdaQueryWrapper<IdxBizJgOtherInfo> otherLambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
            otherLambda.eq(IdxBizJgOtherInfo::getRecord, map.get("equipId"));
            IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
            String supervisoryCode = otherInfo.getSupervisoryCode();
            jgUseRegistration.setSupervisoryCode(supervisoryCode);
            jgUseRegistration.setManageType("set");

            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                jgUseRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            String equType = this.baseMapper.getEquType(String.valueOf(map.get("equipId")));
            if (map.containsKey("receiveOrgCode")) {
                // 接收单位信息
                String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
                jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
                jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);
                jgUseRegistration.setReceiveCompanyOrgCode(commonService.getOneCompany(jgUseRegistration.getReceiveCompanyCode()).getOrgCode());
            }
            if (map.containsKey("orgBranchCode")) {
                // 监察处置机构代码
                String[] splitOrgBranchCode = String.valueOf(map.getString("orgBranchCode")).split("_");
                jgUseRegistration.setSupervisionOrgCode(splitOrgBranchCode[0]);
            }
            // 安全管理员
            if (map.containsKey("safetyManager")) {
                String[] data = String.valueOf(map.getString("safetyManager")).split("_");
                map.put("safetyManagerId", data[0]);
                map.put("safetyManagerName", data[1]);
            }
            // 使用单位提交
            jgUseRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            jgUseRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            jgUseRegistration.setCreateUserName(reginParams.getUserModel().getUserName());
            if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
                jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
            }
            if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
                jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
            }
            // 是否西咸
            if (!ObjectUtils.isEmpty(map.get("isXixian"))) {
                jgUseRegistration.setIsXixian(String.valueOf(map.get("isXixian")));
            }
            // 使用地点
            // 市
            List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
            // 区
            List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
            // 街道
            List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");
            jgUseRegistration.setUseAddress("陕西省");
            // 城市
            if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
                city.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("city")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 区县
            if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
                region.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("county")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 街道
            if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
                street.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("factoryUseSiteStreet")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + map.get("address"));
            Optional.ofNullable(map.get("useRegistrationFormFile"))
                    .map(JSONObject::toJSONString)
                    .ifPresent(jgUseRegistration::setUseRegistrationFormFile);
            map.put("userName", reginParams.getUserModel().getRealName());
            Map<String, Object> useRegistrationFormUrlMap = commonService.getRegistrationFormUrl("set", map);
            Optional.ofNullable(useRegistrationFormUrlMap)
                    .ifPresent(item -> jgUseRegistration.setUseRegistrationFormUrl(String.valueOf(item.get("useRegistrationFormUrl"))));
            if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
                jgUseRegistration.setUseUnitCreditCode(null);
                jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
                this.getBaseMapper().updateById(jgUseRegistration);
                // 更新设备关联表
                LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
                lambda.eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
                JgUseRegistrationEq jgUseRegistrationEq = new JgUseRegistrationEq();
                jgUseRegistrationEq.setEquId(map.get("equipId").toString());
                jgRelationEquipMapper.update(jgUseRegistrationEq, lambda);
                // 历史设备登记生成的 编辑时更新使用登记证管理表
                updateRegistrationManage(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            } else {

                // 业务管理设备信息保存
                JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
                jgRelationEquip.setEquId(map.get("equipId").toString());
                //            List<String> applicationFormCode = iCreateCodeServicevice.createApplicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
                //            jgUseRegistration.setApplyNo(applicationFormCode.get(0));
                //            ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
                ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.getCode.get(String.valueOf(map.get("businessCode"))), 1);
                if (!ObjectUtils.isEmpty(listResponseModel)) {
                    jgUseRegistration.setApplyNo(listResponseModel.getResult().get(0));
                }
                jgUseRegistration.setAuditStatus("待提交");//字段不用
                jgUseRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
                jgUseRegistration.setRegType("2".equals(map.get("regType")) ? "2" : "0");
                this.save(jgUseRegistration);
                jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
                jgRelationEquipMapper.insert(jgRelationEquip);
            }
            // 暂存历史表
            updateHistory(map, map.get("equipId").toString(), String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 删除暂存代办
                commonServiceImpl.deleteTasksByRelationId(String.valueOf(jgUseRegistration.getSequenceNbr()));
                String instanceId = "";
                if (!ObjectUtils.isEmpty(map.get("instanceId"))) {
                    instanceId = map.get("instanceId").toString();
                } else {
                    // 启动并执行流程
                    //                instanceId = startByVariable();
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    ArrayList<ActWorkflowStartDTO> list = new ArrayList<>();
                    dto.setProcessDefinitionKey(DEFINITION_KEY);
                    dto.setBusinessKey("1");
                    dto.setCompleteFirstTask(Boolean.TRUE);
                    // 接受机构
                    dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                    list.add(dto);
                    actWorkflowBatchDTO.setProcess(list);
                    List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                    List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
                    if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                        WorkflowResultDto workflowResultDto = resultDto.get(0);
                        updateData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, "", Boolean.TRUE, null);
                    }
                }

                if (!ObjectUtils.isEmpty(instanceId)) {
                    // 执行流程
                    flowExecute(jgUseRegistration.getSequenceNbr(), instanceId, "0", "", "", map.getString("manageType"), String.valueOf(map.get("nextTaskId")), map);
                }
            } else {
                if (ObjectUtils.isEmpty(map.get("instanceId"))) {
                    ArrayList<TaskModelDto> list = new ArrayList<>();
                    TaskModelDto dto = new TaskModelDto();
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                    taskMessageDto.setEquipId(String.valueOf(map.get("equipId")));
                    taskMessageDto.setEQU_LIST_CODE(String.valueOf(map.get("EQU_LIST_CODE")));
                    // 数据参数
                    dto.setModel(taskMessageDto);
                    // 摘要
//                    dto.setTaskContent("来自" + equType + "【" + (ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode()) ? "无" : jgUseRegistration.getSupervisoryCode()) + "】的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
                    dto.setTaskContent("来自" + equType + "的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
                    // 申请单号
                    dto.setTaskCode(jgUseRegistration.getApplyNo());
                    // 业务类型
                    dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()));
                    // 业务主键
                    dto.setRelationId(String.valueOf(jgUseRegistration.getSequenceNbr()));
                    dto.setNextExecuteUser("");
                    list.add(dto);
                    commonServiceImpl.buildTaskModel(list);
                }
            }
            return this.baseMapper.getDetailById(jgUseRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    private void rollBackForDelRedisData() {
        FlowingEquipRedisContext.getContext().forEach(e -> {
            EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY).delDataForCheckWithKey(e.getData(), e.getRedisKey());
        });
    }

    private void checkForRepeatUsedEquip(JSONObject map, CompanyBo company) {
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            // 流程中或已完成
            EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY).equipRepeatUsedCheck(map.get("equipId").toString(),
                    CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ? company.getCompanyCode().split("_")[1] : company.getCompanyCode());
        }
    }

    private void checkForRepeatUsedEquip(JSONObject map, List<Map<String, Object>> equList, CompanyBo company) {
        // 个人主体的身份证（6600_620422199903010258） 特殊处理 只取_后的身份证号码
        if (!ObjectUtils.isEmpty(map.get("submit"))) {
            equList.forEach(equip -> {
                // 流程中或已完成
                EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY).equipRepeatUsedCheck(equip.get("record").toString(),
                        CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ? company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            });
        }
    }

    private void clearDataForCheckEquipRepeatUsed(JgUseRegistration data) {
        // 新查询原因 useRegistration 数据状态是旧的
        JgUseRegistration useRegistrationDb = this.getById(data.getSequenceNbr());
        LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        lambda.eq(JgUseRegistrationEq::getEquipTransferId, data.getSequenceNbr());
        lambda.select(JgUseRegistrationEq::getEquId);
        List<JgUseRegistrationEq> eqList = jgRelationEquipMapper.selectList(lambda);
        // 在使用单位待提交、一级受理已驳回、使用单位已撤回后清除关联的设备，保证可以再次新提单子选择相同的设备进行提交及原有单子的提交校验数据准备
        if (NOT_FLOWING_STATE.contains(useRegistrationDb.getStatus()) ||
                FlowStatusEnum.TO_BE_DISCARD.getName().equals(data.getStatus())) {
            List<String> records = eqList.stream().map(JgUseRegistrationEq::getEquId).collect(toList());
            //合并的管道只需要子工程装置管道集合
            if (Objects.nonNull(data.getOriginProjectContraptionIds()) &&
                    !data.getOriginProjectContraptionIds().contains(data.getProjectContraptionId())){
                List<IdxBizJgUseInfo> useInfoRecords = idxBizJgUseInfoService.lambdaQuery()
                        .select(IdxBizJgUseInfo::getRecord)
                        .in(IdxBizJgUseInfo::getProjectContraptionId, Arrays.asList(data.getOriginProjectContraptionIds().split(",")))
                        .list();
                records = useInfoRecords.stream().map(IdxBizJgUseInfo::getRecord).collect(Collectors.toList());
            }
            EquipUsedCheckStrategyContext.getUsedStrategy(DEFINITION_KEY)
                    .delDataForCheckEquipRepeatUsed(records, data.getUseUnitCreditCode());
        }
    }

    /**
     * 按单位办理
     *
     * @param map map
     * @return list
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<Map<String, Object>> handleUnitUseRegistration(JSONObject map) {
        try {
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 校验登记表字段是否有值
                JSONArray useRegistrationFormFile = map.getJSONArray("useRegistrationFormFile");
                if (CollUtil.isEmpty(useRegistrationFormFile)) {
                    throw new BadRequest("请上传使用登记表（签章后）附件！");
                }
            }
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())) + "", ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            String equListCode = String.valueOf(map.get("EQU_LIST_CODE"));
            List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) map.get("equipmentLists");
            if (CollectionUtils.isEmpty(equipmentLists)) {
                throw new BadRequest("请选择设备信息!");
            }

            if (CylinderTypeEnum.CYLINDER.getCode().equals(map.get("EQU_CATEGORY_CODE"))) {
                boolean hasExistingCertificate = this.baseMapper.selectList(
                        new LambdaQueryWrapper<JgUseRegistration>()
                                .eq(JgUseRegistration::getUseUnitCreditCode, CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                                        company.getCompanyCode().split("_")[1] : company.getCompanyCode())
                                .eq(JgUseRegistration::getIsDelete, false)
                                .eq(JgUseRegistration::getStatus, "已完成")
                ).stream().anyMatch(v -> !ObjectUtils.isEmpty(v.getUseRegistrationCode()) && v.getUseRegistrationCode().contains("瓶30"));
                if (hasExistingCertificate && map.get("isAddEquip").equals("0")) {
                    throw new BadRequest("该企业已存在气瓶证书，请选择增补功能进行登记！");
                }
            }

            // 压力管道逻辑(如果是合并到已有证的工程装置，需要去除已完成设备)
            Set<Object> excludedRecords = EquipmentClassifityEnum.YLGD.getCode().equals(equListCode) ?
                    idxBizJgUseInfoService.lambdaQuery()
                            .eq(IdxBizJgUseInfo::getProjectContraptionId, map.get("projectContraptionId"))
                            .list().stream()
                            .map(IdxBizJgUseInfo::getRecord)
                            .collect(Collectors.toSet())
                    : Collections.emptySet();

            if (EquipmentClassifityEnum.YLGD.getCode().equals(equListCode)) {
                equipmentLists.forEach(equip -> {
                    if ((equip.get("inspectReportNo") == null || equip.get("inspectReportNo").toString().isEmpty()) ||
                            (equip.get("inspectOrgCode") == null || equip.get("inspectOrgCode").toString().isEmpty())) {
                        throw new BadRequest("检验信息不能为空，请完善检验信息后进行登记！");
                    }
                });
            }

            List<Map<String, Object>> filteredEquipmentLists = equipmentLists.stream()
                    .filter(equipment -> !excludedRecords.contains(equipment.get("record")))
                    .collect(Collectors.toList());

            // 提交时进行校验设备是否在流程中使用（并发及同时打开多个相同的页面时才会出现此种情况）
            checkForRepeatUsedEquip(map, filteredEquipmentLists, company);

            JgUseRegistration useRegistration = JSON.parseObject(JSON.toJSONString(map), JgUseRegistration.class);
            useRegistration.setRegDate(new Date());
            useRegistration.setCreateDate(new Date());
            useRegistration.setManageType(map.getString("manageType"));
            useRegistration.setPromoter(reginParams.getUserModel().getUserId());
            useRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            useRegistration.setCreateUserName(reginParams.getUserModel().getUserName());
            useRegistration.setCylinderCategory(map.getString("cylinderCategory"));//气瓶分类
            // 使用单位信息
            useRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            useRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            // 接收单位信息
            Optional.ofNullable(useRegistration.getReceiveOrgCode())
                    .filter(code -> code.contains("_"))
                    .map(code -> code.split("_"))
                    .ifPresent(splitReceiveOrgCode -> {
                        CompanyModel result = Privilege.companyClient.queryByCompanyCode(splitReceiveOrgCode[0]).getResult();
                        useRegistration.setReceiveOrgCode(splitReceiveOrgCode[0]);
                        useRegistration.setReceiveCompanyOrgCode(splitReceiveOrgCode[0]);
                        useRegistration.setReceiveCompanyCode(result.getCompanyCode());
                        useRegistration.setReceiveOrgName(splitReceiveOrgCode[1]);
                    });

            // 安全管理员
            Optional.ofNullable(map.getString("safetyManager"))
                    .filter(manager -> manager.contains("_"))
                    .map(manager -> manager.split("_"))
                    .ifPresent(data -> {
                        map.put("safetyManagerId", data[0]);
                        map.put("safetyManagerName", data[1]);
                    });

            // 其他附件
            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                useRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            if (map.containsKey("orgBranchCode")) {
                // 监察处置机构代码
                String[] splitOrgBranchCode = String.valueOf(map.getString("orgBranchCode")).split("_");
                useRegistration.setSupervisionOrgCode(splitOrgBranchCode[0]);
            }

            // 使用地点
            Map<String, List<LinkedHashMap>> locationMap = MapBuilder.<String, List<LinkedHashMap>>create()
                    .put("city", (List<LinkedHashMap>) redisUtils.get("CITY"))
                    .put("county", (List<LinkedHashMap>) redisUtils.get("REGION"))
                    .put("factoryUseSiteStreet", (List<LinkedHashMap>) redisUtils.get("STREET"))
                    .build();
            String fullAddress = locationMap.entrySet().stream()
                    .map(entry -> {
                        String mapKey = String.valueOf(map.get(entry.getKey()));
                        List<LinkedHashMap> locations = entry.getValue();
                        return (!ObjectUtils.isEmpty(mapKey) && !ObjectUtils.isEmpty(locations)) ?
                                locations.stream()
                                        .filter(item -> mapKey.equals(String.valueOf(item.get("regionCode"))))
                                        .map(item -> String.valueOf(item.get("regionName")))
                                        .findFirst()
                                        .orElse("") :
                                "";
                    })
                    .collect(Collectors.joining());

            // 具体地址
            useRegistration.setUseAddress("陕西省" + fullAddress + map.get("address"));
            useRegistration.setOriginProjectContraptionIds((String) map.get("originProjectContraptionIds"));
            // 使用登记表
            Optional.ofNullable(map.get("useRegistrationFormFile"))
                    .map(JSONObject::toJSONString)
                    .ifPresent(useRegistration::setUseRegistrationFormFile);
            map.put("userName", reginParams.getUserModel().getRealName());
            Map<String, Object> useRegistrationFormUrlMap = commonService.getRegistrationFormUrl("unit", map);
            Optional.ofNullable(useRegistrationFormUrlMap)
                    .ifPresent(item -> useRegistration.setUseRegistrationFormUrl(String.valueOf(item.get("useRegistrationFormUrl"))));
            // 新增或编辑保存
            if (StringUtils.isEmpty(useRegistration.getSequenceNbr())) {
                ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.getCode.get(String.valueOf(map.get("businessCode"))), 1);
                if (!ObjectUtils.isEmpty(listResponseModel) && listResponseModel.getStatus() != HttpStatus.OK.value()) {
                    log.error("使用登记申请单单号获取失败！");
                    throw new BadRequest("使用登记申请单单号获取失败！");
                }
                useRegistration.setApplyNo(listResponseModel.getResult().get(0));
                useRegistration.setAuditStatus("待提交");
                useRegistration.setStatus(WorkFlowStatusEnum.USE_SUBMIT.getPass());
                useRegistration.setRegType("2".equals(map.get("regType")) ? "2" : "0");
                this.save(useRegistration);
            } else {
                this.updateById(useRegistration);
                // 删除设备关联表记录
                jgRelationEquipMapper.delete(new QueryWrapper<JgUseRegistrationEq>().lambda().eq(JgUseRegistrationEq::getEquipTransferId, useRegistration.getSequenceNbr()));
            }
            // 更新关联气瓶信息
            List<JgUseRegistrationEq> equipList = equipmentLists.stream()
                    .map(x -> new JgUseRegistrationEq()
                            .setEquId(String.valueOf(x.get("record")))
                            .setOriginProjectContraptionId(String.valueOf(x.get("projectContraptionId")))
                            .setEquipTransferId(String.valueOf(useRegistration.getSequenceNbr())))
                    .collect(Collectors.toList());
            // 保存关联设备信息
            jgUseRegistrationEqService.saveBatch(equipList);

            // 启动流程
            if (!ObjectUtils.isEmpty(map.get("submit"))) {
                // 删除暂存代办
                commonServiceImpl.deleteTasksByRelationId(String.valueOf(useRegistration.getSequenceNbr()));
                // 新增提交，没有instanceId需要发起流程
                if (StringUtils.isEmpty(useRegistration.getInstanceId())) {
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(DEFINITION_KEY);
                    dto.setBusinessKey(useRegistration.getApplyNo());
                    dto.setCompleteFirstTask(true);
                    dto.setNextExecuteUserCompanyCode(useRegistration.getReceiveCompanyCode());
                    ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                    actWorkflowBatchDTO.setProcess(Collections.singletonList(dto));

                    List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                    List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);

                    resultDto.stream()
                            .findFirst()
                            .ifPresent(workflowResultDto ->
                                    this.updateUseRegUnitData(useRegistration.getSequenceNbr(), "0", workflowResultDto, true, null));
                } else {
                    // 执行流程
                    flowExecute(useRegistration.getSequenceNbr(), useRegistration.getInstanceId(), "0", "", "", map.getString("manageType"), String.valueOf(map.get("nextTaskId")), map);
                }
            } else {
                String equType = this.baseMapper.getEquType(equListCode);
                TaskMessageDto  messageDto = BeanUtil.copyProperties(useRegistration, TaskMessageDto.class);
                messageDto.setEQU_LIST_CODE(equListCode);
                TaskModelDto dto = TaskModelDto.builder()
                        .model(BeanUtil.copyProperties(useRegistration, TaskMessageDto.class))
                        .taskContent("来自" + equType + "的业务办理,"
                                + "【申请单号：" + useRegistration.getApplyNo() + "】")
                        .taskCode(useRegistration.getApplyNo())
                        .taskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()))
                        .relationId(String.valueOf(useRegistration.getSequenceNbr()))
                        .nextExecuteUser("")
                        .build();
                commonServiceImpl.buildTaskModel(Collections.singletonList(dto));
            }
            // 设备数据存历史数据，在流程完成时使用
            updateHistory(map, null, String.valueOf(useRegistration.getSequenceNbr()), useRegistration.getSupervisoryCode());
            return this.baseMapper.getDetailById(useRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    /**
     * 单位批量办理数据处理
     *
     * @param sequenceNbr       主键
     * @param operate           操作类型
     * @param workflowResultDto 工作流返回
     * @param isFirst           是否first
     */
    private void updateUseRegUnitData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, Boolean isFirst, JSONObject jsonObject) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())) + "", ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
        jgUseRegistration.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        if (isFirst) {
            jgUseRegistration.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        }

        // 非完成，进行审核
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setInstanceStatus(
                    Optional.ofNullable(jgUseRegistration.getInstanceStatus())
                            .map(status -> String.join(",", status, role))
                            .orElse(role)
            );
            // 通过或者驳回
            jgUseRegistration.setStatus("0".equals(operate) ?
                    Objects.requireNonNull(WorkFlowStatusEnum.getMessage(taskCode)).getPass() :
                    Objects.requireNonNull(WorkFlowStatusEnum.getMessage(taskCode)).getReject());

            jgUseRegistration.setPromoter("0".equals(operate) ? reginParams.getUserModel().getUserId() : "");
            if (isFirst) {
                this.buildTask(jgUseRegistration, workflowResultDto);
            } else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgUseRegistration.getInstanceId());
                params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("flowStatusLabel", jgUseRegistration.getStatus());
                params.put("taskStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("taskStatusLabel", jgUseRegistration.getStatus());
                TaskMessageDto taskMessageDto = new TaskMessageDto();
                this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
                params.put("model", taskMessageDto);
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)) {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    TaskMessageDto taskMessageDto1 = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto1);
                    this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto1);
                    // taskMessageDto.setEquipId(jgUseRegistrationEq.getEquId());
                    taskModelDto.setModel(taskMessageDto1);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                        taskModelDto.setPageType("edit");
                    }
                    commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                } else {
                    workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                    buildTask(jgUseRegistration, workflowResultDto);
                }
            }
        } else {
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            jgUseRegistration.setNextExecuteUserIds("");

            // 更新代办
            TaskV2Model taskV2Model = updateAgency(jgUseRegistration);

            // 查询历史暂存表
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getOne(Wrappers.<JgRegistrationHistory>lambdaQuery()
                    .eq(JgRegistrationHistory::getCurrentDocumentId, String.valueOf(sequenceNbr))
                    .eq(JgRegistrationHistory::getIsDelete, false));
            // 登记证记录主键
            Long changeRecordId = sequence.nextId();

            JSONObject mapData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());

            String useRegistrationCode = null;
            Long useRegistrationManageSeq = null;
            AtomicReference<Boolean> flag = new AtomicReference<>(Boolean.FALSE);
            boolean isMerge = Boolean.FALSE;
            String equCategoryCode = String.valueOf(mapData.get("EQU_CATEGORY_CODE"));
            String equDefineCode = String.valueOf(mapData.get("EQU_DEFINE_CODE"));
            if (mapData.containsKey("equipmentLists") && !ObjectUtils.isEmpty(mapData.get("equipmentLists"))) {
                JSONArray objects = JSONObject.parseArray(mapData.get("equipmentLists").toString());
                if (!ObjectUtils.isEmpty(objects)) {
                    JSONObject object = JSONObject.parseObject(JSON.toJSONString(objects.get(0)));
                    if (object.containsKey("equDefine")) {
                        equDefineCode = String.valueOf(object.get("equDefine"));
                    }
                }
            }
            //如果是气瓶或工业管道判断之前是否已经做过使用登记
            if (CylinderTypeEnum.CYLINDER.getCode().equals(equCategoryCode)) {
                flag.set("1".equals(jgUseRegistration.getIsAddEquip()));
                if (flag.get()) {
                    useRegistrationCode = jgUseRegistration.getUseRegistrationCode();
                } else {
                    JgUseRegistrationManageDto dto = new JgUseRegistrationManageDto();
                    dto.setCertificateStatus(CertificateStatusEnum.YIDENGJI.getName());
                    dto.setUseUnitCreditCode(jgUseRegistration.getUseUnitCreditCode());
                    dto.setRegType("0");
                    useRegistrationCode = Optional.ofNullable(jgUseRegistrationManageMapper.queryByUseUnitCreditCode(dto))
                            .filter(list -> !list.isEmpty())
                            .flatMap(list -> list.stream()
                                    .map(JgUseRegistrationManageDto::getUseRegistrationCode)
                                    .filter(code -> code.startsWith("瓶30"))
                                    .findFirst())
                            .map(code -> {
                                flag.set(Boolean.TRUE);
                                return code;
                            })
                            .orElse(null);
                }
            }

            //管道，并且进行装置合并，且有使用登记证
            if (PipelineEnum.INDUSTRIAL_PIPELINE.getCode().equals(equCategoryCode)
                    && jgUseRegistration.getOriginProjectContraptionIds() != null
                    && !jgUseRegistration.getOriginProjectContraptionIds().contains(jgUseRegistration.getProjectContraptionId())
                    && Objects.nonNull(jgUseRegistration.getUseRegistrationCode())) {
                useRegistrationCode = jgUseRegistration.getUseRegistrationCode();
                flag.set(true);
                isMerge = true;
            }

            List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) mapData.get("equipmentLists");
//            String inspectConclusionName = getInspectConclusionName(mapData);
            IdxBizJgProjectContraption jgProjectContraption = null;
            if (!StringUtils.isEmpty(jgUseRegistration.getProjectContraptionId())) {
                jgProjectContraption = jgProjectContraptionService.getById(jgUseRegistration.getProjectContraptionId());
                boolean isFirstMerge = jgProjectContraption.getIsFirstMerge();
                mapData.put("isFirstMerge", isFirstMerge);
                // 装置表写入使用登记证编号、将装置名称写入到使用登记表
                updateRegAndProjectContraption(jgUseRegistration, mapData, jgProjectContraption);
                // 首次合并 + 特殊登记，给工程装置生成设备代码和监管码
                if (isFirstMerge || "2".equals(jgUseRegistration.getRegType())) {
                    Map<String, Object> createCodeMap = new HashMap<>();
                    createCodeMap.put("cityCode", jgProjectContraption.getCity());
                    createCodeMap.put("countyCode", jgProjectContraption.getCounty());
                    createCodeMap.put("equCategory", jgProjectContraption.getEquCategory());
                    createCodeMap.put("isXiXian", jgUseRegistration.getIsXixian() == null ? "null" : jgUseRegistration.getIsXixian().equals("0") ? "null" : "1");
                    ResponseModel<Map<String, Object>> resultModel = tzsServiceFeignClient.createCode(createCodeMap);
                    String superviseCode = resultModel.getResult().get("superviseCode").toString();
                    supervisoryCodeInfoMapper.updateStatusBySuperviseCode(superviseCode);
                    // 生成设备代码
                    String equCode = generateEquCode(jgProjectContraption.getEquList(), jgProjectContraption.getEquCategory(), jgProjectContraption.getEquDefine(),
                            new Date(), jgUseRegistration.getReceiveCompanyCode());
                    jgProjectContraption.setEquCode(equCode);
                    jgProjectContraption.setSupervisoryCode(superviseCode);
                }
            }
            if (!CollectionUtils.isEmpty(equipmentLists)) {
                for (int i = 0; i < equipmentLists.size(); i++) {
                    Map<String, Object> equipment = equipmentLists.get(i);
                    // 设备ID
                    String equId = (String) equipment.get("record");
                    mapData.put("equipId", equId);
                    mapData.put("isFirstEquip", i == 0);
                    // 注册信息
                    LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaReg = new QueryWrapper<IdxBizJgRegisterInfo>().lambda();
                    lambdaReg.eq(IdxBizJgRegisterInfo::getRecord, equId);
                    IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaReg);
                    // 其他信息
                    LambdaQueryWrapper<IdxBizJgOtherInfo> lambdaOth = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
                    lambdaOth.eq(IdxBizJgOtherInfo::getRecord, String.valueOf(mapData.get("equipId")));
                    IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(lambdaOth);
                    if (jgProjectContraption != null && (isMerge || (Boolean) mapData.get("isFirstMerge") || "2".equals(jgUseRegistration.getRegType()))) {
                        otherInfo.setSupervisoryCode(jgProjectContraption.getSupervisoryCode());
                        registerInfo.setEquCode(jgProjectContraption.getEquCode());
                    }

                    // 压力管道：[更新的原始引用]更新检验日期-nextInspectDate、检验结论-inspectConclusion、检验机构名称-inspectOrgName
//                    equipment.put("nextInspectDate", mapData.getOrDefault("nextInspectDate", ""));
//                    equipment.put("inspectOrgName", mapData.getOrDefault("inspectOrgName", ""));
//                    equipment.put("inspectConclusion", inspectConclusionName);
                    // 更新设备信息 && 生成使用登记证编号 && 同步es
                    this.processMapData(sequenceNbr, mapData, jgUseRegistration, jgRegistrationHistory, registerInfo, otherInfo, taskV2Model,
                            jsonObject, flag.get(), useRegistrationCode, equipment, isMerge);
                    // 查询设备制造信息
                    LambdaQueryWrapper<IdxBizJgFactoryInfo> factoryInfoWrapper = new LambdaQueryWrapper<>();
                    factoryInfoWrapper.eq(IdxBizJgFactoryInfo::getRecord, equId);
                    IdxBizJgFactoryInfo idxBizJgFactoryInfo = idxBizJgFactoryInfoService.getOne(factoryInfoWrapper);

                    // 生成tzs_jg_certificate_change_record_eq记录
                    JgCertificateChangeRecordEq changeRecordEq = new JgCertificateChangeRecordEq();
                    changeRecordEq.setChangeRecordId(String.valueOf(changeRecordId));//登记证记录主键
                    changeRecordEq.setEquId(registerInfo.getRecord());//设备主键
                    changeRecordEq.setProductCode(idxBizJgFactoryInfo.getFactoryNum());//产品编号
                    certificateChangeRecordEqService.save(changeRecordEq);
                }
            }
            // 更新工程装置信息
            if (Objects.nonNull(jgProjectContraption)) {
                jgProjectContraption.setUseRegistrationCode(jgUseRegistration.getUseRegistrationCode());
                jgProjectContraption.setUscUnitCreditCode("");
                jgProjectContraption.setUscUnitName("");
                jgProjectContraptionService.updateById(jgProjectContraption);
            }
            // 取第一条设备的注册消息--用来获取这一批设备的设备种类/类别/品种
            LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaReg = new QueryWrapper<IdxBizJgRegisterInfo>().lambda();
            lambdaReg.eq(IdxBizJgRegisterInfo::getRecord, String.valueOf(mapData.get("equipId")));
            IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaReg);
            // 单位办理的压力管道，在完成审批时，将检验信息写入到装置检验信息表
//            savePieLineProjectInspectData(jgUseRegistration, registerInfo, mapData);
            // 生成证书管理表
            generateRegistrationManage(jgUseRegistration, registerInfo, flag.get(), useRegistrationManageSeq);

            // 生成一条tzs_jg_certificate_change_record记录
            generateCertificateChangeRecord(jgUseRegistration, registerInfo, changeRecordId, taskV2Model, flag.get());
            // 更新历史表：下次检验日期、检验机构名称、检验结论在压力管道、气瓶时更新子表单的数据
            jgRegistrationHistory.setChangeData(JSON.toJSONString(mapData));
            jgRegistrationHistoryService.updateById(jgRegistrationHistory);
        }
        this.getBaseMapper().updateById(jgUseRegistration);
        commonServiceImpl.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
    }

    private void updateRegAndProjectContraption(JgUseRegistration jgUseRegistration, JSONObject mapData, IdxBizJgProjectContraption jgProjectContraption) {
        //总工程装置
        if(!StringUtils.isEmpty(jgProjectContraption)){
            jgUseRegistration.setProjectContraption(jgProjectContraption.getProjectContraption());
            jgProjectContraption.setUseDate(Objects.toString(mapData.get("useDate"),""));
            jgProjectContraption.setCity(String.valueOf(mapData.get("city")));
            jgProjectContraption.setCounty(String.valueOf(mapData.get("county")));
            jgProjectContraption.setStreet(String.valueOf(mapData.get("factoryUseSiteStreet")));
            jgProjectContraption.setAddress(String.valueOf(mapData.get("address")));
            jgProjectContraption.setCityName(getRegionName(CITY, CITY.toLowerCase(), mapData));
            jgProjectContraption.setCountyName(getRegionName(REGION, COUNTY.toLowerCase(), mapData));
            jgProjectContraption.setStreetName(getRegionName(STREET, "factoryUseSiteStreet", mapData));
            jgProjectContraption.setIsFirstMerge(false);
            jgProjectContraption.setIsIntoManagement(true);
            if (!StringUtils.isEmpty(mapData.get("orgBranchCode"))) {
                jgProjectContraption.setOrgName(String.valueOf(mapData.getString("orgBranchCode")).split("_")[1]);
                jgProjectContraption.setOrgCode(String.valueOf(mapData.getString("orgBranchCode")).split("_")[0]);
            }
            jgProjectContraption.setStartLatitudeLongitude(String.valueOf(mapData.get("startLatitudeLongitude")));
            jgProjectContraption.setEndLatitudeLongitude(String.valueOf(mapData.get("endLatitudeLongitude")));
            //装置进行合并
            if (!jgUseRegistration.getOriginProjectContraptionIds().contains(jgUseRegistration.getProjectContraptionId())) {
                // 1. 修改 use_info 表中的工程装置 ID
                List<IdxBizJgUseInfo> useInfoList = idxBizJgUseInfoService.lambdaQuery()
                        .in(IdxBizJgUseInfo::getProjectContraptionId, jgUseRegistration.getOriginProjectContraptionIds())
                        .list();

                useInfoList.forEach(useInfo -> {
                    esEquipmentCategory.findById(useInfo.getRecord()).ifPresent(equInfoEs -> {
                        if (PipelineEnum.INDUSTRIAL_PIPELINE.getCode().equals(equInfoEs.getEQU_CATEGORY_CODE())) {
                            equInfoEs.setProjectContraptionId(jgUseRegistration.getProjectContraptionId());
                            esEquipmentCategory.save(equInfoEs);
                        }
                    });
                    useInfo.setProjectContraptionId(jgUseRegistration.getProjectContraptionId());
                    useInfoMapper.updateById(useInfo);
                });

                // 2. 修改原始工程装置表的父级工程装置 ID
                List<IdxBizJgProjectContraption> originProjectContraptionList = jgProjectContraptionService.lambdaQuery()
                        .in(BaseEntity::getSequenceNbr, Arrays.asList(jgUseRegistration.getOriginProjectContraptionIds().split(",")))
                        .list();

                originProjectContraptionList.forEach(contraption -> {
                    contraption.setProjectContraptionParentId(jgUseRegistration.getProjectContraptionId());
                    jgProjectContraptionService.updateById(contraption);
                });
                Object pipelineLengthObj = mapData.get("pipelineLength");
                jgProjectContraption.setPipelineLength(
                        pipelineLengthObj instanceof Number
                                ? ((Number) pipelineLengthObj).doubleValue()
                                : Double.parseDouble(String.valueOf(pipelineLengthObj))
                );
            }
        }
    }

    /**
     * 根据code获取市区县名字
     * @param key key
     * @param codeKey codeKey
     * @param mapData 表单信息
     * @return name
     */
    private String getRegionName(String key, String codeKey, JSONObject mapData) {
        return Optional.ofNullable((List<LinkedHashMap>) redisUtils.get(key))
                .flatMap(list -> list.stream()
                        .filter(item -> String.valueOf(item.get("regionCode"))
                                .equals(String.valueOf(mapData.get(codeKey))))
                        .map(item -> (String) item.get("regionName"))
                        .findFirst())
                .orElse("");
    }

    private String getInspectConclusionName(JSONObject mapData) {
        if( !ObjectUtils.isEmpty(mapData.get("inspectConclusion"))) {
            String code = mapData.get("inspectConclusion").toString();
            DataDictionary conclusionDict = dataDictionaryServiceImpl.getByCode( code,"JYJL");
            if(conclusionDict != null) {
                return conclusionDict.getName();
            }
        }
        return "";
    }

    /**
     * 生成使用登记证变更记录
     *
     * @param jgUseRegistration
     * @param registerInfo
     * @param changeRecordId
     * @param taskV2Model
     */
    private void generateCertificateChangeRecord(JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo registerInfo,
                                                 Long changeRecordId, TaskV2Model taskV2Model, Boolean flag) {
        Map<String, String> equType = new HashMap<>();
        equType.put("equList", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquList()));
        equType.put("equListCode", registerInfo.getEquList());
        equType.put("equCategory", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquCategory()));
        equType.put("equCategoryCode", registerInfo.getEquCategory());
        equType.put("equDefine", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquDefine()));
        equType.put("equDefineCode", registerInfo.getEquDefine());
        JgCertificateChangeRecord changeRecord = new JgCertificateChangeRecord();
        changeRecord.setApplyNo(jgUseRegistration.getApplyNo());
        changeRecord.setReceiveOrgName(jgUseRegistration.getReceiveOrgName());
        changeRecord.setAuditPassDate(new Date());
        changeRecord.setRegType(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        changeRecord.setRegDate(jgUseRegistration.getCreateDate());
        changeRecord.setChangeContent(this.buildRecordContent(jgUseRegistration, BusinessTypeEnum.JG_USAGE_REGISTRATION.getName(), flag));//变更内容
        changeRecord.setUseRegistrationCode(jgUseRegistration.getUseRegistrationCode());//使用登记编号
        changeRecord.setReceiveCompanyCode(jgUseRegistration.getReceiveCompanyOrgCode());//接收机构公司代码
        // 流水表不需要再次生成唯一编号，使用证管理表对应值
        if (!ObjectUtils.isEmpty(jgUseRegistration.getUseRegistrationCode())){
            JgUseRegistrationManage manage = jgUseRegistrationManageService.lambdaQuery()
                    .eq(JgUseRegistrationManage::getUseRegistrationCode, jgUseRegistration.getUseRegistrationCode())
                    .eq(JgUseRegistrationManage::getIsDelete, 0)
                    .eq(JgUseRegistrationManage::getCertificateStatus,CertificateStatusEnum.YIDENGJI.getName()).one();
            changeRecord.setCertificateNo(manage.getCertificateNo());//登记证书唯一码
        }
        changeRecord.setUseUnitCreditCode(jgUseRegistration.getUseUnitCreditCode());//使用单位统一信用代码
        changeRecord.setUseUnitName(jgUseRegistration.getUseUnitName());//使用单位名称
        changeRecord.setEquCategory(registerInfo.getEquCategory());//设备类别编码
        changeRecord.setCreateDate(new Date());
        changeRecord.setRoutePath(taskV2Model.getRoutePath());
        changeRecord.setSequenceNbr(changeRecordId);
        certificateChangeRecordService.save(changeRecord);
    }

    /**
     * 更新登记证管理表数据
     *
     * @param sequenceNbr 使用登记业务表seq
     */
    private void updateRegistrationManage(Long sequenceNbr) {
        JgUseRegistration jgUseRegistration = this.baseMapper.selectById(sequenceNbr);

        LambdaQueryWrapper<JgUseRegistrationManage> queryWrapper = new LambdaQueryWrapper<JgUseRegistrationManage>()
                .eq(JgUseRegistrationManage::getUseRegistrationCode, jgUseRegistration.getUseRegistrationCode())
                .eq(JgUseRegistrationManage::getIsDelete, 0)
                .ne(JgUseRegistrationManage::getCertificateStatus, CertificateStatusEnum.YIZHUXIAO.getName());
        JgUseRegistrationManage jgUseRegistrationManage = jgUseRegistrationManageService.getBaseMapper().selectOne(queryWrapper);

        if (!ValidationUtil.isEmpty(jgUseRegistrationManage)) {
            jgUseRegistrationManage.setUseUnitName(jgUseRegistration.getUseUnitName());
            jgUseRegistrationManage.setApplyNo(jgUseRegistration.getApplyNo());
            jgUseRegistrationManage.setReceiveOrgName(jgUseRegistration.getReceiveOrgName());
            jgUseRegistrationManage.setAuditPassDate(jgUseRegistration.getAuditPassDate());
            jgUseRegistrationManage.setRegDate(jgUseRegistration.getRegDate());
            jgUseRegistrationManage.setEquUseAddress(jgUseRegistration.getUseAddress());
            jgUseRegistrationManage.setUseUnitCreditCode(jgUseRegistration.getUseUnitCreditCode());
            jgUseRegistrationManage.setReceiveCompanyCode(jgUseRegistration.getReceiveCompanyCode());
            jgUseRegistrationManage.setManageType(jgUseRegistration.getManageType());
            this.setSuperviseOrgInfo(jgUseRegistrationManage, jgUseRegistration);
            jgUseRegistrationManageService.updateById(jgUseRegistrationManage);
        }
    }

    /**
     * 生成登记证数据
     *
     * @param jgUseRegistration 使用登记单
     * @param registerInfo      一码通设备注册信息表
     */
    private void generateRegistrationManage(JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo registerInfo, Boolean flag, Long useRegistrationManageSeq) {

        if (flag) {
//            LambdaQueryWrapper<JgUseRegistrationManage> queryWrapper = new LambdaQueryWrapper<>();
//            queryWrapper.eq(JgUseRegistrationManage::getUseRegistrationCode, useRegistrationCode);
//            JgUseRegistrationManage jgUseRegistrationManage = jgUseRegistrationManageMapper.selectOne(queryWrapper);
            JgUseRegistrationManage jgUseRegistrationManage = new JgUseRegistrationManage();
            jgUseRegistrationManage.setAuditPassDate(jgUseRegistration.getAuditPassDate());
            jgUseRegistrationManage.setSequenceNbr(useRegistrationManageSeq);
            this.setSuperviseOrgInfo(jgUseRegistrationManage, jgUseRegistration);
            jgUseRegistrationManageMapper.updateById(jgUseRegistrationManage);
            return;
        }
        // 使用单位信息
        Map<String, Object> enterpriseInfo = commonServiceImpl.getEnterpriseInfo(jgUseRegistration.getUseUnitCreditCode());
        //
        Map<String, String> equType = new HashMap<>();
        equType.put("equList", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquList()));
        equType.put("equListCode", registerInfo.getEquList());
        equType.put("equCategory", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquCategory()));
        equType.put("equCategoryCode", registerInfo.getEquCategory());
        equType.put("equDefine", this.baseMapper.getEquCategoryNameByCode(registerInfo.getEquDefine()));
        equType.put("equDefineCode", registerInfo.getEquDefine());
        JgUseRegistrationManage jgUseRegistrationManage = new JgUseRegistrationManage();
        jgUseRegistrationManage.setUseUnitName(jgUseRegistration.getUseUnitName());
        jgUseRegistrationManage.setApplyNo(jgUseRegistration.getApplyNo());
        jgUseRegistrationManage.setCertificateStatus(CertificateStatusEnum.YIDENGJI.getName());
        jgUseRegistrationManage.setReceiveOrgName(jgUseRegistration.getReceiveOrgName());
        jgUseRegistrationManage.setAuditPassDate(jgUseRegistration.getAuditPassDate());
        jgUseRegistrationManage.setRegType(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        jgUseRegistrationManage.setRegDate(jgUseRegistration.getRegDate());
        jgUseRegistrationManage.setEquList(equType.get("equList"));
        jgUseRegistrationManage.setEquListCode(equType.get("equListCode"));
        jgUseRegistrationManage.setEquCategory(equType.get("equCategory"));
        jgUseRegistrationManage.setEquCategoryCode(equType.get("equCategoryCode"));
        jgUseRegistrationManage.setEquDefine(equType.get("equDefine"));
        jgUseRegistrationManage.setEquDefineCode(equType.get("equDefineCode"));
        jgUseRegistrationManage.setIsDelete(Boolean.FALSE);
        jgUseRegistrationManage.setRecUserId(jgUseRegistration.getRecUserId());
        jgUseRegistrationManage.setRecUserName(jgUseRegistration.getRecUserName());
        jgUseRegistrationManage.setRecDate(jgUseRegistration.getRecDate());
        jgUseRegistrationManage.setCreateUserId(jgUseRegistration.getCreateUserId());
        jgUseRegistrationManage.setCreateDate(jgUseRegistration.getRecDate());
        jgUseRegistrationManage.setEquUseAddress(jgUseRegistration.getUseAddress());
        jgUseRegistrationManage.setCarNumber(registerInfo.getCarNumber());
        jgUseRegistrationManage.setUseUnitAddress(!ValidationUtil.isEmpty(enterpriseInfo) ? (String) enterpriseInfo.get("address") : "");
        jgUseRegistrationManage.setUseRegistrationCode(jgUseRegistration.getUseRegistrationCode());
        jgUseRegistrationManage.setUseUnitCreditCode(jgUseRegistration.getUseUnitCreditCode());
        jgUseRegistrationManage.setReceiveCompanyCode(jgUseRegistration.getReceiveCompanyCode());
        jgUseRegistrationManage.setManageType(jgUseRegistration.getManageType());
        jgUseRegistrationManage.setCertificateNo(commonServiceImpl.generateCertificateNo(equType, new Date(), jgUseRegistration.getReceiveCompanyCode()));
        this.setSuperviseOrgInfo(jgUseRegistrationManage, jgUseRegistration);
        jgUseRegistrationManageService.save(jgUseRegistrationManage);
    }

    private void setSuperviseOrgInfo(JgUseRegistrationManage jgUseRegistrationManage, JgUseRegistration jgUseRegistration) {
        jgUseRegistrationManage.setSuperviseOrgCode(jgUseRegistration.getSupervisionOrgCode());
        jgUseRegistrationManage.setSuperviseOrgName(commonMapper.getCompanyNameByOrgCode(jgUseRegistration.getSupervisionOrgCode()));
    }

    public JgUseRegistration updateData(Long sequenceNbr, String operate, WorkflowResultDto workflowResultDto, String carNumber, Boolean isFirst, JSONObject jsonObject) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String role = workflowResultDto.getNextExecutorRoleIds();
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
            taskCode = workflowResultDto.getNextTaskCode();
        }
        JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
        LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda()
                .eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr)
                .eq(JgUseRegistrationEq::getIsDelete, false);
        JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
        jgUseRegistration.setEquipId(jgUseRegistrationEq.getEquId());
        jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
        jgUseRegistration.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());

        if (isFirst) {
            jgUseRegistration.setInstanceStatus(workflowResultDto.getExecutorRoleIds());
            jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        }
        if (!FlowStatusEnum.TO_BE_FINISHED.getName().equals(taskCode)) {
            jgUseRegistration.setNextExecuteIds(role);
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            if (!ObjectUtils.isEmpty(jgUseRegistration.getInstanceStatus())) {
                jgUseRegistration.setInstanceStatus(jgUseRegistration.getInstanceStatus() + "," + role);
            } else {
                jgUseRegistration.setInstanceStatus(role);
            }
            if ("0".equals(operate)) {
                // 通过操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
            } else {
                // 驳回操作
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                jgUseRegistration.setPromoter("");
                // 如果 驳回到使用单位  厂车设备  有车牌号，清除车牌号
                // 避免出现以下情况：
                // 厂车使用登记 -》 使用单位提交 -》 一级填写了厂车车牌号，例如：场内陕AB1234，通过 -》 到二级或者三级，驳回到使用单位
                // -》 使用单位重新编辑提交，并且换了另一个设备 —-》 一级审批继续使用车牌号：场内陕AB1234，会出现车牌号已存在
                if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && !ObjectUtils.isEmpty(carNumber)) {
                    idxBizJgRegisterInfoMapper.update(null, new UpdateWrapper<IdxBizJgRegisterInfo>().lambda()
                            .set(IdxBizJgRegisterInfo::getCarNumber, null)
                            .eq(IdxBizJgRegisterInfo::getRecord, jgUseRegistrationEq.getEquId()));
                }
            }
            if (isFirst) {
                buildTask(jgUseRegistration, workflowResultDto);
            } else {
                // 更新代办状态
                HashMap<String, Object> params = new HashMap<>();
                params.put("relationId", jgUseRegistration.getInstanceId());
                params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("flowStatusLabel", jgUseRegistration.getStatus());
                params.put("taskStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                params.put("taskStatusLabel", jgUseRegistration.getStatus());
                TaskMessageDto taskMessageDto1 = new TaskMessageDto();
                this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto1);
                params.put("model", taskMessageDto1);
                TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                // 创建新的代办
                if (!ObjectUtils.isEmpty(taskV2Model)) {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                    taskMessageDto.setEquipId(jgUseRegistrationEq.getEquId());
                    this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
                    taskModelDto.setModel(taskMessageDto);
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                    if (WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode) && "1".equals(operate)) {
                        taskModelDto.setPageType("edit");
                    }
                    commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                } else {
                    workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                    buildTask(jgUseRegistration, workflowResultDto);
                }
            }
        } else {
            //如果是特殊的历史设备需要更新安装信息
            String dataSource = jsonObject.getString("DATA_SOURCE");
            if("jg_his_black".equals(dataSource)){
                this.historyEquUpdateInstallInfo(jsonObject);
            }
            // 流程结束
            jgUseRegistration.setStatus(taskCode);
            jgUseRegistration.setNextExecuteUserIds("");

            LambdaQueryWrapper<JgRegistrationHistory> lambdaSelect = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambdaSelect.eq(JgRegistrationHistory::getCurrentDocumentId, String.valueOf(sequenceNbr));
            lambdaSelect.eq(JgRegistrationHistory::getIsDelete, false);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambdaSelect);
            JSONObject mapData = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            // 设备ID
            String equId = String.valueOf(mapData.get("equipId"));

            // 登记证记录主键
            Long changeRecordId = sequence.nextId();

            // 注册信息
            LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaReg = new QueryWrapper<IdxBizJgRegisterInfo>().lambda();
            lambdaReg.eq(IdxBizJgRegisterInfo::getRecord, equId);
            IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaReg);
            // 其他信息
            LambdaQueryWrapper<IdxBizJgOtherInfo> lambdaOth = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
            lambdaOth.eq(IdxBizJgOtherInfo::getRecord, String.valueOf(mapData.get("equipId")));
            IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(lambdaOth);

            // 更新代办
            TaskV2Model taskV2Model = updateAgency(jgUseRegistration);

            processMapData(sequenceNbr, mapData, jgUseRegistration, jgRegistrationHistory, registerInfo, otherInfo, taskV2Model,
                    jsonObject, Boolean.FALSE, null, mapData, Boolean.FALSE);

            // 生成证书管理表记录
            generateRegistrationManage(jgUseRegistration, registerInfo, Boolean.FALSE, null);

            // 生成一条使用登记证变更记录
            generateCertificateChangeRecord(jgUseRegistration, registerInfo, changeRecordId, taskV2Model, Boolean.FALSE);

            // 查询设备制造信息
            LambdaQueryWrapper<IdxBizJgFactoryInfo> factoryInfoWrapper = new LambdaQueryWrapper<>();
            factoryInfoWrapper.eq(IdxBizJgFactoryInfo::getRecord, equId);
            IdxBizJgFactoryInfo idxBizJgFactoryInfo = idxBizJgFactoryInfoService.getOne(factoryInfoWrapper);

            // 生成tzs_jg_certificate_change_record_eq记录
            JgCertificateChangeRecordEq changeRecordEq = new JgCertificateChangeRecordEq();
            changeRecordEq.setChangeRecordId(String.valueOf(changeRecordId));//登记证记录主键
            changeRecordEq.setEquId(registerInfo.getRecord());//设备主键
            changeRecordEq.setProductCode(idxBizJgFactoryInfo.getFactoryNum());
            certificateChangeRecordEqService.save(changeRecordEq);
        }
        this.getBaseMapper().updateById(jgUseRegistration);
        commonServiceImpl.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
        return jgUseRegistration;
    }

    private void processMapData(Long sequenceNbr, JSONObject mapData, JgUseRegistration jgUseRegistration,
                                JgRegistrationHistory jgRegistrationHistory, IdxBizJgRegisterInfo registerInfo, IdxBizJgOtherInfo otherInfo,
                                TaskV2Model taskV2Model, JSONObject jsonObject, Boolean flag, String useRegistrationCode,
                                Map<String, Object> equipment, boolean isMerge) {
        jgUseRegistration.setSupervisoryCode(otherInfo.getSupervisoryCode());

        // 更新设备信息
        this.updateEquipMessage(String.valueOf(sequenceNbr), jgUseRegistration, mapData, registerInfo, otherInfo, flag, useRegistrationCode, equipment);
        // 生成使用登记证编号
        if (!ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode())) {
            if ("unit".equals(jgUseRegistration.getManageType())) {
                boolean isFirstMerge = Optional.ofNullable(mapData.get("isFirstMerge"))
                        .map(Boolean.class::cast)
                        .orElse(false);
                if ((Boolean) mapData.get("isFirstEquip")) {
                    String code = flag ? useRegistrationCode : commonServiceImpl.generateRegistrationCode(String.valueOf(mapData.get("equipId")), jgUseRegistration.getSupervisoryCode(),
                            jgUseRegistration.getReceiveCompanyCode(), true);
                    jgUseRegistration.setUseRegistrationCode(code);
                    jgUseRegistration.setAuditPassDate(new Date());
                    registerInfo.setUseOrgCode(code);
                    LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                    lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                    lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, code);
                    // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                    this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                    lambda.set(isMerge || isFirstMerge, IdxBizJgRegisterInfo::getEquCode, registerInfo.getEquCode());
                    idxBizJgRegisterInfoService.update(lambda);
                } else {
                    registerInfo.setUseOrgCode(jgUseRegistration.getUseRegistrationCode());
                    LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                    lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                    lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, jgUseRegistration.getUseRegistrationCode());
                    // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                    this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                    lambda.set(isMerge || isFirstMerge, IdxBizJgRegisterInfo::getEquCode, registerInfo.getEquCode());
                    idxBizJgRegisterInfoService.update(lambda);
                }
            } else {
                String code = commonServiceImpl.generateRegistrationCode(String.valueOf(mapData.get("equipId")), jgUseRegistration.getSupervisoryCode(), jgUseRegistration.getReceiveCompanyCode(), false);
                jgUseRegistration.setUseRegistrationCode(code);
                jgUseRegistration.setAuditPassDate(new Date());
                registerInfo.setUseOrgCode(code);
                LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda();
                lambda.eq(IdxBizJgRegisterInfo::getRecord, registerInfo.getRecord());
                lambda.set(true, IdxBizJgRegisterInfo::getUseOrgCode, code);
                // 新增页面选择无设备代码后，在审批通过后自动生成设备代码
                this.justGenerateEquCode(lambda, registerInfo, jgUseRegistration.getReceiveCompanyCode(), mapData, jgRegistrationHistory);
                idxBizJgRegisterInfoService.update(lambda);
            }
        }
        // 使用信息
        LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
        lambda.eq(IdxBizJgUseInfo::getRecord, String.valueOf(mapData.get("equipId")));
        IdxBizJgUseInfo useInfo = useInfoMapper.selectOne(lambda);
        String usePlace = useInfo.getProvinceName() + "/" + useInfo.getCityName() + "/" + useInfo.getCountyName() + "/" + useInfo.getStreetName();
        useInfo.setIsIntoManagement(Boolean.TRUE);
        useInfo.setUseDate(Objects.toString(mapData.get("useDate"),""));
        useInfoMapper.updateById(useInfo);
        // 更新es
        updateEsData(usePlace, mapData, otherInfo,useInfo, jgUseRegistration, jsonObject);
        jgResumeInfoService.createWithModel(JgResumeInfoDto.builder()
                .applyNo(jgUseRegistration.getApplyNo())
                .businessType(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName())
                .businessId(jgUseRegistration.getSequenceNbr() + "")
                .equId((String) mapData.get("equipId"))
                .approvalUnit(jgUseRegistration.getReceiveOrgName())
                .approvalUnitCode(jgUseRegistration.getReceiveCompanyCode())
                .status("正常")
                .routePath(taskV2Model.getRoutePath())
                .build());
    }

    /**
     * 流程结束更新代办
     *
     * @param jgUseRegistration 登记单信息
     */
    private TaskV2Model updateAgency(JgUseRegistration jgUseRegistration) {
        // 更新代办状态
        HashMap<String, Object> params = new HashMap<>();
        params.put("relationId", jgUseRegistration.getInstanceId());
        params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
        params.put("flowStatusLabel", jgUseRegistration.getStatus());
        params.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        params.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
        this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
        params.put("model", taskMessageDto);
        return commonServiceImpl.updateTaskModel(params);
    }

    /**
     * 作废的证变更内容
     *
     * @param obj JgUseRegistration
     * @return result
     */
    private String buildVoidRecordContent(JgUseRegistration obj) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String companyType = reginParams.getCompany().getCompanyType();
        //监管单位 作废了【使用功能登记】 ，单号【DWBG202407050001】，作废日期2024-07-05
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日");
        return companyType + "作废了【" + BusinessTypeEnum.JG_USAGE_REGISTRATION.getName() + "】，" +
                "单号【" + obj.getApplyNo() + "】，申请日期" + simpleDateFormat.format(obj.getRecDate());
    }

    private String buildRecordContent(JgUseRegistration obj, String businessName, Boolean flag) {
        FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.queryByUserId(obj.getCreateUserId());

        //张三办理了【单位变更】 ，单号【DWBG202407050001】，办理日期2024-07-05
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy年MM月dd日");

        return obj.getUseUnitName()+"的"+agencyUserModelFeignClientResult.getResult().getRealName() + "办理了【" + businessName + (flag ? "设备增补" : "") + "】，" +
                "单号【" + obj.getApplyNo() + "】，申请日期" + simpleDateFormat.format(obj.getRecDate());
    }

    /**
     * 系统类型的code 自动生成设备代码
     *
     * @param lambda                lambda
     * @param registerInfo          注册信息
     * @param receiveCompanyCode    接收机构行政区划代码
     * @param mapData               历史数据
     * @param jgRegistrationHistory 历史数据行数据
     */
    public void justGenerateEquCode(LambdaUpdateWrapper<IdxBizJgRegisterInfo> lambda, IdxBizJgRegisterInfo registerInfo, String receiveCompanyCode, JSONObject mapData, JgRegistrationHistory jgRegistrationHistory) {
        // 新增设备时选择无设备代码且在设备代码为空【未做安装告知（使用登记、安装告知会生成设备代码）】
        if (EquCodeTypeEnum.SYSTEM_GENERATED.getCode().equals(registerInfo.getEquCodeType()) && StringUtils.isEmpty(registerInfo.getEquCode())) {
            // 更新注册信息表的设备代码字段
            String equCode = this.getEquCode(registerInfo, receiveCompanyCode);
            registerInfo.setEquCode(equCode);
            mapData.put("equCode", equCode);
            lambda.set(true, IdxBizJgRegisterInfo::getEquCode, equCode);
        }
    }

    public String getEquCode(IdxBizJgRegisterInfo registerInfo, String receiveCompanyCode) {
        ProduceInfo produceInfo = produceInfoMapper.selectOne(new LambdaQueryWrapper<ProduceInfo>().eq(AbstractEquipBaseEntity::getRecord, registerInfo.getRecord()));
        CodeGenerateDto codeGenerateDto = new CodeGenerateDto();
        codeGenerateDto.setEquList(registerInfo.getEquList());
        codeGenerateDto.setEquCategory(registerInfo.getEquCategory());
        codeGenerateDto.setEquDefine(registerInfo.getEquDefine());
        codeGenerateDto.setProduceDate(produceInfo.getProduceDate());
        codeGenerateDto.setReceiveCompanyCode(receiveCompanyCode);
        return codeUtil.generateEquipmentCode(codeGenerateDto);
    }

    public String generateEquCode(String equListCode, String equCategoryCode, String equDefineCode, Date now, String receiveCompanyCode) {
        CodeGenerateDto codeGenerateDto = new CodeGenerateDto();
        codeGenerateDto.setEquList(equListCode);
        codeGenerateDto.setEquCategory(equCategoryCode);
        codeGenerateDto.setEquDefine(equDefineCode);
        codeGenerateDto.setProduceDate(now);
        codeGenerateDto.setReceiveCompanyCode(receiveCompanyCode);
        return codeUtil.generateEquipmentCode(codeGenerateDto);
    }

    public void  updateEsData(String usePlace, JSONObject dataMap, IdxBizJgOtherInfo otherInfo,IdxBizJgUseInfo useInfo,
                             JgUseRegistration jgUseRegistration, JSONObject jsonObject) {
        // 更新es
        HashMap<String, Map<String, Object>> objMap = new HashMap<>();
        HashMap<String, Object> param = new HashMap<>();
        // 属地监管部门拆分
        String orgBranch = (String) dataMap.getOrDefault("orgBranchCode", "_");
        String[] split = orgBranch.split("_");
        param.put("SUPERVISORY_CODE", otherInfo.getSupervisoryCode());
        param.put("CODE96333", otherInfo.getCode96333());
        param.put("USE_UNIT_CREDIT_CODE", dataMap.get("useUnitCreditCode"));
        param.put("USE_UNIT_NAME", dataMap.get("useUnitName"));
        param.put("ADDRESS", dataMap.getOrDefault("address", ""));
        param.put("USE_PLACE", usePlace);
        param.put("STATUS", "已认领");
        param.put("EQU_STATE", 1);
        // 更新es的下次检验日期
        param.put("NEXT_INSPECT_DATE", this.castDate2TimeStr(dataMap.getString("nextInspectDate")));
        param.put("USE_INNER_CODE", useInfo.getUseInnerCode());
        param.put("IS_INTO_MANAGEMENT", true);
        param.put("USE_PLACE_CODE", jsonObject.get("province") + "#" + jsonObject.get("city") + "#" + jsonObject.get("county") + "#" + jsonObject.get("factoryUseSiteStreet"));
        param.put("USE_SITE_CODE", String.valueOf(jsonObject.get("usePlace")));
        param.put("ORG_BRANCH_CODE", split[0]);
        param.put("ORG_BRANCH_NAME", split[1]);
        param.put("USC_UNIT_CREDIT_CODE", "");
        param.put("USC_UNIT_NAME", "");
        param.put("EQU_CODE", dataMap.get("equCode"));
        param.put("USE_ORG_CODE", jgUseRegistration.getUseRegistrationCode());
        param.put("CYLINDER_CATEGORY", dataMap.get("cylinderCategory"));
        objMap.put((String) dataMap.get("equipId"), param);
        tzsServiceFeignClient.commonUpdateEsDataByIds(objMap);
    }

    public void updateEsData2(String usePlace, JSONObject dataMap, IdxBizJgOtherInfo otherInfo,IdxBizJgUseInfo useInfo,
                             JgUseRegistration jgUseRegistration, JSONObject jsonObject) {
        // 更新es
        HashMap<String, Map<String, Object>> objMap = new HashMap<>();
        HashMap<String, Object> param = new HashMap<>();
        // 属地监管部门拆分
        String orgBranch = (String) dataMap.getOrDefault("orgBranchCode", "_");
        String[] split = orgBranch.split("_");
        param.put("SUPERVISORY_CODE", otherInfo.getSupervisoryCode());
        param.put("CODE96333", otherInfo.getCode96333());
        param.put("USE_UNIT_CREDIT_CODE", dataMap.get("useUnitCreditCode"));
        param.put("USE_UNIT_NAME", dataMap.get("useUnitName"));
        param.put("ADDRESS", dataMap.getOrDefault("address", ""));
        param.put("USE_PLACE", usePlace);
        param.put("STATUS", "已认领");
        param.put("EQU_STATE", 1);
        // 更新es的下次检验日期
        param.put("NEXT_INSPECT_DATE", this.castDate2TimeStr(dataMap.getString("nextInspectDate")));
        param.put("USE_INNER_CODE", useInfo.getUseInnerCode());
        param.put("IS_INTO_MANAGEMENT", true);
        param.put("USE_PLACE_CODE", jsonObject.get("province") + "#" + jsonObject.get("city") + "#" + jsonObject.get("county") + "#" + jsonObject.get("factoryUseSiteStreet"));
        param.put("USE_SITE_CODE", String.valueOf(jsonObject.get("usePlace")));
        param.put("ORG_BRANCH_CODE", split[0]);
        param.put("ORG_BRANCH_NAME", split[1]);
        param.put("USC_UNIT_CREDIT_CODE", "");
        param.put("USC_UNIT_NAME", dataMap.getString("uscUnitName"));
        param.put("EQU_CODE", dataMap.get("equCode"));
        param.put("USE_ORG_CODE", jgUseRegistration.getUseRegistrationCode());
        param.put("CYLINDER_CATEGORY", dataMap.get("cylinderCategory"));
        objMap.put((String) dataMap.get("equipId"), param);
        tzsServiceFeignClient.commonUpdateEsDataByIds(objMap);
    }

    private Long castDate2TimeStr(String nextInspectDate) {
        if(nextInspectDate != null){
            return DateUtil.parse(nextInspectDate).getTime();
        }
        return null;
    }

    public InstanceRuntimeData buildInstanceRuntimeData(JgUseRegistration jgUseRegistration) {
        return InstanceRuntimeData.builder()
                .nextExecuteUserIds(jgUseRegistration.getNextExecuteUserIds())
                .promoter(jgUseRegistration.getPromoter())
                .nextTaskId(jgUseRegistration.getNextTaskId())
                .build();
    }

    public void buildTask(JgUseRegistration jgUseRegistration, WorkflowResultDto workflowResultDto) {
        // 代办消息
        ArrayList<TaskModelDto> list = new ArrayList<>();
        TaskModelDto dto = new TaskModelDto();
        dto.setTaskType(String.valueOf(BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode()));
        dto.setTaskTypeLabel(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        dto.setFlowCreateDate(jgUseRegistration.getCreateDate());
        dto.setTaskName(workflowResultDto.getNextTaskName());
        dto.setTaskCode(workflowResultDto.getNextTaskCode());
        dto.setRelationId(workflowResultDto.getInstanceId());
        dto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
        dto.setTaskStatus(commonServiceImpl.getDictionaryCodeByName(WorkFlowStatusEnum.getMessage(workflowResultDto.getNextTaskCode()).getPass()));
        dto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
        dto.setFlowStatus(commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
        dto.setFlowStatusLabel(jgUseRegistration.getStatus());
        dto.setStartUserId(jgUseRegistration.getCreateUserId());
        dto.setStartUser(jgUseRegistration.getRecUserName());
        dto.setStartUserCompanyName(jgUseRegistration.getUseUnitName());
        dto.setStartDate(new Date());
        jgUseRegistration.setInstanceId(workflowResultDto.getInstanceId());
        // 设备信息
        jgUseRegistration.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
        LambdaQueryWrapper<JgUseRegistrationEq> jgUseRegEqWrapper = new QueryWrapper<JgUseRegistrationEq>().lambda();
        jgUseRegEqWrapper.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(jgUseRegistration.getSequenceNbr()));
        List<JgUseRegistrationEq> jgUseRegistrationEqList = jgRelationEquipMapper.selectList(jgUseRegEqWrapper);

        if (!jgUseRegistrationEqList.isEmpty()) {
            String equId = jgUseRegistrationEqList.get(0).getEquId();
            taskMessageDto.setEquipId(equId);
            taskMessageDto.setEQU_LIST_CODE(this.getEquipListCode(equId));
//            dto.setTaskContent("来自" + this.getBaseMapper().getEquType(equId) + "【" + (ObjectUtils.isEmpty(jgUseRegistration.getSupervisoryCode()) ? "无" : jgUseRegistration.getSupervisoryCode()) + "】的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
            dto.setTaskContent("来自" + this.getBaseMapper().getEquType(equId) + "的业务办理," + "【申请单号：" + jgUseRegistration.getApplyNo() + "】");
        }
        dto.setModel(taskMessageDto);
        dto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
        dto.setFlowCode(jgUseRegistration.getNextTaskId());
        list.add(dto);
        commonServiceImpl.buildTaskModel(list);
    }

    public String getEquipListCode(String record) {
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record).select(TzsBaseEntity::getSequenceNbr,IdxBizJgRegisterInfo::getEquList));
        if(registerInfo != null){
          return  registerInfo.getEquList();
        }
        return null;
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class, timeoutMills = 6000000)
    public void flowExecute(Long id, String instanceId, String operate, String comment, String carNumber, String manageType, String nextTaskId, JSONObject jsonObject) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 流程执行时，状态及权限校验
            commonService.checkForExecuteFlow(nextTaskId, instanceId);

            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(id);
            if (!ObjectUtils.isEmpty(carNumber)) {
                LambdaQueryWrapper<JgUseRegistrationEq> eq = new QueryWrapper<JgUseRegistrationEq>().lambda()
                        .eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr())
                        .eq(JgUseRegistrationEq::getIsDelete, false);
                JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(eq);
                // 更新安全追溯-场内车辆中的“车牌号字段” 保证唯一性
                Integer count = idxBizJgRegisterInfoMapper.checkCarNumberUniquenessWithHisCC(carNumber, jgUseRegistrationEq.getEquId());
                if (count > 0) {
                    throw new BadRequest("车牌号已存在，请重新输入！");
                }
                LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda()
                        .eq(IdxBizJgRegisterInfo::getRecord, jgUseRegistrationEq.getEquId());
                IdxBizJgRegisterInfo idxBizJgRegisterInfo = new IdxBizJgRegisterInfo();
                idxBizJgRegisterInfo.setCarNumber(carNumber);
                idxBizJgRegisterInfoMapper.update(idxBizJgRegisterInfo, updateWrapper);
            }
            // 组装信息
            TaskResultDTO dto = new TaskResultDTO();

            dto.setTaskId(jgUseRegistration.getNextTaskId());
            dto.setComment(comment);
            HashMap<String, Object> map = new HashMap<>();
            if (jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getReject()) || jgUseRegistration.getStatus().equals(WorkFlowStatusEnum.USE_SUBMIT.getRollBack())) {
                map.put("approvalStatus", "提交");
            }

            String orgCode = "";
            if (jsonObject.containsKey("orgBranchCode") && !ObjectUtils.isEmpty(jsonObject.get("orgBranchCode"))) {
                orgCode = String.valueOf(jsonObject.get("orgBranchCode")).split("_")[0];;
            }
            //驳回
            if ("1".equals(operate)){
                //一级驳回
                if(WorkFlowStatusEnum.USE_RECEIVE.getPass().equals(jgUseRegistration.getStatus())){
                    // 一级驳回到使用单位
                    dto.setNextExecuteUserCompanyCode(jgUseRegistration.getUseUnitCreditCode());
                    dto.setNextExecuteUserOrgCode(jgUseRegistration.getUseUnitCreditCode());
                }
                //特殊登记，安全监察驳回到一级
                if("2".equals(jgUseRegistration.getRegType())) {
                    // 二级驳回到监察单位
                    if(WorkFlowStatusEnum.USE_PRELIMINARY.getPass().equals(jgUseRegistration.getStatus()) || WorkFlowStatusEnum.USE_PRELIMINARY.getReject().equals(jgUseRegistration.getStatus())){
                        map.put("nextExecuteUserOrgCode", orgCode);
                        dto.setResultCode("approvalStatus");
                        map.put("approvalStatus", "10");
                        operate = "2";
                    }else if(WorkFlowStatusEnum.USE_SAFETY_CHECK.getPass().equals(jgUseRegistration.getStatus())
                            || WorkFlowStatusEnum.USE_SAFETY_CHECK.getReject().equals(jgUseRegistration.getStatus())
                            || WorkFlowStatusEnum.USE_SAFETY_CHECK.getRollBack().equals(jgUseRegistration.getStatus())){
                        //安全监察驳回到一级
                        dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                        map.put("nextExecuteUserOrgCode", "");
                        dto.setResultCode("approvalStatus");
                        map.put("approvalStatus", operate);
                        operate = "2";
                    }else{
                        dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                        dto.setResultCode("approvalStatus");
                        map.put("nextExecuteUserOrgCode", "");
                        map.put("approvalStatus", operate);
                    }
                } else {
                    //正常使用登记
                    dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                    map.put("approvalStatus", operate);
                    dto.setResultCode("approvalStatus");
                }
            } else{
                //通过
                //一级通过，且是特殊登记,需要监察，approvalStatus=2
                if ("2".equals(jgUseRegistration.getRegType()) && (WorkFlowStatusEnum.USE_RECEIVE.getPass().equals(jgUseRegistration.getStatus()) || WorkFlowStatusEnum.USE_RECEIVE.getReject().equals(jgUseRegistration.getStatus()))){
                    dto.setResultCode("approvalStatus");
                    map.put("approvalStatus", "9");
                    map.put("nextExecuteUserOrgCode", orgCode);
                }else{//新增登记
                    map.put("approvalStatus", operate);
                    dto.setResultCode("approvalStatus");
                    map.put("nextExecuteUserOrgCode", "");
                    dto.setNextExecuteUserCompanyCode(jgUseRegistration.getReceiveCompanyCode());
                }
            }
            dto.setVariable(map);//无驳回1需监察 0， 通过，需要监察2， 驳回到监察是2
            ProcessTaskDTO complete = cmWorkflowService.completeOrReject(jgUseRegistration.getNextTaskId(), dto, operate);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(complete);
            List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                WorkflowResultDto workflowResultDto = resultDto.get(0);
                // 按单位办理
                if ("unit".equals(manageType)) {
                    this.updateUseRegUnitData(jgUseRegistration.getSequenceNbr(), operate, workflowResultDto, false, jsonObject);
                } else {
                    this.updateData(jgUseRegistration.getSequenceNbr(), operate, workflowResultDto, carNumber, false, jsonObject);
                }
            }
            this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void withdraw(String instanceId, String nextTaskId, String manageType) {
        String lockKey = CommonServiceImpl.buildJgExecuteLockKey(instanceId);
        RLock lock = redissonClient.getLock(lockKey);
        try {
            boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
            // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
            if (!isLocked) {
                throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
            }
            // 撤回校验
            commonServiceImpl.checkForRevocationFlow(nextTaskId, instanceId);

            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(instanceId);
            ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
            processTaskDTOS.add(processTaskDTO);
            List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            String taskCode = "";
            String roles = "";
            if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                taskCode = resultDto.get(0).getNextTaskCode();
                roles = resultDto.get(0).getNextExecutorRoleIds();
                jgUseRegistration.setNextTaskId(resultDto.get(0).getNextTaskId());
                jgUseRegistration.setNextExecuteUserIds(resultDto.get(0).getNextExecutorUserIds());
            }
            LambdaQueryWrapper<JgUseRegistration> lambda = new QueryWrapper<JgUseRegistration>().lambda();
            lambda.eq(JgUseRegistration::getInstanceId, instanceId);
            if (!ObjectUtils.isEmpty(taskCode)) {
                jgUseRegistration.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
            }
            jgUseRegistration.setPromoter(reginParams.getUserModel().getUserId());
            jgUseRegistration.setNextExecuteIds(roles);
            this.update(jgUseRegistration, lambda);
            LambdaQueryWrapper<JgUseRegistration> queryWrapper = new QueryWrapper<JgUseRegistration>().lambda();
            queryWrapper.eq(JgUseRegistration::getInstanceId, instanceId);
            queryWrapper.eq(JgUseRegistration::getIsDelete, false);
            JgUseRegistration data = this.baseMapper.selectOne(queryWrapper);
            // 设备信息
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(data));
            jsonObject.put("nextTaskId", data.getNextTaskId());
            jsonObject.put("nextExecuteUser", data.getNextExecuteIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_USAGE_REGISTRATION.getCode());
            jsonObject.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
            jsonObject.put("flowStatusLabel", jgUseRegistration.getStatus());
            jsonObject.remove("otherAccessories");
            jsonObject.remove("instanceStatus");
            setEquListCode2Json(data, jsonObject);
            // 非单位办理
            if (!"unit".equals(manageType)) {
                LambdaQueryWrapper<JgUseRegistrationEq> lambda1 = new QueryWrapper<JgUseRegistrationEq>().lambda();
                lambda1.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(data.getSequenceNbr()));
                lambda1.eq(JgUseRegistrationEq::getIsDelete, false);
                JgUseRegistrationEq jgUseRegistrationEq = jgRelationEquipMapper.selectOne(lambda1);
                jsonObject.put("equipId", jgUseRegistrationEq.getEquId());
            }
            if (!WorkFlowStatusEnum.USE_SUBMIT.getCode().equals(taskCode)) {
                jsonObject.put("pageType", "look");
            }
            // 撤回删除代办
            commonServiceImpl.rollbackTask(instanceId, jsonObject);
            // redis流程实时数据更新
            commonServiceImpl.saveExecuteFlowData2Redis(instanceId, this.buildInstanceRuntimeData(data));
            this.clearDataForCheckEquipRepeatUsed(data);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    private void setEquListCode2Json(JgUseRegistration jgUseRegistration, JSONObject jsonObject) {
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
        jsonObject.put("EQU_LIST_CODE", taskMessageDto.getEQU_LIST_CODE());
    }


    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> ids) {
        ids.forEach(id -> {
            JgUseRegistration useRegistration = this.baseMapper.selectById(id);
            // 删除代办 + 中止流程
            commonServiceImpl.deleteTaskModel(String.valueOf(id), useRegistration.getInstanceId());
            // 删除单子
            //this.baseMapper.deleteById(id);
            LambdaUpdateWrapper<JgUseRegistration> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(JgUseRegistration::getSequenceNbr, id).set(JgUseRegistration::getIsDelete, true);
            this.update(updateWrapper);

            // 更新 eq 对应数据的 isDelete 字段为true（逻辑删除）
            jgUseRegistrationEqService.getBaseMapper().update(null, new LambdaUpdateWrapper<JgUseRegistrationEq>()
                            .eq(JgUseRegistrationEq::getEquipTransferId, id)
                            .set(JgUseRegistrationEq::getIsDelete, true)
            );
            // 删除单子对应历史表数据
            jgRegistrationHistoryService.getBaseMapper().update(null,
                    new LambdaUpdateWrapper<JgRegistrationHistory>()
                            .eq(JgRegistrationHistory::getCurrentDocumentId, useRegistration.getSequenceNbr())
                            .set(JgRegistrationHistory::getIsDelete, true)
            );
        });
    }

    /**
     * 历史数据填充 设备种类、设备类别、设备品种名称
     * @param detail            返回数据
     * @param jgUseRegistration 当前单据
     */
    private void fillingEquCategoryNameForHisData(Map<String, Object> detail, JgUseRegistration jgUseRegistration) {
        if(!StringUtils.isEmpty(jgUseRegistration.getProjectContraptionId())){
            LambdaQueryWrapper<IdxBizJgProjectContraption> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BaseEntity::getSequenceNbr, jgUseRegistration.getProjectContraptionId());
            queryWrapper.select(IdxBizJgProjectContraption::getEquListName,
                    IdxBizJgProjectContraption::getEquCategoryName,
                    IdxBizJgProjectContraption::getEquDefineName,
                    BaseEntity::getSequenceNbr,
                    IdxBizJgProjectContraption::getEquList,
                    IdxBizJgProjectContraption::getEquCategory,
                    IdxBizJgProjectContraption::getEquDefine);
            IdxBizJgProjectContraption projectContraption = jgProjectContraptionService.getBaseMapper().selectOne(queryWrapper);
            if(projectContraption != null){
                detail.put("equListName", projectContraption.getEquListName());
                detail.put("equCategoryName", projectContraption.getEquCategoryName());
                detail.put("equDefineName", projectContraption.getEquDefineName());
                // 编辑功能会使用到
                detail.putIfAbsent("EQU_LIST_CODE", projectContraption.getEquList());
                detail.putIfAbsent("EQU_CATEGORY_CODE", projectContraption.getEquCategory());
                detail.putIfAbsent("EQU_DEFINE_CODE", projectContraption.getEquDefine());
            }
        }
    }

    public Map<String, Object> getDetail(String record, Long sequenceNbr, ReginParams selectedOrgInfo) {
        if (!ObjectUtils.isEmpty(sequenceNbr)) {
            JgUseRegistration jgUseRegistration = this.getBaseMapper().selectById(sequenceNbr);
            this.doCompensate(jgUseRegistration);
            LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
            lambda.eq(JgRegistrationHistory::getCurrentDocumentId, sequenceNbr);
            lambda.eq(JgRegistrationHistory::getIsDelete, false);
            JgRegistrationHistory jgRegistrationHistory = jgRegistrationHistoryService.getBaseMapper().selectOne(lambda);
            JSONObject jsonObject = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
            jsonObject.put("manageType", jgUseRegistration.getManageType());
            jsonObject.put("createUserId", jgUseRegistration.getCreateUserId());
            jsonObject.put("receiveOrgCode", jgUseRegistration.getReceiveCompanyCode() + "_" + jgUseRegistration.getReceiveOrgName());
            jsonObject.put("status", jgUseRegistration.getStatus());
            jsonObject.put("applyNo", jgUseRegistration.getApplyNo());
            jsonObject.put("installLeaderName", jsonObject.getString("installLeaderId"));
            jsonObject.put("installProxyStatementAttachment", JSONArray.parseArray(jsonObject.getString("proxyStatementAttachmentList")));
            jsonObject.put("installAddress", jsonObject.getString("address"));// 前端展示填充数据
            Optional.ofNullable(jsonObject.get("safetyManagerName")).ifPresent(name -> jsonObject.put("maintenanceManagerName", name));
            Optional.ofNullable(jsonObject.get("phone")).ifPresent(phone -> jsonObject.put("maintenanceManagerPhone", phone));
            jsonObject.remove("submit");
            jsonObject.remove("instanceId");
            if (!ObjectUtils.isEmpty(jsonObject.get("factoryUseSiteStreet"))) {
                jsonObject.put("factoryUseSiteStreet", String.valueOf(Long.valueOf(jsonObject.get("factoryUseSiteStreet").toString())));
            }
            if (!"unit".equals(jgUseRegistration.getManageType())) {
                // 作废时（完成时）equipId 为空
                record = setDefaultRecord(jgUseRegistration, record);
                // 需求：当申请信息由于设备信息错误被驳回及撤回时显示的数据还是旧设备数据，导致该申请单无法使用
                // 解决方案：设备基本信息、制造信息、设计信息、安装信息、维保信息，已完成时显示历史数据、非完成时显示最新设备数据
                this.fillHistoryDataWithNewEquip(jsonObject, jgUseRegistration, record);
                // 补充"车牌号"字段
                LambdaQueryWrapper<IdxBizJgRegisterInfo> wrapper = new QueryWrapper<IdxBizJgRegisterInfo>().lambda().eq(IdxBizJgRegisterInfo::getRecord, record);
                IdxBizJgRegisterInfo idxBizJgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(wrapper);
                jsonObject.put("carNumber", idxBizJgRegisterInfo.getCarNumber());
                jsonObject.put("regType", jgUseRegistration.getRegType());
            } else {
                List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) jsonObject.get("equipmentLists");
                List<String> records = equipmentLists.stream().map(v -> (String) v.get("record")).collect(toList());
                if (record == null || record.isEmpty()) {
                    record = records.stream().findFirst().orElse(null);
                }
                // 完成、作废时显示历史数据,其他状态显示实时数据
                if (!(jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) || jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName()))) {
                    // 查询气瓶设备详情
                    if (CylinderTypeEnum.CYLINDER.getCode().equals(jsonObject.get("EQU_CATEGORY_CODE"))) {
                        jsonObject.remove("equipmentLists");
                        List<DictionarieValueModel> fillingMedium = Systemctl.dictionarieClient.dictValues("FILLING_MEDIUM").getResult();
                        Map<String, Object> fillingMediumMap = fillingMedium.stream().collect(Collectors.toMap(DictionarieValueModel::getDictDataKey, DictionarieValueModel::getDictDataValue));
                        List<Map<String, Object>> result = jgUseRegistrationMapper.queryForUnitVesselEquipment(records);
                        result.forEach(i -> {
                            i.put("chargingMedium", fillingMediumMap.get(i.get("chargingMedium")));
                            i.put("productPhoto", JSONArray.parseArray((String) i.get("productPhoto")));
                            i.put("cylinderStampAttachment", JSONArray.parseArray((String) i.get("cylinderStampAttachment")));
                            i.put("informationSituation", InformationManageTypeEnum.getName((String) i.get("informationSituation")));
                        });
                        jsonObject.put("equipmentLists", result);
                    }
                    // else {
                        // 查询管道设备详情
                        // jsonObject.put("equipmentLists", jgUseRegistrationMapper.queryForUnitPipelineEquipment(records));
                    //}
                } else {
                    this.setPieLineInspectInfo(jgUseRegistration.getProjectContraptionId(), jsonObject);
                    this.setConstructionInfo(jgUseRegistration.getProjectContraptionId(), jsonObject);
                }
            }
            jsonObject.put("useRegistrationCode", jgUseRegistration.getUseRegistrationCode());
            jsonObject.put("useRegistrationFormUrl", jgUseRegistration.getUseRegistrationFormUrl());
            jsonObject.put("useRegistrationFormFile", JSONArray.parseArray(jgUseRegistration.getUseRegistrationFormFile()));
            this.fillingEquCategoryNameForHisData(jsonObject, jgUseRegistration);
            // 转化 附件 字段
            commonServiceImpl.convertStringToJsonobject(jsonObject, jsonFields);
            // 结果增强，填充单据是否可变更设备状态，用来控制前端按钮的显示隐藏。
            new FillingUseRegisterResult(sequenceNbr, jsonObject, applicationContext).getData();
            // 结果增强，填充当前人是否有编辑按钮权限
            new FillingEditPermForCurrentUser(jsonObject, Optional.ofNullable(selectedOrgInfo).map(ReginParams::getCompany).orElse(null)).getData();
            return jsonObject;
        }
        // 基本信息 + 制造信息
        Map<String, Object> detail = this.baseMapper.getDetail(record);
        // 监督管理信息
        Map<String, Object> supervisionInfo = this.baseMapper.getSupervisionInfoDetail(record);
        // 检验信息
        Map<String, Object> inspectDetail = this.getInspectDetail(record);
        // 使用信息
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(record);
        // 设计信息
        Map<String, Object> desDetail = this.baseMapper.getDesDetail(record);
        // 安装信息
        Map<String, Object> installDetail = this.baseMapper.getiInstallDetail(record);
        // 维保信息
        Map<String, Object> maintenanceDetail = this.baseMapper.getMaintenanceDetail(record);
        if (!ObjectUtils.isEmpty(inspectDetail)) {
            detail.putAll(inspectDetail);
        }
        if (!ObjectUtils.isEmpty(useDetail)) {
            if (!ObjectUtils.isEmpty(useDetail.get("factoryUseSiteStreet"))) {
                useDetail.put("factoryUseSiteStreet", String.valueOf(Long.valueOf(useDetail.get("factoryUseSiteStreet").toString())));
            }
            detail.putAll(useDetail);
        }
        if (!ObjectUtils.isEmpty(desDetail)) {
            detail.putAll(desDetail);
        }
        if (!ObjectUtils.isEmpty(maintenanceDetail)) {
            detail.putAll(maintenanceDetail);
        }
        if (!ObjectUtils.isEmpty(installDetail)) {
            detail.putAll(installDetail);
        }
        if (!ObjectUtils.isEmpty(supervisionInfo) && !StringUtils.isEmpty(supervisionInfo.get("orgBranchCode"))) {
            String orgBranchCode = (String) supervisionInfo.get("orgBranchCode");
            String orgBranchName = (String) supervisionInfo.get("orgBranchName");
            supervisionInfo.put("orgBranchCode", orgBranchCode + "_" + orgBranchName);
            supervisionInfo.put("hasOrgBranchCode", true);
            detail.putAll(supervisionInfo);
        }
        detail.remove("safetyManager");
        // 附件解析
        commonServiceImpl.convertStringToJsonobject(detail, jsonFields);
        detail.put("province", "610000");
        JSONObject result = new JSONObject();
        result.putAll(detail);
        // 结果增强，填充单据是否可变更设备状态
        new DefaultUseRegisterResult(result).getData();
        // 结果增强，填充当前人是否有编辑按钮权限
        new FillingEditPermForCurrentUser(result, selectedOrgInfo.getCompany()).getData();
        return result;
    }

    public Map<String, Object> getDetailByIdx(String record) {
        // 基本信息 + 制造信息
        Map<String, Object> detail = this.baseMapper.getDetail(record);

        if (!ObjectUtils.isEmpty(detail) && !StringUtils.isEmpty(detail.get("organizationCode")) && !StringUtils.isEmpty(detail.get("organizationName"))) {
            String receiveOrgCode = (String) detail.get("organizationCode");

            List<LinkedHashMap> receiveUnitTree = commonServiceImpl.getReceiveUnitTree("register");

            List<Map<String, Object>> receiveUnitList = Lists.newArrayList();

            if (!receiveUnitTree.isEmpty() && !receiveUnitTree.get(0).isEmpty()) {
                convertTreeToListMap(receiveUnitTree.get(0), receiveUnitList);
            }
            // 查询receiveUnitTree中符合receiveOrgCode的数据
            Map<String, Object> resultMap = receiveUnitList.stream().filter(map -> receiveOrgCode.equals(map.get("companyCode"))).findFirst().orElse(null);
            if (ValidationUtil.isEmpty(resultMap)) {
                detail.put("receiveOrgCode", null);
            } else {
                String receiveOrgName = (String) resultMap.get("companyName");
                detail.put("receiveOrgCode", receiveOrgCode + "_" + receiveOrgName);
            }
        }

        // 监督管理信息
        Map<String, Object> supervisionInfo = this.baseMapper.getSupervisionInfoDetail(record);
        // 检验信息
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetailByRecord(record);
        // 使用信息
        Map<String, Object> useDetail = this.baseMapper.getUseDetail(record);
        // 设计信息
        Map<String, Object> desDetail = this.baseMapper.getDesDetail(record);
        // 安装信息
        Map<String, Object> installDetail = this.baseMapper.getiInstallDetailByIdx(record);
        if (!ObjectUtils.isEmpty(installDetail) && !StringUtils.isEmpty(installDetail.get("uscUnitCreditCode"))
                && !StringUtils.isEmpty(installDetail.get("uscUnitName"))) {
            String uscUnitCreditCode = (String) installDetail.get("uscUnitCreditCode");
            String uscUnitName = (String) installDetail.get("uscUnitName");
            installDetail.put("uscUnitCodeAndName", uscUnitCreditCode + "_" + uscUnitName);
        }

        // 维保信息
        Map<String, Object> maintenanceDetail = this.baseMapper.getMaintenanceDetailByIdx(record);
        if (!ObjectUtils.isEmpty(maintenanceDetail) && !StringUtils.isEmpty(maintenanceDetail.get("meUnitCreditCode"))
                && !StringUtils.isEmpty(maintenanceDetail.get("meUnitName"))) {
            String meUnitCreditCode = (String) maintenanceDetail.get("meUnitCreditCode");
            String meUnitName = (String) maintenanceDetail.get("meUnitName");
            maintenanceDetail.put("meUnitName", meUnitCreditCode + "_" + meUnitName);
        }

        if (!ObjectUtils.isEmpty(inspectDetail)) {
            detail.putAll(inspectDetail);
        }
        if (!ObjectUtils.isEmpty(useDetail)) {
            useDetail.put("safetyManager", useDetail.get("safetyManagerSeq"));
            detail.putAll(useDetail);
        }
        if (!ObjectUtils.isEmpty(desDetail)) {
            detail.putAll(desDetail);
        }
        if (!ObjectUtils.isEmpty(maintenanceDetail)) {
            detail.putAll(maintenanceDetail);
        }
        if (!ObjectUtils.isEmpty(installDetail)) {
            detail.putAll(installDetail);
        }
        if (!ObjectUtils.isEmpty(supervisionInfo) && !StringUtils.isEmpty(supervisionInfo.get("orgBranchCode"))) {
            String orgBranchCode = (String) supervisionInfo.get("orgBranchCode");
            String orgBranchName = (String) supervisionInfo.get("orgBranchName");
            supervisionInfo.put("orgBranchCode", orgBranchCode + "_" + orgBranchName);
            supervisionInfo.put("hasOrgBranchCode", true);
            detail.putAll(supervisionInfo);
        }
        // 附件解析
        commonServiceImpl.convertStringToJsonobject(detail, jsonFields);
        detail.put("province", "610000");
        return detail;
    }


    private void convertTreeToListMap(LinkedHashMap receiveUnit, List<Map<String, Object>> resultList) {
        resultList.add(receiveUnit);

        if (receiveUnit.containsKey("children") && !ValidationUtil.isEmpty(receiveUnit.get("children"))) {
            List<LinkedHashMap> children = (List<LinkedHashMap>) receiveUnit.get("children");
            for (LinkedHashMap child : children) {
                convertTreeToListMap(child, resultList);
            }
        }
    }

    public String setDefaultRecord(JgUseRegistration jgUseRegistration, String record) {
        if (StringUtils.isEmpty(record)) {
            JgUseRegistrationEq jgUseRegistrationEq = jgUseRegistrationEqService.getOne(new LambdaQueryWrapper<JgUseRegistrationEq>().eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr()));
            record = jgUseRegistrationEq.getEquId();
        }
        return record;
    }

    private Map<String, Object> getInspectDetail(String record) {
        // 去掉约束
        return this.baseMapper.getInspectDetail(record, null);
    }

    private List<String> getInspectInfoByEquDefine(String equList, String equCategory, String equDefine) {
        List<String> permissionInspectTypes = new ArrayList<>();
        // 使用登记时：需要《首次检验》类型检验信息的设备种类、设备类别、设备品种
        String[] FIRST_INSPECT_EQULIST = {"5000"};
        String[] FIRST_INSPECT_EQUCATEGORY = {"4400", "4900", "4A00"};
        String[] FIRST_INSPECT_EQUDEFINE = {"4170"};
        // 使用登记时：需要《安装监督验》类型检验信息的设备种类、设备类别、设备品种
        String[] AZJDJY_INSPECT_EQULIST = {"3000", "6000", "9000", "8000", "1000"};
        String[] AZJDJY_INSPECT_EQUCATEGORY = {"4800", "4300", "4700", "4D00", "2400"};
        String[] AZJDJY_INSPECT_EQUDEFINE = {"4110", "4130", "4140", "4150", "4190", "4220", "4210", "4260", "4270", "4290"};
        // 使用登记时：需要《首次检验》或者《安装监督验检验》信息的设备种类、设备类别、设备品种
        String[] SCJY_OR_AZJDJY_EQULIST = {};
        String[] SCJY_OR_AZJDJY_EQUCATEGORY = {};
        String[] SCJY_OR_AZJDJY_INSPECT_EQUDEFINE = {"4230", "4240", "4250", "4280"};
        if (Arrays.asList(FIRST_INSPECT_EQULIST).contains(equList) || Arrays.asList(FIRST_INSPECT_EQUCATEGORY).contains(equCategory) || Arrays.asList(FIRST_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("SCJY");
            return permissionInspectTypes;
        }
        if (Arrays.asList(AZJDJY_INSPECT_EQULIST).contains(equList) || Arrays.asList(AZJDJY_INSPECT_EQUCATEGORY).contains(equCategory) || Arrays.asList(AZJDJY_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("AZJDJY");
            return permissionInspectTypes;
        }
        if (Arrays.asList(SCJY_OR_AZJDJY_EQULIST).contains(equList) || Arrays.asList(SCJY_OR_AZJDJY_EQUCATEGORY).contains(equCategory) || Arrays.asList(SCJY_OR_AZJDJY_INSPECT_EQUDEFINE).contains(equDefine)) {
            permissionInspectTypes.add("SCJY");
            permissionInspectTypes.add("AZJDJY");
            return permissionInspectTypes;
        }
        // 为空时不需要检验信息，不返回检验信息
        return permissionInspectTypes;
    }

    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response, String printType) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        // 查询使用登记详情
        JgUseRegistration useRegistration = this.getById(sequenceNbr);
        exportParamsMap.put("manageType", useRegistration.getManageType());
        LambdaQueryWrapper<JgUseRegistrationEq> useEqLambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
        useEqLambda.eq(JgUseRegistrationEq::getEquipTransferId, sequenceNbr);
        List<JgUseRegistrationEq> useRegistrationEqList = jgRelationEquipMapper.selectList(useEqLambda);

        if (ValidationUtil.isEmpty(useRegistration) || ValidationUtil.isEmpty(useRegistrationEqList)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        // 登记机关
        if (ValidationUtil.isEmpty(useRegistration.getReceiveOrgName())) {
            throw new BadRequest("使用登记证导出失败,登记机关为空!");
        }
        exportParamsMap.put("receiveOrgName", useRegistration.getReceiveOrgName());
        // 使用登记证编号
        if (ValidationUtil.isEmpty(useRegistration.getUseRegistrationCode())) {
            throw new BadRequest("使用登记证导出失败,使用登记证编号为空!");
        }
        exportParamsMap.put("useRegistrationCode", useRegistration.getUseRegistrationCode());
        // 使用单位名称
        if (ValidationUtil.isEmpty(useRegistration.getUseUnitName())) {
            throw new BadRequest("使用登记证导出失败,使用单位名称为空!");
        }
        exportParamsMap.put("useUnitName", useRegistration.getUseUnitName());

        // 监管码
        if (ValidationUtil.isEmpty(useRegistration.getSupervisoryCode())) {
            throw new BadRequest("使用登记证导出失败,监管码为空!");
        }
        exportParamsMap.put("supervisoryCode", useRegistration.getSupervisoryCode());
        getAuditPassedDate(useRegistration.getAuditPassDate(), exportParamsMap);

        // 查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", useRegistrationEqList.get(0).getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            // 设备种类、类别、品种
            String equList = registerInfo.getEquList();// 设备种类
            String equCategory = registerInfo.getEquCategory();// 设备类别
            String equDefine = registerInfo.getEquDefine();// 设备品种
            List<EquipmentCategory> categoryList0 = commonService.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
            if (CollectionUtils.isNotEmpty(categoryList0)) {
                if (ValidationUtil.isEmpty(categoryList0.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备种类为空!");
                }
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList1)) {
                if (ValidationUtil.isEmpty(categoryList1.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备类别为空!");
                }
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (CollectionUtils.isNotEmpty(categoryList2)) {
                if (ValidationUtil.isEmpty(categoryList2.get(0).getName())) {
                    throw new BadRequest("使用登记证导出失败,设备品种为空!");
                }
                exportParamsMap.put("equDefine", categoryList2.get(0).getName());
            }
            // 设备代码
            if (ValidationUtil.isEmpty(registerInfo.getEquCode())) {
                throw new BadRequest("使用登记证导出失败,设备代码为空!");
            }
            exportParamsMap.put("equCode", registerInfo.getEquCode());
            exportParamsMap.put("carNumber", registerInfo.getCarNumber());
            exportParamsMap.put("equListCode", registerInfo.getEquList());
        }

        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(useRegistrationEqList.get(0).getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            if (ValidationUtil.isEmpty(useInfo.getUseInnerCode())) {
                throw new BadRequest("使用登记证导出失败,设备单位内部编码为空!");
            }
            // 单位内部编码
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());
            // 设备使用地址
            String fullAddress = "";
            if (!ObjectUtils.isEmpty(useInfo.getProvinceName())) {
                fullAddress += useInfo.getProvinceName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCityName())) {
                fullAddress += useInfo.getCityName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getCountyName())) {
                fullAddress += useInfo.getCountyName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getStreetName())) {
                fullAddress += useInfo.getStreetName();
            }
            if (!ObjectUtils.isEmpty(useInfo.getAddress())) {
                fullAddress += useInfo.getAddress();
            }
            if (ValidationUtil.isEmpty(fullAddress)) {
                throw new BadRequest("使用登记证导出失败,设备使用地址为空!");
            }
            exportParamsMap.put("fullAddress", fullAddress);
        }
        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(useRegistrationEqList.get(0).getEquId());
        // 产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            if (ValidationUtil.isEmpty(factoryInfo.getFactoryNum())) {
                throw new BadRequest("使用登记证导出失败,产品编号为空!");
            }
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        exportParamsMap.put("applyNo", useRegistration.getApplyNo());
        if ("0".equals(printType)) {
            // 调用生成使用登记证
            commonService.generateCertificateReport(exportParamsMap, response);
        } else if ("1".equals(printType)) {
            // 套打
            // commonService.generatePdfPrint(exportParamsMap, response);
            commonService.generateCertificateReportDoc(exportParamsMap, response);
        } else if ("2".equals(printType)) {
            // 使用标志普通打印
            commonService.useFlagGenerate(this.buildUseFlagParamDto(useRegistration, registerInfo, factoryInfo, exportParamsMap), response);
        } else if ("3".equals(printType)) {
            // 使用标志套打
            commonService.fightUseFlagGenerate(this.buildUseFlagParamDto(useRegistration, registerInfo, factoryInfo, exportParamsMap), response);
        }
    }

    /**
     * 获取导出基本信息数据
     * @param useRegistrationSeqs
     * @param category
     * @param whetherToFilterStatus 是否过滤设备状态 是：true（过滤设备状态为在用），否：false（所有的）
     * @return
     */
    public List<CompletableFuture<byte[]>> getExportSummaryBasicInfoData(List<Long> useRegistrationSeqs, String category, String type, Boolean whetherToFilterStatus) {
        List<CompletableFuture<byte[]>> futureList = new ArrayList<>();
        // 总数
        double total;
        // 每页显示条数，默认 10
        int size = 10;
        LambdaQueryWrapper<JgRegistrationHistory> lambda = new QueryWrapper<JgRegistrationHistory>().lambda();
        lambda.in(JgRegistrationHistory::getCurrentDocumentId, useRegistrationSeqs);
        List<JgRegistrationHistory> registrationHistoryList = jgRegistrationHistoryService.getBaseMapper().selectList(lambda);
        if (ValidationUtil.isEmpty(registrationHistoryList)) {
            throw new BadRequest("没有查询到汇总信息！");
        }
        JSONArray allEquipment = new JSONArray();
        // 用Set存储已添加的equCode，防止重复添加
        Set<String> addedEquCodes = new HashSet<>();
        registrationHistoryList.forEach(historyList -> {
            JSONObject jsonObject = JSONObject.parseObject(historyList.getChangeData());
            JSONArray equipmentLists = "安装告知".equals(type)
                    ? (JSONArray) jsonObject.get("deviceList")
                    : (JSONArray) jsonObject.get("equipmentLists");

            final String useDateValue = jsonObject.getString("useDate");
            if (CollectionUtils.isNotEmpty(equipmentLists)) {
                equipmentLists.stream()
                        .map(obj -> (JSONObject) obj)
                        .filter(equipmentItem -> whetherToFilterStatus || this.checkEquStatusInUse(equipmentItem.getString("record")))
                        .forEach(item -> {
                            item.put("useDate", timeToMonths(useDateValue));
                            allEquipment.add(item);
                            addedEquCodes.add(item.getString("equCode"));
                        });
            }
        });
        total = allEquipment.size();
        AgencyUserModel result = new AgencyUserModel();
        // 暂时拿第一条的 监管部门和安全管理人员
        JSONObject jsonObjectFirst = new JSONObject();
        if (!ValidationUtil.isEmpty(registrationHistoryList.get(0))) {
            JgRegistrationHistory jgRegistrationHistory = registrationHistoryList.get(0);
            jsonObjectFirst = JSONObject.parseObject(jgRegistrationHistory.getChangeData());
        }
        if("安装告知".equals(type)){
            //人员信息去registrationHistoryList的第一条信息的创建人
            JgRegistrationHistory jgRegistrationHistory = registrationHistoryList.get(0);
            if (!ValidationUtil.isEmpty(jgRegistrationHistory)) {
                String createUserId = jsonObjectFirst.getString("createUserId");
                if (!ValidationUtil.isEmpty(createUserId)) {
                    result = Privilege.agencyUserClient.queryByUserId(createUserId).getResult();
                }
            }
        }else {
            JgUseRegistration jgUseRegistration = jgUseRegistrationMapper.selectOne(new QueryWrapper<JgUseRegistration>().lambda()
                    .eq(JgUseRegistration::getSequenceNbr, useRegistrationSeqs.get(0)).eq(JgUseRegistration::getIsDelete, false));
            if (!ValidationUtil.isEmpty(jgUseRegistration.getCreateUserId())) {
                result = Privilege.agencyUserClient.queryByUserId(jgUseRegistration.getCreateUserId()).getResult();
            }
        }
        if ("8300".equals(category) || "8200".equals(category) || "8100".equals(category)) {// 压力管道基本信息汇总表
            // 模板
            String wordPath = "PressurePipeBasicInformationSummary.ftl";
            // 文件名前缀
            String filePrefix = "压力管道基本信息汇总表_";
            // 总页数
            int page = (int) Math.ceil(total / size);
            // 异步获取数据
            futureList = pressurePipeDataPreparation(page, jsonObjectFirst, size, total, allEquipment, wordPath, filePrefix, result,category);
        } else if ("2300".equals(category)) {// 气瓶基本信息汇总表
            // 模板
            String wordPath = "CylinderBasicInformationSummary.ftl";
            // 文件名前缀
            String filePrefix = "气瓶基本信息汇总表_";
            // 总页数
            int page = (int) Math.ceil(total / size);
            // 异步获取数据
            futureList = cylinderDataPreparation(page, jsonObjectFirst, size, total, allEquipment, wordPath, filePrefix, result);

        }
        return futureList;
    }

    /**
     * 根据record判断设备状态是否为【在用】
     * @param record
     * @return
     */
    private boolean checkEquStatusInUse(String record) {
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.lambdaQuery().eq(IdxBizJgUseInfo::getRecord, record).one();
        if (!Objects.isNull(useInfo) && !ValidationUtil.isEmpty(useInfo.getEquState())) {
            return EquimentEnum.ZAIYONG.getCode().toString().equals(useInfo.getEquState());
        }
        return false;
    }

    /**
     * 导出基本信息汇总表(工业管道/气瓶)
     *
     * @param useRegistrationSeqs
     * @param response
     */
    public void exportSummaryBasicInfo(List<Long> useRegistrationSeqs, HttpServletResponse response, String category) {
        JgUseRegistration jgUseRegistration = jgUseRegistrationMapper.selectOne(new QueryWrapper<JgUseRegistration>().lambda()
                .eq(JgUseRegistration::getSequenceNbr, useRegistrationSeqs.get(0)).eq(JgUseRegistration::getIsDelete, false));
        List<CompletableFuture<byte[]>> futures = getExportSummaryBasicInfoData(useRegistrationSeqs, category, "", Boolean.FALSE);
        if ("8300".equals(category) || "8200".equals(category) || "8100".equals(category)) {
            // 文件名前缀
            String filePrefix = "压力管道基本信息汇总表_";
            // 压力包名称
            String customFileName = filePrefix + jgUseRegistration.getApplyNo() + ".zip";
            // byte[]压缩zip
            toZipFile(response, futures, filePrefix, customFileName);
        }else if ("2300".equals(category)) {
            // 文件名前缀
            String filePrefix = "气瓶基本信息汇总表_";
            // 压力包名称
            String customFileName = filePrefix + jgUseRegistration.getApplyNo() + ".zip";
            // byte[]压缩zip
            toZipFile(response, futures, filePrefix, customFileName);
        }

    }

    /**
     * 气瓶数据
     *
     * @return
     */
    private List<CompletableFuture<byte[]>> cylinderDataPreparation(int page, JSONObject jsonObject, int size, double total, JSONArray equipmentLists, String wordPath, String filePrefix, AgencyUserModel result) {
        List<CompletableFuture<byte[]>> futures = IntStream.rangeClosed(1, page)
                .mapToObj(current -> CompletableFuture.supplyAsync(() -> {
                    Map<String, Object> exportParamsMap = new HashMap<>();
                    exportParamsMap.put("current", current);
                    exportParamsMap.put("page", page);
                    LocalDate currentDate = LocalDate.now();
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    String formattedDate = currentDate.format(formatter);
                    exportParamsMap.put("printDate", formattedDate);
                    // 使用单位
                    exportParamsMap.put("useUnitName", jsonObject.get("useUnitName"));
                    // 联系电话
                    exportParamsMap.put("phone", ValidationUtil.isEmpty(result.getMobile()) ? "" : result.getMobile());
                    // 经办人
                    exportParamsMap.put("agent", ValidationUtil.isEmpty(result.getRealName()) ? "" : result.getRealName());
                    // 电子邮箱
                    exportParamsMap.put("email", ValidationUtil.isEmpty(result.getEmail()) ? "" : result.getEmail());
                    // 数据分页
                    int start = (current - 1) * size;
                    int end = ((current - 1) * size + size) < total ? (current - 1) * size + size : (int) total;
                    // 数据截取
                    List<Object> equData = equipmentLists.subList(start, end);
                    Map<String, String> recordInformationMap = this.getInformationManageInfo(equData);
                    // 设备数据填充
                    this.fillInCylinderEquData(exportParamsMap, equData, size, recordInformationMap);
                    return commonService.generateSummaryOfCylinderInfo(exportParamsMap, wordPath, filePrefix);
                })).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[page])).join();
        return futures;
    }

    private Map<String, String> getInformationManageInfo(List<Object> equData) {
        List<String> records = new ArrayList<>();
        equData.forEach(e->{
            JSONObject jsonObject = (JSONObject)e;
            String record = jsonObject.getString("record");
            records.add(record);
        });
        LambdaQueryWrapper<IdxBizJgOtherInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(IdxBizJgOtherInfo::getRecord, IdxBizJgOtherInfo::getInformationSituation, IdxBizJgOtherInfo::getInformationManageCode);
        wrapper.in(IdxBizJgOtherInfo::getRecord, records);
        List<IdxBizJgOtherInfo> jgOtherInfos = otherInfoMapper.selectList(wrapper);
        return jgOtherInfos.stream()
                .collect(Collectors.toMap(
                        IdxBizJgOtherInfo::getRecord,
                        other -> "3".equals(other.getInformationSituation())
                                ? other.getInformationManageCode()
                                : InformationManageTypeEnum.getName(other.getInformationSituation()),
                        (oldVal, newVal) -> newVal
                ));
    }

    /**
     * 压力管道数据
     *
     * @return
     */
    private List<CompletableFuture<byte[]>> pressurePipeDataPreparation(int page, JSONObject jsonObject, int size, double total, JSONArray equipmentLists, String wordPath, String filePrefix, AgencyUserModel result,String category) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        exportParamsMap.put("page", page);
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDate = currentDate.format(formatter);
        exportParamsMap.put("printDate", formattedDate);
        //获取分类名称
        exportParamsMap.put("categoryName", PipelineEnum.getMessage(category));
        // 使用单位
        exportParamsMap.put("useUnitName", jsonObject.get("useUnitName"));
        // 使用单位地址
        String useUnitCreditCode = String.valueOf(jsonObject.get("useUnitCreditCode"));
        TzBaseEnterpriseInfo enterpriseInfo = tzBaseEnterpriseInfoMapper.selectOne(new LambdaQueryWrapper<TzBaseEnterpriseInfo>().eq(TzBaseEnterpriseInfo::getUseCode, useUnitCreditCode));
        exportParamsMap.put("fullAddress", enterpriseInfo.getAddress());
        if (equipmentLists.isEmpty()) {
            exportParamsMap.put("nameOfProjectDevice", "");
        } else {
            // 工程（装置）名称 取第一个设备的技术参数”工程装置名称“
            JSONObject eqJSON = (JSONObject) equipmentLists.get(0);
            String eqId = !ValidationUtil.isEmpty(eqJSON) ? String.valueOf(eqJSON.get("record")) : "";
            IdxBizJgUseInfo idxBizJgUseInfo = useInfoMapper.selectOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, eqId));
            exportParamsMap.put("nameOfProjectDevice", ValidationUtil.isEmpty(idxBizJgUseInfo) ? "" : idxBizJgUseInfo.getProjectContraption());
        }
        // 安全管理部门
        exportParamsMap.put("orgBranchName", String.valueOf(jsonObject.get("orgBranchCode")).contains("_") ? String.valueOf(jsonObject.get("orgBranchCode")).split("_")[1] : jsonObject.getString("orgBranchName") == null ? "": jsonObject.getString("orgBranchName"));
        // 安全管理员
        exportParamsMap.put("safetyManager", String.valueOf(jsonObject.get("safetyManager")).contains("_") ? String.valueOf(jsonObject.get("safetyManager")).split("_")[1] : jsonObject.getString("safetyManager") == null ? "": jsonObject.getString("safetyManager"));
        // 联系电话
        exportParamsMap.put("phone", ValidationUtil.isEmpty(result.getMobile()) ? "" : result.getMobile());
        // 经办人
        exportParamsMap.put("agent", ValidationUtil.isEmpty(result.getRealName()) ? "" : result.getRealName());
        // 电子邮箱
        exportParamsMap.put("email", ValidationUtil.isEmpty(result.getEmail()) ? "" : result.getEmail());

        List<CompletableFuture<byte[]>> futures = IntStream.rangeClosed(1, page)
                .mapToObj(current -> CompletableFuture.supplyAsync(() -> {
                    // 创建独立的参数副本
                    Map<String, Object> currentExportParamsMap = new HashMap<>(exportParamsMap);
                    currentExportParamsMap.put("current", current);
                    // 数据分页
                    int start = (current - 1) * size;
                    int end = ((current - 1) * size + size) < total ? (current - 1) * size + size : (int) total;
                    // 数据截取
                    List<Object> equData = equipmentLists.subList(start, end);
                    // 设备数据填充
                    this.pressurePipeEquData(currentExportParamsMap, equData, current, size);
                    return commonService.generateSummaryOfCylinderInfo(currentExportParamsMap, wordPath, filePrefix);
                })).collect(Collectors.toList());
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[page])).join();
        return futures;
    }

    private String spliceFullAddress(TzBaseEnterpriseInfo enterpriseInfo) {
        String address = enterpriseInfo.getAddress();
        boolean hasProvince = address.contains("省");
        boolean hasCity = address.contains("市");
        boolean hasDistrict = address.contains("区");
        if (hasProvince || hasCity || hasDistrict) {
            return address;
        }
        return enterpriseInfo.getProvince() + enterpriseInfo.getCity() + enterpriseInfo.getDistrict() + enterpriseInfo.getStreet() + enterpriseInfo.getCommunity() + enterpriseInfo.getAddress();
    }

    /**
     * 气瓶设备数据填充
     */
    private void fillInCylinderEquData(Map<String, Object> exportParamsMap, List<Object> equData, int size, Map<String, String> recordInformationMap) {

        String[] fieldNames = {"equDefineName", "factoryNum", "chargingMedium",
                "produceUnitName", "produceDate", "nominalWorkingPressure",
                "singleBottleVolume", "inspectDate", "nextInspectDate", "useInnerCode","informationSituation"};
        // 填充有效数据
        for (int curr = 0; curr < equData.size(); curr++) {
            JSONObject obj = (JSONObject) equData.get(curr);
            // 新增字段信息化管理情况
            obj.put("informationSituation", recordInformationMap.get(obj.getString("record")));
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put(fieldName + serialNum, ValidationUtil.isEmpty(obj.get(fieldName)) ? "" : obj.get(fieldName));
            }
        }

        // 填充剩余空白项至指定总页数
        for (int curr = equData.size(); curr < size; curr++) {
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put(fieldName + serialNum, ""); // 使用空字符串填充空白项
            }
        }
    }

    /**
     * 压力管道设备数据填充
     */
    public void pressurePipeEquData(Map<String, Object> exportParamsMap, List<Object> equData, int current, int size) {

        String[] fieldNames = {"productName", "pipelineNumber", "deviceLevel", "designUnitName", "uscUnitName",
                "uscDate", "useDate", "nominalDiameter", "wallThickness", "pipeLength", "pressure", "temperature",
                "medium", "inspectConclusion", "inspectOrgName", "nextInspectDate", "remarks"};
        // 填充有效数据
        for (int curr = 0; curr < equData.size(); curr++) {
            JSONObject obj = (JSONObject) equData.get(curr);

            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put("num" + serialNum, (current - 1) * size + (curr + 1));
                exportParamsMap.put(fieldName + serialNum, setSpecialParamFields(fieldName, obj));
            }
        }

        // 填充剩余空白项至指定总页数
        for (int curr = equData.size(); curr < size; curr++) {
            int serialNum = curr + 1;
            for (String fieldName : fieldNames) {
                exportParamsMap.put("num" + serialNum, "");
                exportParamsMap.put(fieldName + serialNum, ""); // 使用空字符串填充空白项
            }
        }
    }

    private Object trimIfEmpty(Object obj) {
        return ValidationUtil.isEmpty(obj) ? "" : obj;
    }


    private Object setSpecialParamFields(String fieldName, JSONObject equip){
        switch (fieldName) {
            case "pressure":
                return trimIfEmpty(equip.get(fieldName)) + "/" + trimIfEmpty(equip.get("workPressure"));
            case "temperature":
                return trimIfEmpty(equip.get(fieldName)) + "/" + trimIfEmpty(equip.get("workTemperature"));
            case "medium":
                return trimIfEmpty(equip.get(fieldName)) + "/" + trimIfEmpty(equip.get("workMedium"));
            default:
                return ValidationUtil.isEmpty(equip.get(fieldName)) ? "" : equip.get(fieldName);
        }
    }


    /**
     * 填充设备最新的数据至历史json
     *
     * @param jsonObject        历史json
     * @param jgUseRegistration 使用信息
     * @param record            设备唯一标识
     */
    void fillHistoryDataWithNewEquip(JSONObject jsonObject, JgUseRegistration jgUseRegistration, String record) {
        // 非已完成、非作废时显示设备最新信息。前置需求：一个设备只能同时发起一个流程
        if (!(FlowStatusEnum.TO_BE_FINISHED.getName().equals(jgUseRegistration.getStatus())
                || FlowStatusEnum.TO_BE_DISCARD.getName().equals(jgUseRegistration.getStatus()))
                || "1".equals(jgUseRegistration.getRegType())) {
            fillLastEquipDetail(jsonObject, record);
        }
    }

    public void fillLastEquipDetail(JSONObject jsonObject, String record) {
        // 基本信息 + 制造信息 + 设计信息
        fillLastEquipBaseInfo(jsonObject, record);
        // 安装信息
        if(!jsonObject.containsKey("installationIsComplete")) {
            Map<String, Object> installDetail = this.baseMapper.getiInstallDetail(record);
            // 历史设备登记来的数据没有安装业务信息 从一码通数据拿
            if (ValidationUtil.isEmpty(installDetail)) {
                installDetail = this.baseMapper.getiInstallDetailByIdx(record);
            }
            if (!ObjectUtils.isEmpty(installDetail)) {
                jsonObject.putAll(installDetail);
            }
        }
        // 维保信息
        Map<String, Object> maintenanceDetail = this.baseMapper.getMaintenanceDetail(record);
        // 历史设备登记来的数据没有维保业务信息 从一码通数据拿
        if (ValidationUtil.isEmpty(maintenanceDetail)) {
            maintenanceDetail = this.baseMapper.getMaintenanceDetailByIdx(record);
        }
        if (!ObjectUtils.isEmpty(maintenanceDetail)) {
            jsonObject.putAll(maintenanceDetail);
        }
    }

    public void fillLastEquipBaseInfo(JSONObject jsonObject, String record) {
        // 基本信息 + 制造信息
        Map<String, Object> detail = this.baseMapper.getDetail(record);
        // 设计信息
        Map<String, Object> desDetail = this.baseMapper.getDesDetail(record);
        if (!ObjectUtils.isEmpty(desDetail)) {
            detail.putAll(desDetail);
        }
        jsonObject.putAll(detail);
    }

    private UseFlagParamDto buildUseFlagParamDto(JgUseRegistration useRegistration, IdxBizJgRegisterInfo registerInfo, IdxBizJgFactoryInfo factoryInfo, Map<String, Object> exportParamsMap) {
        UseFlagParamDto useFlagParamDto = new UseFlagParamDto();
        useFlagParamDto.setReceiveCompanyCode(useRegistration.getReceiveCompanyCode());
        useFlagParamDto.setEquList(exportParamsMap.get("equList").toString());
        useFlagParamDto.setEquListCode(registerInfo.getEquList());
        useFlagParamDto.setEquipCode(registerInfo.getEquCode());
        useFlagParamDto.setEquipCategory(exportParamsMap.get("equCategory").toString());
        useFlagParamDto.setEquipDefine(Optional.ofNullable(exportParamsMap.get("equDefine"))
                .orElse(exportParamsMap.get("equCategory").toString())
                .toString());
        useFlagParamDto.setUseUnitName(exportParamsMap.get("useUnitName").toString());
        useFlagParamDto.setUseInnerCode(exportParamsMap.get("useInnerCode").toString());
        useFlagParamDto.setReceiveOrgName(useRegistration.getReceiveOrgName());
        useFlagParamDto.setUseRegistrationCode(exportParamsMap.get("useRegistrationCode").toString());
        useFlagParamDto.setFactoryNumber(factoryInfo.getFactoryNum());
        useFlagParamDto.setCarNumber(registerInfo.getCarNumber());
        useFlagParamDto.setCertificateNo(useRegistration.getApplyNo());
        // 检验信息字段设置
        setInspectField(registerInfo, useFlagParamDto);
        // 电梯维保信息字段设置
        setMainInfoField(registerInfo, useFlagParamDto);
        // 车用气瓶专用字段 暂无数据源 需车用气瓶功能开发完成后进行
        useFlagParamDto.setCylinderNumOrVolume("");
        useFlagParamDto.setFillingMedium("");
        return useFlagParamDto;
    }

    private void setInspectField(IdxBizJgRegisterInfo registerInfo, UseFlagParamDto useFlagParamDto) {
        Map<String, Object> inspectDetail = this.baseMapper.getInspectDetail(registerInfo.getRecord(), null);
        useFlagParamDto.setInspectionUnitName(inspectDetail.get("inspectOrgName") == null ? "" : inspectDetail.get("inspectOrgName").toString());
        useFlagParamDto.setNextInspectionDate(inspectDetail.get("nextInspectDate") == null ? null : (Date) inspectDetail.get("nextInspectDate"));
    }

    private void setMainInfoField(IdxBizJgRegisterInfo registerInfo, UseFlagParamDto useFlagParamDto) {
        IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfo = idxBizJgMaintenanceRecordInfoService.queryNewestDetailByRecord(registerInfo.getRecord());

        useFlagParamDto.setEmergencyTel(this.buildEmergencyTel(idxBizJgMaintenanceRecordInfo));
        useFlagParamDto.setMaintenanceUnitName(idxBizJgMaintenanceRecordInfo.getMeUnitName() == null ? "" : idxBizJgMaintenanceRecordInfo.getMeUnitName());
    }

    private String buildEmergencyTel(IdxBizJgMaintenanceRecordInfo idxBizJgMaintenanceRecordInfo) {
        if (StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMasterPhone()) && StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMaster1Phone())) {
            return idxBizJgMaintenanceRecordInfo.getMeMasterPhone() + "/" + idxBizJgMaintenanceRecordInfo.getMeMaster1Phone();
        }
        return StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMasterPhone()) ? idxBizJgMaintenanceRecordInfo.getMeMasterPhone() : StringUtil.isNotEmpty(idxBizJgMaintenanceRecordInfo.getMeMaster1Phone()) ? idxBizJgMaintenanceRecordInfo.getMeMaster1Phone() : "";
    }

    /**
     * 生成监管码、96333码
     */
    public void createCode(JSONObject dataMap, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo
            registerInfo, IdxBizJgUseInfo useInfo, IdxBizJgOtherInfo otherInfo) {
        if (ObjectUtils.isEmpty(otherInfo.getSupervisoryCode())) {
            // 生成监管码、96333码
            Map<String, Object> map = new HashMap<>();
            map.put("cityCode", useInfo.getCity());
            map.put("countyCode", useInfo.getCounty());
            map.put("equCategory", registerInfo.getEquCategory());
            map.put("isXiXian", dataMap.get("isXixian"));
            //有96333码,不生成96333码，只生成监管码
            if ("1".equals(otherInfo.getCode96333Type())) {
                map.put("code96333", otherInfo.getCode96333());
            }
            ResponseModel<Map<String, Object>> code = tzsServiceFeignClient.createCode(map);
            Map<String, Object> result = code.getResult();
            if (!ObjectUtils.isEmpty(result)) {
                otherInfo.setSupervisoryCode(String.valueOf(result.get("superviseCode")));
                // 历史登记时 96333如果自行输入则不再进行生成插入
                if(StringUtils.isEmpty(otherInfo.getCode96333())){
                    otherInfo.setCode96333(ObjectUtils.isEmpty(result.get("code96333")) ? "" : String.valueOf(result.get("code96333")));
                }
                // 更新使用登记业务表
                jgUseRegistration.setSupervisoryCode(String.valueOf(result.get("superviseCode")));
            }
        } else {
            jgUseRegistration.setSupervisoryCode(otherInfo.getSupervisoryCode());
        }
        otherInfo.setClaimStatus("已认领");
        otherInfoMapper.updateById(otherInfo);
    }

    private void processElseDataByStatus(String flowStatus, JgUseRegistration jgUseRegistration) {
        switch (flowStatus) {
            case "使用单位待提交":
                // 1.删除暂存时生成的待办
                commonServiceImpl.deleteTasksByRelationId(jgUseRegistration.getSequenceNbr() + "");
                break;
            case "已完成":
                // 1.删除与设备的关系，设备可再次发起使用登记
                this.clearUseInfoOfEquip(jgUseRegistration);
                // 2.清空redis（缓存的流程中及已完成使用登记的设备）
                this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);
                // 3.作废对应的使用登记证
                this.invalidUseRegistrationCertificate(jgUseRegistration);
                break;
            default:
                // 流程中
                // 1.待办任务更新为已完成
                this.finishedTask(jgUseRegistration);
                // 2.终止流程-工作流报错暂时注释掉
                cmWorkflowService.stopProcess(jgUseRegistration.getInstanceId(), jgUseRegistration.getCancelReason());
                // 3.清空redis（缓存的流程中及已完成使用登记的设备）
                this.clearDataForCheckEquipRepeatUsed(jgUseRegistration);
        }
    }

    /**
     * 使用登记单条作废
     *
     * @param sequenceNbr  唯一标识
     * @param cancelReason 作废原因
     * @return JgUseRegistration
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public JgUseRegistration cancelApplication(Long sequenceNbr, String cancelReason) {
        // 1.单据更新为已作废
        JgUseRegistration jgUseRegistration = this.getById(sequenceNbr);
        String oldStatus = jgUseRegistration.getStatus();
        jgUseRegistration.setCancelReason(cancelReason);
        jgUseRegistration.setCancelDate(new Date());
        jgUseRegistration.setCancelUserId(RequestContext.getExeUserId());
        jgUseRegistration.setNextExecuteUserIds("");
        jgUseRegistration.setPromoter("");
        List<JgUseRegistrationEq> eqList = getJgUseRegistrationEqs(jgUseRegistration);
        List<String> records = eqList.stream().map(JgUseRegistrationEq::getEquId).collect(Collectors.toList());
        jgUseRegistration.setStatus(FlowStatusEnum.TO_BE_DISCARD.getName());

        // 单位办理
        if ("unit".equals(jgUseRegistration.getManageType())){
            //单位办理-历史作废
            if ("1".equals(jgUseRegistration.getRegType())){
                // 构建设备删除的 DTO 列表
                List<ESEquipmentCategoryDto> esDtoList = records.stream().map(v -> {
                    ESEquipmentCategoryDto esDto = new ESEquipmentCategoryDto();
                    esDto.setSEQUENCE_NBR(v);
                    return esDto;
                }).collect(Collectors.toList());
                //删除涉及的19张表的数据
                superviseInfoMapper.deleteDataAll(records);
                //删除es中的数据
                esEquipmentCategory.deleteAll(esDtoList);
                //作废使用登记证 & 生成使用登记证的流水
                this.invalidUseRegistrationCertificate(jgUseRegistration);
                // 单据逻辑删除
                this.lambdaUpdate().set(JgUseRegistration::getIsDelete, Boolean.TRUE).eq(JgUseRegistration::getSequenceNbr, sequenceNbr).update();
                // 管道作废工程装置
                if (!ValidationUtil.isEmpty(jgUseRegistration.getProjectContraptionId())) {
                    idxBizJgProjectContraptionMapper.delete(new LambdaQueryWrapper<IdxBizJgProjectContraption>().eq(IdxBizJgProjectContraption::getSequenceNbr,jgUseRegistration.getProjectContraptionId()));
                }
            } else{
                //判断是否管道
                if (FlowStatusEnum.TO_BE_FINISHED.getName().equals(oldStatus) &&
                        jgUseRegistration.getUseRegistrationCode().startsWith("管")) {
                    JgUseRegistration lastUseRegistration = jgUseRegistrationMapper.selectOne(new LambdaQueryWrapper<JgUseRegistration>()
                            .select(JgUseRegistration::getApplyNo)
                            .eq(JgUseRegistration::getProjectContraptionId, jgUseRegistration.getProjectContraptionId())
                            .ne(JgUseRegistration::getStatus, "已作废")
                            .eq(JgUseRegistration::getIsDelete, false)
                            .orderByDesc(JgUseRegistration::getApplyNo)
                            .last("limit 1"));

                    if (lastUseRegistration != null && !lastUseRegistration.getApplyNo().equals(jgUseRegistration.getApplyNo())) {
                        throw new BadRequest("作废失败，该使用登记证下有合并工程装置，请先作废最新单据后再作废此单据！");
                    }
                    if (jgUseRegistration.getProjectContraptionId() == null) {
                        throw new BadRequest("该作废单据没有工程装置，请联系管理员处理此单据:"+ jgUseRegistration.getApplyNo());
                    }
                }
                if (jgUseRegistration.getProjectContraptionId() != null) {
                    //2.合并后作废
                    if (!jgUseRegistration.getOriginProjectContraptionIds().contains(jgUseRegistration.getProjectContraptionId())){
                        eqList.stream()
                                .filter(v -> jgUseRegistration.getOriginProjectContraptionIds().contains(v.getOriginProjectContraptionId()))
                                .forEach(v -> esEquipmentCategory.findById(v.getEquId()).ifPresent(equInfoEs -> {
                                    equInfoEs.setProjectContraptionId(v.getOriginProjectContraptionId());
                                    esEquipmentCategory.save(equInfoEs);

                                    LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
                                    lambda.eq(IdxBizJgUseInfo::getRecord, String.valueOf(v.getEquId()));
                                    IdxBizJgUseInfo useInfo = useInfoMapper.selectOne(lambda);
                                    useInfo.setProjectContraptionId(v.getOriginProjectContraptionId());
                                    useInfoMapper.updateById(useInfo);

                                    IdxBizJgProjectContraption originProjectContraption = jgProjectContraptionService.getById(v.getOriginProjectContraptionId());
                                    //还原 原工程装置下equCode和监管码
                                    LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new UpdateWrapper<IdxBizJgRegisterInfo>().lambda()
                                            .eq(IdxBizJgRegisterInfo::getRecord, v.getEquId());
                                    IdxBizJgRegisterInfo idxBizJgRegisterInfo = new IdxBizJgRegisterInfo();
                                    idxBizJgRegisterInfo.setEquCode(originProjectContraption.getEquCode());
                                    idxBizJgRegisterInfoMapper.update(idxBizJgRegisterInfo, updateWrapper);

                                    LambdaUpdateWrapper<IdxBizJgOtherInfo> otherInfoLambdaUpdateWrapper = new UpdateWrapper<IdxBizJgOtherInfo>().lambda()
                                            .eq(IdxBizJgOtherInfo::getRecord, v.getEquId());
                                    IdxBizJgOtherInfo idxBizJgOtherInfo = new IdxBizJgOtherInfo();
                                    idxBizJgOtherInfo.setSupervisoryCode(originProjectContraption.getSupervisoryCode());
                                    otherInfoMapper.update(idxBizJgOtherInfo, otherInfoLambdaUpdateWrapper);
                                }));
                        //2.根据工程装置ID查询工程装置父级，重置子工程装置父级为空
                        jgProjectContraptionService.update(
                                new LambdaUpdateWrapper<IdxBizJgProjectContraption>()
                                        .in(BaseEntity::getSequenceNbr, Arrays.asList(jgUseRegistration.getOriginProjectContraptionIds().split(",")))
                                        .set(IdxBizJgProjectContraption::getProjectContraptionParentId, null)
                        );
                        JgRegistrationHistory history = jgRegistrationHistoryService.queryLatestRegistrationHistory(Long.valueOf(jgUseRegistration.getProjectContraptionId()));
                        if (history != null && history.getChangeData() != null) {
                            JSONObject hisJson = JSON.parseObject(history.getChangeData());
                            boolean isFirstMerge = Optional.ofNullable(hisJson.get("isFirstMerge"))
                                    .map(Boolean.class::cast)
                                    .orElse(false);
                            //合并到无证总工程
                            IdxBizJgProjectContraption projectContraption = jgProjectContraptionService.getById(jgUseRegistration.getProjectContraptionId());
                            if (isFirstMerge) {
                                projectContraption.setIsIntoManagement(false);
                                projectContraption.setIsFirstMerge(true);
                                projectContraption.setSupervisoryCode(null);
                                projectContraption.setEquCode(null);
                                projectContraption.setUseRegistrationCode(null);
                                projectContraption.setPipelineLength(0.0);
                                // 处理非批量导入数据，更新关联业务状态
                                processElseDataByStatus(oldStatus, jgUseRegistration);
                                // 统一处理设备的纳管状态【注册事务提交后的操作】
                                registerAfterCommitTask(records);
                            }else{
                                // 查询原工程装置及 useInfo 记录
                                List<String> originProjectContraptionIds = Arrays.asList(jgUseRegistration.getOriginProjectContraptionIds().split(","));
                                List<IdxBizJgProjectContraption> originProjectContraptionList = jgProjectContraptionService.lambdaQuery()
                                        .in(BaseEntity::getSequenceNbr, originProjectContraptionIds)
                                        .list();

                                records = idxBizJgUseInfoService.lambdaQuery()
                                        .select(IdxBizJgUseInfo::getRecord)
                                        .in(IdxBizJgUseInfo::getProjectContraptionId, originProjectContraptionIds)
                                        .list()
                                        .stream()
                                        .map(IdxBizJgUseInfo::getRecord)
                                        .collect(Collectors.toList());

                                // 统一处理设备的纳管状态
                                registerAfterCommitTask(records);
                                processElseDataByStatus(oldStatus, jgUseRegistration);
                                if (FlowStatusEnum.TO_BE_FINISHED.getName().equals(oldStatus)) {
                                    // 计算管道长度并更新
                                    double originPipelineLength = originProjectContraptionList.stream()
                                            .map(IdxBizJgProjectContraption::getPipelineLength)
                                            .filter(Objects::nonNull)
                                            .mapToDouble(Double::doubleValue)
                                            .sum();
                                    projectContraption.setPipelineLength(projectContraption.getPipelineLength() - originPipelineLength);
                                }
                            }
                            jgProjectContraptionService.updateById(projectContraption);
                        }
                    }
                    //1.子工程装置作废，正常逻辑
                    else {
                        // 统一处理设备的纳管状态【注册事务提交后的操作】
                        processElseDataByStatus(oldStatus, jgUseRegistration);
                        this.rollBackForPieLine(jgUseRegistration);
                        registerAfterCommitTask(records);
                    }
                }
                //气瓶
                else {
                    // 处理非批量导入数据，更新关联业务状态
                    processElseDataByStatus(oldStatus, jgUseRegistration);
                    // 统一处理设备的纳管状态【注册事务提交后的操作】
                    registerAfterCommitTask(records);
                }
            }
        }
        //台套办理
        else {
            // 处理非批量导入数据，更新关联业务状态
            processElseDataByStatus(oldStatus, jgUseRegistration);
            // 统一处理设备的纳管状态【注册事务提交后的操作】
            registerAfterCommitTask(records);
        }
        this.updateById(jgUseRegistration);
        return jgUseRegistration;
    }

    /**
     * 注册事务提交后的同步操作
     */
    private void registerAfterCommitTask(List<String> records) {
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                // 发布作废事件
                eventPublisher.publish(new CancellationEvent(this, records));
            }
        });
    }

    private void clearUseInfoOfEquip(JgUseRegistration jgUseRegistration) {
        List<JgUseRegistrationEq> eqList = getJgUseRegistrationEqs(jgUseRegistration);
        //非管道
        if(StringUtils.isEmpty(jgUseRegistration.getProjectContraptionId())){
            eqList.forEach(e -> {
                String record = e.getEquId();
                Boolean flag = Boolean.FALSE;
                LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                lambdaQueryWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
                IdxBizJgRegisterInfo idxBizJgRegisterInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaQueryWrapper);
                if (!ObjectUtils.isEmpty(idxBizJgRegisterInfo)) {
                    String equCategory = idxBizJgRegisterInfo.getEquCategory();
                    List<String> codes = UseRegisterCancelEquipEnum.getCodes();
                    if (codes.contains(equCategory)) {
                        flag = Boolean.TRUE;
                    }
                }
                // 1.使用信息表部分字段赋空
                this.rollBackUseInfo(record, flag);
                // 2.回滚更新idx_biz_jg_register_info表
                this.rollBackRegisterInfo(record, jgUseRegistration);
                // 3.回滚更新idx_biz_jg_supervision_info表
                this.rollBackSupervisionInfo(record);
                // 4.es的EQU_STATE,  USE_ORG_CODE、ORG_BRANCH_CODE、ORG_BRANCH_NAME、STATUS
                this.rollBackForEquipEsInfo(record, flag,jgUseRegistration);
                // 5.历史设备处理
                this.dealHisRegEquipData(jgUseRegistration, record);
            });
        }
        Set<String> equipTransferIds = eqList.stream()
                .map(JgUseRegistrationEq::getEquipTransferId)
                .filter(Objects::nonNull)
                .collect(Collectors.toSet());
        if (!equipTransferIds.isEmpty()) {
            jgResumeInfoService.deleteBatchByBusinessId(equipTransferIds);
        }
    }

    private void rollBackForPieLine(JgUseRegistration jgUseRegistration) {
        if(!StringUtils.isEmpty(jgUseRegistration.getProjectContraptionId())){
            // 清除使用登记证编号
            LambdaUpdateWrapper<IdxBizJgProjectContraption> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BaseEntity::getSequenceNbr, jgUseRegistration.getProjectContraptionId());
            updateWrapper.set(IdxBizJgProjectContraption::getUseRegistrationCode, null);
            idxBizJgProjectContraptionMapper.update(null, updateWrapper);
            // 删除改装置的检验信息【只有是在使用登记页面新增的才会删除，使用登记终审通过时，插入的检验信息id为使用登记的主键】
            // projectInspectionMapper.deleteById(jgUseRegistration.getSequenceNbr());
        }
    }

    private void dealHisRegEquipData(JgUseRegistration jgUseRegistration, String record) {
        // 历史有证、历史无证作废时清除信息
        if("1".equals(jgUseRegistration.getRegType()) || "2".equals(jgUseRegistration.getRegType())){
            // 删除安装信息
            this.clearConstructionInfo(record);
            // 删除维保信息
            this.clearMainInfo(record);
            // 删除检验检测信息
            this.clearInspectionInfo(record);
            // 系统生产的释放96333码为 未使用状态
            this.release96333Code(record);
        }
    }

    /**
     * 释放96333码为未使用状态
     * @param record 记录值
     */
    private void release96333Code(String record) {
        Optional.ofNullable(
                otherInfoMapper.selectOne(
                        new LambdaQueryWrapper<IdxBizJgOtherInfo>()
                                .eq(IdxBizJgOtherInfo::getRecord, record)
                                .select(IdxBizJgOtherInfo::getSupervisoryCode, IdxBizJgOtherInfo::getCode96333Type)
                )
        ).ifPresent(otherInfo -> {
            String supervisoryCode = otherInfo.getSupervisoryCode();
            // 手动输入直接删除【1-存在96333编码，用户自行删除；2-不存在96333编码，系统自动生成】
            if ("1".equals(otherInfo.getCode96333Type())) {
                supervisoryCodeInfoMapper.delete(new QueryWrapper<SupervisoryCodeInfo>().eq("SUPERVISORY_CODE", supervisoryCode));
            } else {
                supervisoryCodeInfoMapper.updateStatus(Collections.singletonList(supervisoryCode));
            }
            //系统生成的96333把other中的释放
            otherInfoMapper.update(null,
                    new LambdaUpdateWrapper<IdxBizJgOtherInfo>()
                        .eq(IdxBizJgOtherInfo::getRecord, record)
                        .set(IdxBizJgOtherInfo::getSupervisoryCode, null)
                        .set("2".equals(otherInfo.getCode96333Type()), IdxBizJgOtherInfo::getCode96333, null));
        });
    }

    private void clearInspectionInfo(String record) {
        inspectionDetectionInfoMapper.delete(new LambdaQueryWrapper<InspectionDetectionInfo>().eq(AbstractEquipBaseEntity::getRecord, record));
        InspectionDetectionInfo inspectionDetectionInfo = new InspectionDetectionInfo();
        inspectionDetectionInfo.setRecord(record);
        inspectionDetectionInfo.setRecDate(new Date());
        inspectionDetectionInfo.setSequenceNbr(sequence.nextId() + "");
        inspectionDetectionInfoMapper.insert(inspectionDetectionInfo);
    }

    private void clearMainInfo(String record) {
        maintenanceRecordInfoMapper.delete(new LambdaQueryWrapper<IdxBizJgMaintenanceRecordInfo>().eq(IdxBizJgMaintenanceRecordInfo::getRecord, record));
    }

    private void clearConstructionInfo(String record) {
        constructionInfoMapper.delete(new LambdaQueryWrapper<IdxBizJgConstructionInfo>().eq(IdxBizJgConstructionInfo::getRecord, record));
        IdxBizJgConstructionInfo jgConstructionInfo = new IdxBizJgConstructionInfo();
        jgConstructionInfo.setRecord(record);
        jgConstructionInfo.setRecDate(new Date());
        constructionInfoMapper.insert(jgConstructionInfo);
    }

    private List<JgUseRegistrationEq> getJgUseRegistrationEqs(JgUseRegistration jgUseRegistration) {
        LambdaQueryWrapper<JgUseRegistrationEq> eqLambdaQueryWrapper = new LambdaQueryWrapper<JgUseRegistrationEq>().eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
        return jgRelationEquipMapper.selectList(eqLambdaQueryWrapper);
    }

    private void rollBackForEquipEsInfo(String record, Boolean flag,JgUseRegistration jgUseRegistration) {
        LambdaQueryWrapper<IdxBizJgConstructionInfo> wrapper = new LambdaQueryWrapper<>();
        wrapper.select(IdxBizJgConstructionInfo::getUscUnitCreditCode,
                        IdxBizJgConstructionInfo::getUscUnitName,
                        IdxBizJgConstructionInfo::getInformCode,
                        IdxBizJgConstructionInfo::getInformFilePath)
                .eq(IdxBizJgConstructionInfo::getRecord, record)
                .orderByDesc(TzsBaseEntity::getRecDate)
                .last("limit 1");
        IdxBizJgConstructionInfo jgConstructionInfo = constructionInfoMapper.selectOne(wrapper);
        IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(
                new LambdaQueryWrapper<IdxBizJgOtherInfo>()
                        .eq(IdxBizJgOtherInfo::getRecord, record)
                        .select(IdxBizJgOtherInfo::getSupervisoryCode, IdxBizJgOtherInfo::getCode96333Type));
        Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(record);
        if (optional.isPresent()) {
            ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
            // 非历史有证设备,作废清除使用登记证编号
            if(!"1".equals(jgUseRegistration.getRegType())){
                esEquipmentCategoryDto.setUSE_ORG_CODE(null);
            }
            // 历史有证设备、历史无证设备，系统生成的96333清空
            if (("1".equals(jgUseRegistration.getRegType()) || "2".equals(jgUseRegistration.getRegType())) && "2".equals(otherInfo.getCode96333Type())) {
                esEquipmentCategoryDto.setCODE96333(null);
            }
            esEquipmentCategoryDto.setUSE_ORG_CODE(null);
            //esEquipmentCategoryDto.setSTATUS(null);
            esEquipmentCategoryDto.setEQU_STATE(null);
            esEquipmentCategoryDto.setORG_BRANCH_CODE(null);
            esEquipmentCategoryDto.setORG_BRANCH_NAME(null);
            if (jgConstructionInfo != null){
                esEquipmentCategoryDto.setUSC_UNIT_NAME(jgConstructionInfo.getUscUnitName());
                esEquipmentCategoryDto.setUSC_UNIT_CREDIT_CODE(jgConstructionInfo.getUscUnitCreditCode());
            }
            esEquipmentCategory.save(esEquipmentCategoryDto);
        }
    }

    /**
     * 作废使用登记证 & 生成使用登记证的流水
     *
     * @param jgUseRegistration
     */
    private void invalidUseRegistrationCertificate(JgUseRegistration jgUseRegistration) {
        Integer count = jgUseRegistrationMapper.selectCount(new LambdaQueryWrapper<JgUseRegistration>()
                .eq(JgUseRegistration::getUseRegistrationCode, jgUseRegistration.getUseRegistrationCode())
                .ne(JgUseRegistration::getStatus, "已作废")
                .eq(JgUseRegistration::getIsDelete, false));
        // 一证对应多条使用登记单时，不作废证
        if (count > 1) {
            return;
        }
        JgUseRegistrationManage registrationManage = new JgUseRegistrationManage();
        registrationManage.setCertificateStatus(CertificateStatusEnum.YIZHUXIAO.getName());
        registrationManage.setIsDelete(true);
        LambdaQueryWrapper<JgUseRegistrationManage> wrapper = new LambdaQueryWrapper<JgUseRegistrationManage>()
                .eq(JgUseRegistrationManage::getUseRegistrationCode, jgUseRegistration.getUseRegistrationCode());
        jgUseRegistrationManageMapper.update(registrationManage, wrapper);

        // 生成使用登记证的作废流水
        Optional<JgCertificateChangeRecord> firstRecord = certificateChangeRecordService.getBaseMapper().selectList(new LambdaQueryWrapper<JgCertificateChangeRecord>()
                        .eq(JgCertificateChangeRecord::getUseRegistrationCode, jgUseRegistration.getUseRegistrationCode())
                        .orderByAsc(JgCertificateChangeRecord::getCreateDate))
                .stream()
                .findFirst();

        JgCertificateChangeRecord changeRecord = new JgCertificateChangeRecord();
        changeRecord.setApplyNo(jgUseRegistration.getApplyNo());
        changeRecord.setReceiveOrgName(jgUseRegistration.getReceiveOrgName());
        changeRecord.setAuditPassDate(new Date());
        changeRecord.setRegType(BusinessTypeEnum.JG_USAGE_REGISTRATION.getName());
        changeRecord.setRegDate(jgUseRegistration.getCreateDate());
        changeRecord.setChangeContent(this.buildVoidRecordContent(jgUseRegistration));//变更内容
        changeRecord.setUseRegistrationCode(jgUseRegistration.getUseRegistrationCode());//使用登记编号
        changeRecord.setReceiveCompanyCode(jgUseRegistration.getReceiveCompanyOrgCode());//接收机构公司代码
        changeRecord.setUseUnitCreditCode(jgUseRegistration.getUseUnitCreditCode());//使用单位统一信用代码
        changeRecord.setUseUnitName(jgUseRegistration.getUseUnitName());//使用单位名称
        firstRecord.ifPresent(record -> changeRecord.setEquCategory(record.getEquCategory()));//设备类别编码
        changeRecord.setCreateDate(new Date());
        firstRecord.ifPresent(record -> changeRecord.setRoutePath(record.getRoutePath()));
        certificateChangeRecordService.save(changeRecord);
    }

    private void rollBackSupervisionInfo(String record) {
        LambdaUpdateWrapper<IdxBizJgSupervisionInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgSupervisionInfo::getRecord, record);
        updateWrapper.set(IdxBizJgSupervisionInfo::getOrgBranchName, null);
        updateWrapper.set(IdxBizJgSupervisionInfo::getOrgBranchCode, null);
        updateWrapper.set(IdxBizJgSupervisionInfo::getCompanyOrgBranchCode, null);
        idxBizJgSupervisionInfoMapper.update(null, updateWrapper);
    }

    private void rollBackRegisterInfo(String record, JgUseRegistration jgUseRegistration) {
        LambdaUpdateWrapper<IdxBizJgRegisterInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgRegisterInfo::getRecord, record);
        // 未注册，来源cb_data_dictionary type =  'ZC'
        updateWrapper.set(IdxBizJgRegisterInfo::getRegisterState, "6046");
        // 非历史有证设备 作废时清除使用登记证编号（0-新增设备；1-历史有证设备；2-历史无证设备）
        updateWrapper.set(!"1".equals(jgUseRegistration.getRegType()),IdxBizJgRegisterInfo::getUseOrgCode, null);
        updateWrapper.set(IdxBizJgRegisterInfo::getCarNumber, null);
        idxBizJgRegisterInfoService.update(updateWrapper);
    }

    private void rollBackUseInfo(String record, Boolean flag) {
        LambdaUpdateWrapper<IdxBizJgUseInfo> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgUseInfo::getRecord, record);
        updateWrapper.set(IdxBizJgUseInfo::getCity, null);
        updateWrapper.set(IdxBizJgUseInfo::getCityName, null);
        updateWrapper.set(IdxBizJgUseInfo::getCounty, null);
        updateWrapper.set(IdxBizJgUseInfo::getCountyName, null);
        updateWrapper.set(IdxBizJgUseInfo::getStreetName, null);
        updateWrapper.set(IdxBizJgUseInfo::getProvince, null);
        updateWrapper.set(IdxBizJgUseInfo::getProvinceName, null);
        updateWrapper.set(IdxBizJgUseInfo::getEquState, null);
        updateWrapper.set(IdxBizJgUseInfo::getEstateUnitCreditCode, null);
        updateWrapper.set(IdxBizJgUseInfo::getEstateUnitName, null);
        updateWrapper.set(IdxBizJgUseInfo::getUsePlace, null);
        updateWrapper.set(IdxBizJgUseInfo::getLongitudeLatitude, null);
        updateWrapper.set(IdxBizJgUseInfo::getAddress, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManageDt, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManagerId, null);
        updateWrapper.set(IdxBizJgUseInfo::getSafetyManager, null);
        updateWrapper.set(IdxBizJgUseInfo::getFactoryUseSiteStreet, null);
        useInfoMapper.update(null, updateWrapper);
    }


    private void finishedTask(JgUseRegistration jgUseRegistration) {
        HashMap<String, Object> taskMap = new HashMap<>();
        taskMap.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
        taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
        taskMap.put("relationId", jgUseRegistration.getInstanceId());
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        jgUseRegistration.setOtherAccessories(null);
        BeanUtils.copyProperties(jgUseRegistration, taskMessageDto);
        this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
        taskMap.put("model", taskMessageDto);
        commonServiceImpl.updateTaskModel(taskMap);
    }

    public void correctWrongData(List<String> applayNoList) {
        List<JgUseRegistration> jgUseRegistrationList = jgUseRegistrationMapper.selectList(new LambdaQueryWrapper<JgUseRegistration>().in(JgUseRegistration::getApplyNo, applayNoList));
        jgUseRegistrationList.forEach(jgUseRegistration -> {
            WorkflowResultDto workflowResultDto = new WorkflowResultDto();
            workflowResultDto.setNextExecutorRoleIds(jgUseRegistration.getNextExecuteIds());
            workflowResultDto.setNextTaskCode("已完成");
            workflowResultDto.setNextTaskId(jgUseRegistration.getNextTaskId());
            workflowResultDto.setNextExecutorUserIds(jgUseRegistration.getNextExecuteUserIds());
            if (jgUseRegistration.getManageType().equals("unit")) {
                this.updateUseRegUnitData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, false, null);
            } else {
                this.updateData(jgUseRegistration.getSequenceNbr(), "0", workflowResultDto, null, false, null);
            }
        });
    }

    private void setEquListForWorkSpace(JgUseRegistration jgUseRegistration, TaskMessageDto taskMessageDto) {
        LambdaQueryWrapper<JgUseRegistrationEq> jgUseRegEqWrapper = new QueryWrapper<JgUseRegistrationEq>().lambda();
        jgUseRegEqWrapper.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(jgUseRegistration.getSequenceNbr()));
        List<JgUseRegistrationEq> jgUseRegistrationEqList = jgRelationEquipMapper.selectList(jgUseRegEqWrapper);
        if (!jgUseRegistrationEqList.isEmpty()) {
            String equId = jgUseRegistrationEqList.get(0).getEquId();
            taskMessageDto.setEQU_LIST_CODE(this.getEquipListCode(equId));
        }
    }

    public IdxBizJgRegisterInfo getRegisterInfo(JgUseRegistration jgUseRegistration) {
        LambdaQueryWrapper<JgUseRegistrationEq> jgUseRegEqWrapper = new QueryWrapper<JgUseRegistrationEq>().lambda();
        jgUseRegEqWrapper.eq(JgUseRegistrationEq::getEquipTransferId, String.valueOf(jgUseRegistration.getSequenceNbr()));
        List<JgUseRegistrationEq> jgUseRegistrationEqList = jgRelationEquipMapper.selectList(jgUseRegEqWrapper);
        if (!jgUseRegistrationEqList.isEmpty()) {
            String record = jgUseRegistrationEqList.get(0).getEquId();
            return idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, record).select(TzsBaseEntity::getSequenceNbr,IdxBizJgRegisterInfo::getEquList));
        }
        return null;
    }


    /**
     * 处理历史错误单子
     *
     * @param applyNo 申请单号
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public void handleErrorForm(String applyNo) {
        LambdaQueryWrapper<JgUseRegistration> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgUseRegistration::getApplyNo, applyNo);
        queryWrapper.eq(JgUseRegistration::getIsDelete, false);
        JgUseRegistration jgUseRegistration = this.baseMapper.selectOne(queryWrapper);
        LambdaQueryWrapper<JgUseRegistrationManage> wrapper = new LambdaQueryWrapper<JgUseRegistrationManage>()
                .eq(JgUseRegistrationManage::getApplyNo, applyNo);
        jgUseRegistrationManageMapper.delete(wrapper);

        if (jgUseRegistration != null) {
            String lockKey = CommonServiceImpl.buildJgExecuteLockKey(jgUseRegistration.getInstanceId());
            RLock lock = redissonClient.getLock(lockKey);
            try {
                boolean isLocked = lock.tryLock(0, 180, TimeUnit.SECONDS);
                // 解决并发问题：多个人同时操作一个流程（并发执行通过、驳回、撤回）
                if (!isLocked) {
                    throw new BadRequest("当前流程已经被执行！请重新打开页面查看并执行！");
                }
                // 流程执行时，状态及权限校验
                ProcessTaskDTO complete = workFlowFeignService.handleErrorForm(jgUseRegistration.getInstanceId(), jgUseRegistration.getReceiveCompanyCode()).getResult();
                ArrayList<ProcessTaskDTO> processTaskDTOS = new ArrayList<>();
                processTaskDTOS.add(complete);
                List<WorkflowResultDto> resultDto = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
                if (!ObjectUtils.isEmpty(resultDto) && !ObjectUtils.isEmpty(resultDto.get(0))) {
                    WorkflowResultDto workflowResultDto = resultDto.get(0);
                    String role = workflowResultDto.getNextExecutorRoleIds();
                    String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
                    if (!ObjectUtils.isEmpty(workflowResultDto.getNextTaskCode())) {
                        taskCode = workflowResultDto.getNextTaskCode();
                    }
                    jgUseRegistration.setNextTaskId(workflowResultDto.getNextTaskId());
                    jgUseRegistration.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    jgUseRegistration.setNextExecuteIds(role);
                    jgUseRegistration.setInstanceStatus(
                            Optional.ofNullable(jgUseRegistration.getInstanceStatus())
                                    .map(status -> String.join(",", status, role))
                                    .orElse(role)
                    );
                    jgUseRegistration.setStatus(Objects.requireNonNull(WorkFlowStatusEnum.getMessage(taskCode)).getPass());
                    jgUseRegistration.setPromoter(workflowResultDto.getStartUserId());
                    // 更新代办状态
                    HashMap<String, Object> params = new HashMap<>();
                    params.put("relationId", jgUseRegistration.getInstanceId());
                    params.put("flowStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                    params.put("flowStatusLabel", jgUseRegistration.getStatus());
                    params.put("taskStatus", commonServiceImpl.getDictionaryCodeByName(jgUseRegistration.getStatus()));
                    params.put("taskStatusLabel", jgUseRegistration.getStatus());
                    TaskMessageDto taskMessageDto1 = new TaskMessageDto();
                    this.setEquListForWorkSpace(jgUseRegistration, taskMessageDto1);
                    params.put("model", taskMessageDto1);
                    TaskV2Model taskV2Model = commonServiceImpl.updateTaskModel(params);
                    // 创建新的代办
                    if (!ObjectUtils.isEmpty(taskV2Model)) {
                        TaskModelDto taskModelDto = new TaskModelDto();
                        BeanUtils.copyProperties(taskV2Model, taskModelDto);
                        TaskMessageDto taskMessageDto = new TaskMessageDto();
                        BeanUtil.copyProperties(jgUseRegistration, taskMessageDto);
                        setEquListForWorkSpace(jgUseRegistration, taskMessageDto);
                        taskModelDto.setModel(taskMessageDto);
                        taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                        taskModelDto.setStartUserId(workflowResultDto.getExecutorId());
                        taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                        taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                        taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                        taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                        commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
                    } else {
                        workflowResultDto.setInstanceId(jgUseRegistration.getInstanceId());
                        buildTask(jgUseRegistration, workflowResultDto);
                    }
                }
                jgUseRegistration.setUseRegistrationCode("");
                this.getBaseMapper().updateById(jgUseRegistration);
                commonServiceImpl.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
            } catch (InterruptedException e) {
                e.printStackTrace();
            } finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
    }

    /**
     * 按单位办理或按台套办理
     *
     * @param map map
     * @return list
     */
    @Transactional(rollbackFor = Exception.class)
    @GlobalTransactional(rollbackFor = Exception.class)
    public List<Map<String, Object>> saveHistoryEquip(JSONObject map) {
        Map<String, Function<JSONObject, List<Map<String, Object>>>> functionMap = MapBuilder.<String, Function<JSONObject, List<Map<String, Object>>>>create()
                .put("unit", this::handleUnitHistoryEquip).build();
        Function<JSONObject, List<Map<String, Object>>> function = functionMap.getOrDefault(map.getString("manageType"), this::handleHistoryEquip);
        return function.apply(map);
    }

    /**
     * 按单位新增历史设备
     *
     * @param jsonObject
     * @return
     */
    public List<Map<String, Object>> handleUnitHistoryEquip(JSONObject jsonObject) {
        return null;
        //TODO 校验使用登记证编号的唯一性
    }

    /**
     * 按台套新增历史设备
     *
     * @param map
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public List<Map<String, Object>> handleHistoryEquip(JSONObject map) {
        try {
            // 使用登记证编号
            String useRegistrationCode = String.valueOf(map.get("useOrgCode")).trim();
            String equipId = String.valueOf(map.get("equipId"));
            //校验使用登记证编号的唯一性
            Boolean used = commonServiceImpl.useRegistrationCertificateAccountUnique(useRegistrationCode, equipId);
            if (used){
                throw new BadRequest("使用登记证编号已存在！");
            }
            //使用登记证编号判断是否使用未来系统生成编号
            idxBizJgRegisterInfoService.checkUseRegistrationCode(useRegistrationCode, "set");

            // 场车设备校验车牌号的唯一性
            if (EquipmentClassifityEnum.CC.getCode().equals(map.get("EQU_LIST_CODE"))) {
                String carNum = String.valueOf(map.get(carNumber));
                if (!"无".equals(carNum)) {
                    Integer count = idxBizJgRegisterInfoMapper.checkCarNumberUniquenessWithHisCC(carNumber, equipId);
                    if (count > 0) {
                        throw new BadRequest("车牌号已存在，请重新输入！");
                    }
                }
            }

            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            // 使用登记信息
            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            jgUseRegistration.setRegDate(new Date());

            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                jgUseRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            if (map.containsKey("receiveOrgCode")) {
                // 接收单位信息
                String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
                jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
                jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);
                jgUseRegistration.setReceiveCompanyOrgCode(commonService.getOneCompany(jgUseRegistration.getReceiveCompanyCode()).getOrgCode());
            }
            if (map.containsKey("orgBranchCode")) {
                // 监察处置机构代码
                String[] splitOrgBranchCode = String.valueOf(map.getString("orgBranchCode")).split("_");
                jgUseRegistration.setSupervisionOrgCode(splitOrgBranchCode[0]);
            }
            // 安全管理员
            if (map.containsKey("safetyManager")) {
                String[] data = String.valueOf(map.getString("safetyManager")).split("_");
                map.put("safetyManagerId", data[0]);
                map.put("safetyManagerName", data[1]);
            }
            // 使用单位提交
            jgUseRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            jgUseRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            jgUseRegistration.setCreateUserName(reginParams.getUserModel().getUserName());
            if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
                jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
            }
            if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
                jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
            }
            // 是否西咸
            if (!ObjectUtils.isEmpty(map.get("isXixian"))) {
                jgUseRegistration.setIsXixian(String.valueOf(map.get("isXixian")));
            }
            // 使用地点
            String useCityName = "";
            String useCountyName = "";
            String useStreetName = "";
            // 市
            List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
            // 区
            List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
            // 街道
            List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");
            jgUseRegistration.setUseAddress("陕西省");
            // 城市
            if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
                JSONObject finalMap = map;
                AtomicReference<String> atomicUseCity = new AtomicReference<>(useCityName);
                city.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(finalMap.get("city")))) {
                        atomicUseCity.set("" + item.get("regionName"));
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
                useCityName = atomicUseCity.get();
            }
            // 区县
            if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
                JSONObject finalMap1 = map;
                AtomicReference<String> atomicUseCounty = new AtomicReference<>(useCountyName);
                region.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(finalMap1.get("county")))) {
                        atomicUseCounty.set("" + item.get("regionName"));
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
                useCountyName = atomicUseCounty.get();
            }
            // 街道
            if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
                JSONObject finalMap2 = map;
                AtomicReference<String> atomicUseStreet = new AtomicReference<>(useStreetName);
                street.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(finalMap2.get("factoryUseSiteStreet")))) {
                        atomicUseStreet.set("" + item.get("regionName"));
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
                useStreetName = atomicUseStreet.get();
            }
            jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + map.get("address"));

            if (map.containsKey("edit") && "1".equals(String.valueOf(map.get("edit")))) {
                jgUseRegistration.setUseUnitCreditCode(null);
                jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
                this.getBaseMapper().updateById(jgUseRegistration);
                // 更新设备关联表
                LambdaQueryWrapper<JgUseRegistrationEq> lambda = new QueryWrapper<JgUseRegistrationEq>().lambda();
                lambda.eq(JgUseRegistrationEq::getEquipTransferId, jgUseRegistration.getSequenceNbr());
                JgUseRegistrationEq jgUseRegistrationEq = new JgUseRegistrationEq();
                jgUseRegistrationEq.setEquId(map.get("equipId").toString());
                jgRelationEquipMapper.update(jgUseRegistrationEq, lambda);
            } else {
                // 业务管理设备信息保存
                JgUseRegistrationEq jgRelationEquip = new JgUseRegistrationEq();
                jgRelationEquip.setEquId(map.get("equipId").toString());
                ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.SYDJ.getCode(), 1);
                if (!ObjectUtils.isEmpty(listResponseModel)) {
                    jgUseRegistration.setApplyNo(listResponseModel.getResult().get(0));
                }
                jgUseRegistration.setAuditPassDate(new Date());
                jgUseRegistration.setAuditStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
                jgUseRegistration.setStatus(FlowStatusEnum.TO_BE_FINISHED.getName());
                jgUseRegistration.setUseRegistrationCode(ValidationUtil.isEmpty(map.get("useOrgCode")) ? "" : String.valueOf(map.get("useOrgCode")));
                jgUseRegistration.setRegType("1");//历史登记
                this.save(jgUseRegistration);
                jgRelationEquip.setEquipTransferId(jgUseRegistration.getSequenceNbr().toString());
                jgRelationEquipMapper.insert(jgRelationEquip);

                // 暂存历史表
                updateHistory(map, map.get("equipId").toString(), String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());

                //监督管理信息
                LambdaQueryWrapper<IdxBizJgSupervisionInfo> lambdaSup = new QueryWrapper<IdxBizJgSupervisionInfo>().lambda();
                lambdaSup.eq(IdxBizJgSupervisionInfo::getRecord, jgRelationEquip.getEquId());
                IdxBizJgSupervisionInfo supervisionInfo = idxBizJgSupervisionInfoMapper.selectOne(lambdaSup);
                supervisionInfo.setOrgBranchCode(String.valueOf(map.get("orgBranchCode")).split("_")[0]);
                supervisionInfo.setOrgBranchName(String.valueOf(map.get("orgBranchCode")).split("_")[1]);
                idxBizJgSupervisionInfoMapper.updateById(supervisionInfo);

                // 注册信息
                LambdaQueryWrapper<IdxBizJgRegisterInfo> lambdaReg = new QueryWrapper<IdxBizJgRegisterInfo>().lambda();
                lambdaReg.eq(IdxBizJgRegisterInfo::getRecord, jgRelationEquip.getEquId());
                IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoMapper.selectOne(lambdaReg);
                registerInfo.setUseOrgCode(jgUseRegistration.getUseRegistrationCode());
                registerInfo.setEquCodeType(String.valueOf(map.get("equCodeType")));
                String equCode = ObjectUtils.isEmpty(map.get("equCode")) ? this.getEquCode(registerInfo, jgUseRegistration.getReceiveCompanyCode()) : String.valueOf(map.get("equCode"));
                registerInfo.setEquCode(equCode);// 设备代码
                registerInfo.setEquPrice(String.valueOf(map.get("equPrice")));
                registerInfo.setProductPhoto(JSONObject.toJSONString(map.get("productPhoto")));
                registerInfo.setOtherAccessoriesReg(JSONObject.toJSONString(map.get("otherAccessoriesReg")));
                registerInfo.setInstallationIsComplete(map.getOrDefault("installationIsComplete", "1").toString());
                if (EquipmentClassifityEnum.CC.getCode().equals(map.get("EQU_LIST_CODE"))) {
                    registerInfo.setCarNumber((String) map.get(carNumber));
                }
                idxBizJgRegisterInfoMapper.updateById(registerInfo);

                // 设计信息
                LambdaQueryWrapper<IdxBizJgDesignInfo> lambdaDes = new QueryWrapper<IdxBizJgDesignInfo>().lambda();
                lambdaDes.eq(IdxBizJgDesignInfo::getRecord, jgRelationEquip.getEquId());
                IdxBizJgDesignInfo designInfo = idxBizJgDesignInfoService.getOne(lambdaDes);
                designInfo.setDesignUnitCreditCode(MapUtil.getStr(map,"designUnitCreditCode"));
                designInfo.setDesignUnitName(MapUtil.getStr(map,"designUnitName"));
                designInfo.setDesignLicenseNum(MapUtil.getStr(map,"designLicenseNum"));
                designInfo.setDesignUseDate(MapUtil.getStr(map, "designUseDate"));
                designInfo.setDesignDate(!StringUtils.isEmpty(map.get("designDate")) ? DateUtil.parse(String.valueOf(map.get("designDate")), "yyyy-MM-dd") : null);
                designInfo.setDrawingDo(ObjectUtils.isEmpty(map.get("drawingDo")) ? null : String.valueOf(map.get("drawingDo")));
                designInfo.setAppraisalUnit(ObjectUtils.isEmpty(map.get("appraisalUnit")) ? null : String.valueOf(map.get("appraisalUnit")));
                designInfo.setAppraisalDate(ObjectUtils.isEmpty(map.get("appraisalDate")) ? null : String.valueOf(map.get("appraisalDate")));
                designInfo.setDesignDoc(JSONObject.toJSONString(map.get("designDoc")));
                designInfo.setDesignStandard(ObjectUtils.isEmpty(map.get("designStandard")) ? null : JSONObject.toJSONString(map.get("designStandard")));
                designInfo.setOtherAccessoriesDes(ObjectUtils.isEmpty(map.get("otherAccessoriesDes")) ? null : JSONObject.toJSONString(map.get("otherAccessoriesDes")));
                idxBizJgDesignInfoMapper.updateById(designInfo);


                // 制造信息
                LambdaQueryWrapper<IdxBizJgFactoryInfo> factoryInfoWrapper = new LambdaQueryWrapper<>();
                factoryInfoWrapper.eq(IdxBizJgFactoryInfo::getRecord, jgRelationEquip.getEquId());
                IdxBizJgFactoryInfo idxBizJgFactoryInfo = idxBizJgFactoryInfoService.getOne(factoryInfoWrapper);
                idxBizJgFactoryInfo.setProduceUnitCreditCode(MapUtil.getStr(map, "produceUnitCreditCode"));
                idxBizJgFactoryInfo.setProduceUnitName(MapUtil.getStr(map, "produceUnitName"));
                idxBizJgFactoryInfo.setFactoryNum(MapUtil.getStr(map, "factoryNum"));
                idxBizJgFactoryInfo.setProduceLicenseNum(MapUtil.getStr(map, "produceLicenseNum"));
                idxBizJgFactoryInfo.setProduceDate(!StringUtils.isEmpty(map.get("produceDate")) ? DateUtil.parse(String.valueOf(map.get("produceDate")), "yyyy-MM-dd") : null);
                idxBizJgFactoryInfo.setImported(ObjectUtils.isEmpty(map.get("imported")) ? null : String.valueOf(map.get("imported")));
                idxBizJgFactoryInfo.setProduceCountry(ObjectUtils.isEmpty(map.get("produceCountry")) ? null : String.valueOf(map.get("produceCountry")));
                idxBizJgFactoryInfo.setOtherAccessoriesFact(ObjectUtils.isEmpty(map.get("otherAccessoriesFact")) ? null : JSONObject.toJSONString(map.get("otherAccessoriesFact")));
                idxBizJgFactoryInfo.setProductQualityYieldProve(JSONObject.toJSONString(map.get("productQualityYieldProve")));
                idxBizJgFactoryInfo.setInsUseMaintainExplain(ObjectUtils.isEmpty(map.get("insUseMaintainExplain")) ? null : JSONObject.toJSONString(map.get("insUseMaintainExplain")));
                idxBizJgFactoryInfo.setFactoryStandard(ObjectUtils.isEmpty(map.get("factoryStandard")) ? null : JSONObject.toJSONString(map.get("factoryStandard")));
                idxBizJgFactoryInfo.setFactSupervisionInspectionReport(ObjectUtils.isEmpty(map.get("factSupervisionInspectionReport")) ? null : JSONObject.toJSONString(map.get("factSupervisionInspectionReport")));
                idxBizJgFactoryInfo.setBoilerEnergyEfficiencyCertificate(ObjectUtils.isEmpty(map.get("boilerEnergyEfficiencyCertificate")) ? null : JSONObject.toJSONString(map.get("boilerEnergyEfficiencyCertificate")));
                idxBizJgFactoryInfoMapper.updateById(idxBizJgFactoryInfo);

                // 使用信息
                LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
                lambda.eq(IdxBizJgUseInfo::getRecord, String.valueOf(map.get("equipId")));
                IdxBizJgUseInfo useInfo = useInfoMapper.selectOne(lambda);
                useInfo.setIsIntoManagement(Boolean.TRUE);
                useInfo.setUseUnitCreditCode(String.valueOf(map.get("useUnitCreditCode")));
                useInfo.setUseUnitName(String.valueOf(map.get("useUnitName")));
                useInfo.setProvince("610000");
                useInfo.setProvinceName("陕西省");
                useInfo.setCity(String.valueOf(map.get("city")));
                useInfo.setCityName(useCityName);
                useInfo.setCounty(String.valueOf(map.get("county")));
                useInfo.setCountyName(useCountyName);
                useInfo.setFactoryUseSiteStreet(String.valueOf(map.get("factoryUseSiteStreet")));
                useInfo.setStreetName(useStreetName);
                useInfo.setAddress(String.valueOf(map.get("address")));
                useInfo.setIsNotXiXian(String.valueOf(map.get("isXixian")));
                useInfo.setEstateUnitCreditCode(String.valueOf(map.get("estateUnitName")).split("_")[0]);
                useInfo.setEstateUnitName(String.valueOf(map.get("estateUnitName")).split("_")[1]);
                useInfo.setPhone(String.valueOf(map.get("phone")));
                useInfo.setSafetyManager(String.valueOf(map.get("safetyManager")).split("_")[1]);
                useInfo.setUseDate(String.valueOf(map.get("useDate")));
                useInfo.setLongitudeLatitude(JSON.toJSONString(map.get("longitudeLatitude")));
                useInfo.setUsePlace((String) map.get("usePlace"));
                useInfo.setOldUseRegistrationTable(JSON.toJSONString(map.get("oldUseRegistrationTable")));
                useInfo.setOldUseRegistrationCertificate(JSON.toJSONString(map.get("oldUseRegistrationCertificate")));
                useInfo.setORegDate(String.valueOf(map.get("oRegDate")));
                useInfo.setORegUnit(String.valueOf(map.get("oRegUnit")));
                // 历史平台登记，将设备状态改为在用
                useInfo.setEquState(EquimentEnum.ZAIYONG.getCode().toString());
                String usePlace = useInfo.getProvinceName() + "/" + useInfo.getCityName() + "/" + useInfo.getCountyName() + "/" + useInfo.getStreetName();
                useInfoMapper.updateById(useInfo);

                LambdaQueryWrapper<IdxBizJgOtherInfo> otherLambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
                otherLambda.eq(IdxBizJgOtherInfo::getRecord, map.get("equipId"));
                IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);

                // 检验检测【一对多，暂时只取最新一条数据】
                IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = iIdxBizJgInspectionDetectionInfoService.queryNewestDetailByRecord(String.valueOf(map.get("equipId")));
                if (ObjectUtils.isEmpty(inspectionDetectionInfo.getSequenceNbr())) {
                    inspectionDetectionInfo.setRecord((String) map.get("equipId"));
                }
                inspectionDetectionInfo.setInspectOrgCode(MapUtil.getStr(map, "inspectOrgCode"));
                inspectionDetectionInfo.setInspectOrgName(MapUtil.getStr(map, "inspectOrgName"));
                inspectionDetectionInfo.setInspectConclusion(MapUtil.getStr(map,"inspectConclusion"));
                inspectionDetectionInfo.setInspectType(MapUtil.getStr(map, "inspectType"));
                inspectionDetectionInfo.setInspectDate(!StringUtils.isEmpty(map.get("inspectDate")) ? DateUtil.parse(String.valueOf(map.get("inspectDate")), "yyyy-MM-dd") : null);
                inspectionDetectionInfo.setInspectStaff(MapUtil.getStr(map, "inspectStaff"));
                inspectionDetectionInfo.setNextInspectDate(!StringUtils.isEmpty(map.get("nextInspectDate")) ? DateUtil.parse(String.valueOf(map.get("nextInspectDate")), "yyyy-MM-dd") : null);
                inspectionDetectionInfo.setInspectReport(JSONObject.toJSONString(map.get("inspectReport")));
                inspectionDetectionInfo.setInspectReportNo(String.valueOf(map.get("inspectReportNo")));
                iIdxBizJgInspectionDetectionInfoService.saveOrUpdateData(inspectionDetectionInfo);

                // 生成监管码 96333码
                this.createCode(map, jgUseRegistration, registerInfo, useInfo, otherInfo);
                map.put("equCode", equCode);
                // 更新es
                this.updateEsData2(usePlace, map, otherInfo,useInfo, jgUseRegistration, map);
                this.updateById(jgUseRegistration);

                // 设备安装信息更新
                this.historyEquUpdateInstallInfo(map);

                // 设备维保信息更新,只有电梯
                if ("3000".equals(map.get("equList")) || "3000".equals(map.get("equListCode"))){
                    this.historyEquUpdateMaintenanceInfo(map);
                }

                // 历史设备 生成证书管理表记录 & 生成安装 维保等操作记录
                this.historyEquGenManageRelated(map, jgUseRegistration, registerInfo, idxBizJgFactoryInfo);

                jgResumeInfoService.createWithModel(JgResumeInfoDto.builder()
                        .applyNo(jgUseRegistration.getApplyNo())
                        .businessType(BusinessTypeEnum.JG_HISTORY_USAGE_REGISTRATION.getName())
                        .businessId(jgUseRegistration.getSequenceNbr() + "")
                        .equId(String.valueOf(map.get("equipId")))
                        .approvalUnit(jgUseRegistration.getReceiveOrgName())
                        .approvalUnitCode(jgUseRegistration.getReceiveOrgCode())
                        .status("正常")
                        .build());
            }
            return this.baseMapper.getDetailById(jgUseRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    /**
     * 历史设备登记-》更新维保信息
     */
    private void historyEquUpdateMaintenanceInfo(JSONObject map) {
        IdxBizJgMaintenanceRecordInfo info = new IdxBizJgMaintenanceRecordInfo();
        info.setRecord(String.valueOf(map.get("equipId")));
        String meUnitName = String.valueOf(map.get("meUnitName"));
        info.setRecDate(new Date());
        info.setRecUserId(RequestContext.getExeUserId());
        info.setMeUnitName(!ValidationUtil.isEmpty(meUnitName) && meUnitName.contains("_") ? meUnitName.split("_")[1] : null);
        info.setMeUnitCreditCode(!ValidationUtil.isEmpty(meUnitName) && meUnitName.contains("_") ? meUnitName.split("_")[0] : null);
        info.setMeMaster(ValidationUtil.isEmpty(map.get("maintenanceManagerOneName")) ? null : String.valueOf(map.get("maintenanceManagerOneName")));
        info.setMeMasterPhone(ValidationUtil.isEmpty(map.get("maintenanceManagerOnePhone")) ? null : String.valueOf(map.get("maintenanceManagerOnePhone")));
        info.setMeMasterId(ValidationUtil.isEmpty(map.get("maintenanceManagerOneID")) ? null : String.valueOf(map.get("maintenanceManagerOneID")));
        info.setMeMaster1(ValidationUtil.isEmpty(map.get("maintenanceManagerTwoName")) ? null : String.valueOf(map.get("maintenanceManagerTwoName")));
        info.setMeMaster1Phone(ValidationUtil.isEmpty(map.get("maintenanceManagerTwoPhone")) ? null : String.valueOf(map.get("maintenanceManagerTwoPhone")));
        info.setMeMaster1Id(ValidationUtil.isEmpty(map.get("maintenanceManagerTwoID")) ? null : String.valueOf(map.get("maintenanceManagerTwoID")));
        try {
            info.setInformStart(ValidationUtil.isEmpty(map.get("informStart")) ? null : DateUtil.parse(String.valueOf(map.get("informStart"))));
            info.setInformEnd(ValidationUtil.isEmpty(map.get("informEnd")) ? null : DateUtil.parse(String.valueOf(map.get("informEnd"))));
        } catch (Exception exception) {
            exception.printStackTrace();
            log.info("date转化失败");
        }
        info.setRepairInform(ValidationUtil.isEmpty(map.get("maintenanceContract")) ? null : JSONObject.toJSONString(map.get("maintenanceContract")));
        idxBizJgMaintenanceRecordInfoService.save(info);
    }

    /**
     * 历史设备登记-》更新安装信息
     */
    private void historyEquUpdateInstallInfo(JSONObject map) {

        IdxBizJgConstructionInfo constructionInfo = idxBizJgConstructionInfoService.queryNewestDetailByRecord(String.valueOf(map.get("equipId")));
        if (!ValidationUtil.isEmpty(constructionInfo.getSequenceNbr())) {
            constructionInfo.setUscUnitName(ValidationUtil.isEmpty(map.get("uscUnitName")) ? null : String.valueOf(map.get("uscUnitName")));
            constructionInfo.setConstructionLeaderName(ValidationUtil.isEmpty(map.get("installLeaderId")) ? null : String.valueOf(map.get("installLeaderId")));
            constructionInfo.setConstructionLeaderPhone(ValidationUtil.isEmpty(map.get("installLeaderPhone")) ? null : String.valueOf(map.get("installLeaderPhone")));
            constructionInfo.setProxyStatementAttachment(ValidationUtil.isEmpty(map.get("proxyStatementAttachmentList")) ? null : JSONObject.toJSONString(map.get("proxyStatementAttachmentList")));
            constructionInfo.setConstructionContractAttachment(ValidationUtil.isEmpty(map.get("installContractAttachment")) ? null : JSONObject.toJSONString(map.get("installContractAttachment")));
            constructionInfo.setConstructionOtherAccessories(ValidationUtil.isEmpty(map.get("insOtherAccessories")) ? null : JSONObject.toJSONString(map.get("insOtherAccessories")));
            try {
                constructionInfo.setUscDate(ValidationUtil.isEmpty(map.get("installStartDate")) ? null : DateUtils.dateParse((String) map.get("installStartDate"),DateUtils.DATE_PATTERN));
            } catch (ParseException e) {
                log.error(e.getMessage(),e);
                throw new BadRequest("安装日期时间转化错误");
            }
            idxBizJgConstructionInfoService.getBaseMapper().updateById(constructionInfo);
        }
    }

    private void historyEquGenManageRelated(JSONObject map, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo registerInfo, IdxBizJgFactoryInfo idxBizJgFactoryInfo) {

        // 生成证书管理表记录
        generateRegistrationManage(jgUseRegistration, registerInfo, Boolean.FALSE, null);


        // 使用登记证变更记录 -> 使用登记记录
        long jgUseRegSeq = sequence.nextId();
        generateCertificateChangeRecord(jgUseRegistration, registerInfo, jgUseRegSeq, new TaskV2Model(), Boolean.FALSE);
        // 使用登记证变更记录 -> 使用登记记录 ——> 生成tzs_jg_certificate_change_record_eq记录
        JgCertificateChangeRecordEq changeRecordEq = new JgCertificateChangeRecordEq();
        changeRecordEq.setChangeRecordId(String.valueOf(jgUseRegSeq));//登记证记录主键
        changeRecordEq.setEquId(registerInfo.getRecord());//设备主键
        changeRecordEq.setProductCode(idxBizJgFactoryInfo.getFactoryNum());
        certificateChangeRecordEqService.save(changeRecordEq);

        // 使用登记证变更记录 -> 安装告知记录
        if (!ValidationUtil.isEmpty(map.get("uscUnitCodeAndName"))) {
            long jgInstallSeq = sequence.nextId();//登记证记录主键
            String useRegistrationCode = jgUseRegistration.getUseRegistrationCode();// 使用登记证编号
            genJgCertChangeRecordForInstall(jgInstallSeq, useRegistrationCode, map, jgUseRegistration, registerInfo);
            // 使用登记证变更记录 -> 安装告知记录 ——> 生成tzs_jg_certificate_change_record_eq记录
            JgCertificateChangeRecordEq changeRecordEq1 = new JgCertificateChangeRecordEq();
            changeRecordEq1.setChangeRecordId(String.valueOf(jgInstallSeq));
            changeRecordEq1.setEquId(registerInfo.getRecord());//设备主键
            changeRecordEq1.setProductCode(idxBizJgFactoryInfo.getFactoryNum());
            certificateChangeRecordEqService.save(changeRecordEq1);
        }

        // 使用登记证变更记录 -> 维保备案记录,历史登记不写维保记录日志，测试说的
        /*if (!ValidationUtil.isEmpty(map.get("meUnitName"))) {
            long jgMaintenanceSeq = sequence.nextId();//登记证记录主键
            String useRegistrationCode = jgUseRegistration.getUseRegistrationCode();// 使用登记证编号
            genJgCertChangeRecordForMaintenance(jgMaintenanceSeq, useRegistrationCode, map, jgUseRegistration, registerInfo);
            // 使用登记证变更记录 -> 维保备案记录 ——> 生成tzs_jg_certificate_change_record_eq记录
            JgCertificateChangeRecordEq changeRecordEq2 = new JgCertificateChangeRecordEq();
            changeRecordEq2.setChangeRecordId(String.valueOf(jgMaintenanceSeq));
            changeRecordEq2.setEquId(registerInfo.getRecord());//设备主键
            changeRecordEq2.setProductCode(idxBizJgFactoryInfo.getFactoryNum());
            certificateChangeRecordEqService.save(changeRecordEq2);
        }*/
    }

    public void genJgCertChangeRecordForInstall(Long sequenceNbr, String registrationCode, JSONObject map, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo idxBizJgRegisterInfo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String changeContent = "";
        // 生成一条tzs_jg_certificate_change_record记录
        JgCertificateChangeRecord jgCertificateChangeRecord = new JgCertificateChangeRecord();
        jgCertificateChangeRecord.setApplyNo("");
        try {

            FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.queryByUserId(jgUseRegistration.getCreateUserId());
            changeContent = jgUseRegistration.getUseUnitName()+"的"+agencyUserModelFeignClientResult.getResult().getRealName() + "办理了【" + BusinessTypeEnum.JG_INSTALLATION_NOTIFICATION.getName() + "】，" +
                    "办理日期" + map.get("installStartDate");
            jgCertificateChangeRecord.setAuditPassDate(simpleDateFormat.parse((String) map.get("installStartDate")));
            jgCertificateChangeRecord.setRegDate(simpleDateFormat.parse((String) map.get("installStartDate")));
        } catch (Exception e) {
            e.printStackTrace();
            log.info("date转化错误");
        }
        jgCertificateChangeRecord.setRegType(BusinessTypeEnum.JG_INSTALLATION_NOTIFICATION.getName());
        jgCertificateChangeRecord.setChangeContent(changeContent);//变更内容
        jgCertificateChangeRecord.setUseRegistrationCode(registrationCode);//使用登记编号
        jgCertificateChangeRecord.setReceiveOrgName(String.valueOf(map.get("receiveOrgCode")).split("_")[1]);
        jgCertificateChangeRecord.setReceiveCompanyCode(String.valueOf(map.get("receiveOrgCode")).split("_")[0]);//接收机构公司代码
        jgCertificateChangeRecord.setCertificateNo("");//登记证书唯一码
        jgCertificateChangeRecord.setUseUnitCreditCode(String.valueOf(map.get("useUnitCreditCode")));//使用单位统一信用代码
        jgCertificateChangeRecord.setUseUnitName(String.valueOf(map.get("useUnitName")));//使用单位名称
        jgCertificateChangeRecord.setEquCategory(idxBizJgRegisterInfo.getEquCategory());//设备类别编码
        jgCertificateChangeRecord.setCreateDate(new Date());
        jgCertificateChangeRecord.setRoutePath("");
        jgCertificateChangeRecord.setCreateUserId(RequestContext.getExeUserId());
        jgCertificateChangeRecord.setSequenceNbr(sequenceNbr);
        certificateChangeRecordService.save(jgCertificateChangeRecord);
    }

    public void genJgCertChangeRecordForMaintenance(Long sequenceNbr, String registrationCode, JSONObject map, JgUseRegistration jgUseRegistration, IdxBizJgRegisterInfo idxBizJgRegisterInfo) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String changeContent = "";
        // 生成一条tzs_jg_certificate_change_record记录
        JgCertificateChangeRecord jgCertificateChangeRecord = new JgCertificateChangeRecord();
        jgCertificateChangeRecord.setApplyNo("");
        try {

            FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.queryByUserId(jgUseRegistration.getCreateUserId());
            changeContent = jgUseRegistration.getUseUnitName() + "的" +
                    agencyUserModelFeignClientResult.getResult().getRealName() + "办理了【" +
                    BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName() + "】，办理日期：" +
                    Objects.toString(map.get("installStartDate"), "");
            jgCertificateChangeRecord.setAuditPassDate(simpleDateFormat.parse((String) map.get("informEnd")));
            jgCertificateChangeRecord.setRegDate(simpleDateFormat.parse((String) map.get("informStart")));
        } catch (Exception e) {
            e.printStackTrace();
            log.info("date转化错误");
        }
        jgCertificateChangeRecord.setRegType(BusinessTypeEnum.JG_MAINTENANCE_RECORD.getName());
        jgCertificateChangeRecord.setChangeContent(changeContent);//变更内容
        jgCertificateChangeRecord.setUseRegistrationCode(registrationCode);//使用登记编号
        jgCertificateChangeRecord.setReceiveOrgName(String.valueOf(map.get("receiveOrgCode")).split("_")[1]);
        jgCertificateChangeRecord.setReceiveCompanyCode(String.valueOf(map.get("receiveOrgCode")).split("_")[0]);//接收机构公司代码
        jgCertificateChangeRecord.setCertificateNo("");//登记证书唯一码
        jgCertificateChangeRecord.setUseUnitCreditCode(String.valueOf(map.get("useUnitCreditCode")));//使用单位统一信用代码
        jgCertificateChangeRecord.setUseUnitName(String.valueOf(map.get("useUnitName")));//使用单位名称
        jgCertificateChangeRecord.setEquCategory(idxBizJgRegisterInfo.getEquCategory());//设备类别编码
        jgCertificateChangeRecord.setCreateDate(new Date());
        jgCertificateChangeRecord.setRoutePath("");
        jgCertificateChangeRecord.setCreateUserId(RequestContext.getExeUserId());
        jgCertificateChangeRecord.setSequenceNbr(sequenceNbr);
        certificateChangeRecordService.save(jgCertificateChangeRecord);
    }

    public Object queryByRegistrationCode(HashMap<String, Object> map) {
        LambdaQueryWrapper<JgUseRegistration> queryWrapper = new LambdaQueryWrapper<JgUseRegistration>()
                .eq(JgUseRegistration::getIsDelete, false)
                .eq(JgUseRegistration::getUseRegistrationCode, map.get("useRegistrationCode"))
                .eq(JgUseRegistration::getUseUnitCreditCode, map.get("useUnitCreditCode"))
                .eq(JgUseRegistration::getIsAddEquip, "0")
                .ne(JgUseRegistration::getStatus, "已作废");
        return this.baseMapper.selectOne(queryWrapper);
    }


    public Map<String, Object> getUnitInfo(ReginParams selectedOrgInfo) {
        HashMap<String, Object> map = new HashMap<>();
        String companyType = selectedOrgInfo.getCompany().getCompanyType();
        QueryWrapper queryWrapper = new QueryWrapper<TzBaseEnterpriseInfo>();
        queryWrapper.eq("use_code", selectedOrgInfo.getCompany().getCompanyCode());
        TzBaseEnterpriseInfo tzBaseEnterpriseInfo = tzBaseEnterpriseInfoMapper.selectOne(queryWrapper);
        if ("个人主体".equals(companyType)) {
            String[] code = selectedOrgInfo.getCompany().getCompanyCode().split("_");
            map.put("useUnitCreditCode", code.length > 1 ? code[1] : code[0]);
            String[] companyName = selectedOrgInfo.getCompany().getCompanyName().split("_");
            map.put("useUnitName", ObjectUtils.isEmpty(tzBaseEnterpriseInfo) ? companyName.length > 1 ? companyName[1] : companyName[0] : tzBaseEnterpriseInfo.getUseUnit());
        } else {
            map.put("useUnitCreditCode", selectedOrgInfo.getCompany().getCompanyCode());
            map.put("useUnitName", ObjectUtils.isEmpty(tzBaseEnterpriseInfo) ? selectedOrgInfo.getCompany().getCompanyName() : tzBaseEnterpriseInfo.getUseUnit());
        }
        return map;
    }

    /**
     * 历史登记设备编辑接口
     * @param map 入参
     * @return
     */
    public List<Map<String, Object>> updateHistoryBySet(JSONObject map) {
        try {
            ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
            CompanyBo company = reginParams.getCompany();
            String record = String.valueOf(map.get("equipId"));
            // 使用登记信息
            JgUseRegistration jgUseRegistration = new JgUseRegistration();
            jgUseRegistration.setRegDate(new Date());
            jgUseRegistration.setCreateDate(new Date());
            LambdaQueryWrapper<IdxBizJgOtherInfo> otherLambda = new QueryWrapper<IdxBizJgOtherInfo>().lambda();
            otherLambda.eq(IdxBizJgOtherInfo::getRecord, record);
            IdxBizJgOtherInfo otherInfo = otherInfoMapper.selectOne(otherLambda);
            String supervisoryCode = otherInfo.getSupervisoryCode();
            jgUseRegistration.setSupervisoryCode(supervisoryCode);
            // 其他附件
            if (!ObjectUtils.isEmpty(map.get("otherAccessories"))) {
                jgUseRegistration.setOtherAccessories(JSONObject.toJSONString(map.get("otherAccessories")));
            }
            if (map.containsKey("receiveOrgCode")) {
                // 接收单位信息
                String[] splitMaintenanceUnitCode = String.valueOf(map.getString("receiveOrgCode")).split("_");
                jgUseRegistration.setReceiveCompanyCode(splitMaintenanceUnitCode[0]);
                jgUseRegistration.setReceiveOrgName(splitMaintenanceUnitCode[1]);
                jgUseRegistration.setReceiveCompanyOrgCode(commonService.getOneCompany(jgUseRegistration.getReceiveCompanyCode()).getOrgCode());
            }
            if (map.containsKey("orgBranchCode")) {
                // 监察处置机构代码
                String[] splitOrgBranchCode = String.valueOf(map.getString("orgBranchCode")).split("_");
                jgUseRegistration.setSupervisionOrgCode(splitOrgBranchCode[0]);
            }
            // 安全管理员
            if (map.containsKey("safetyManager")) {
                String[] data = String.valueOf(map.getString("safetyManager")).split("_");
                map.put("safetyManagerId", data[0]);
                map.put("safetyManagerName", data[1]);
            }
            // 使用单位提交
            jgUseRegistration.setUseUnitName(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyName().split("_")[1] : company.getCompanyName());
            jgUseRegistration.setUseUnitCreditCode(CompanyTypeEnum.INDIVIDUAL.getName().equals(company.getCompanyType()) ?
                    company.getCompanyCode().split("_")[1] : company.getCompanyCode());
            jgUseRegistration.setCreateUserId(reginParams.getUserModel().getUserId());
            jgUseRegistration.setCreateUserName(reginParams.getUserModel().getUserName());
            if (!ObjectUtils.isEmpty(map.get("inspectUnitCreditCode"))) {
                jgUseRegistration.setInspectUnitCreditCode(map.get("inspectUnitCreditCode").toString());
            }
            if (!ObjectUtils.isEmpty(map.get("inspectOrgName"))) {
                jgUseRegistration.setInspectUnitName(map.get("inspectOrgName").toString());
            }
            // 是否西咸
            if (!ObjectUtils.isEmpty(map.get("isXixian"))) {
                jgUseRegistration.setIsXixian(String.valueOf(map.get("isXixian")));
            }
            // 使用地点
            // 市
            List<LinkedHashMap> city = (List<LinkedHashMap>) redisUtils.get("CITY");
            // 区
            List<LinkedHashMap> region = (List<LinkedHashMap>) redisUtils.get("REGION");
            // 街道
            List<LinkedHashMap> street = (List<LinkedHashMap>) redisUtils.get("STREET");
            jgUseRegistration.setUseAddress("陕西省");
            // 城市
            if (!ObjectUtils.isEmpty(map.get("city")) && !ObjectUtils.isEmpty(city)) {
                city.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("city")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 区县
            if (!ObjectUtils.isEmpty(map.get("county")) && !ObjectUtils.isEmpty(city)) {
                region.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("county")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            // 街道
            if (!ObjectUtils.isEmpty(map.get("factoryUseSiteStreet")) && !ObjectUtils.isEmpty(city)) {
                street.forEach(item -> {
                    if (String.valueOf(item.get("regionCode")).equals(String.valueOf(map.get("factoryUseSiteStreet")))) {
                        jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + item.get("regionName"));
                    }
                });
            }
            jgUseRegistration.setUseAddress(jgUseRegistration.getUseAddress() + map.get("address"));
            jgUseRegistration.setAuditPassDate(new Date());
            jgUseRegistration.setSequenceNbr(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            this.getBaseMapper().updateById(jgUseRegistration);
            // 历史设备登记生成的 编辑时更新使用登记证管理表
            updateRegistrationManage(Long.valueOf(String.valueOf(map.get("sequenceNbr"))));
            // 更新使用信息表中的附件信息
            LambdaQueryWrapper<IdxBizJgUseInfo> lambda = new QueryWrapper<IdxBizJgUseInfo>().lambda();
            lambda.eq(IdxBizJgUseInfo::getRecord, record);
            IdxBizJgUseInfo useInfo = new IdxBizJgUseInfo();
            useInfo.setOldUseRegistrationTable(JSON.toJSONString(map.get("oldUseRegistrationTable")));
            useInfo.setOldUseRegistrationCertificate(JSON.toJSONString(map.get("oldUseRegistrationCertificate")));
            useInfo.setORegDate(String.valueOf(map.get("oRegDate")));
            useInfo.setORegUnit(String.valueOf(map.get("oRegUnit")));
            useInfoMapper.update(useInfo, lambda);

            // 更新检验检测信息【一对多，暂时只取最新一条数据】
            IdxBizJgInspectionDetectionInfo inspectionDetectionInfo = iIdxBizJgInspectionDetectionInfoService.queryNewestDetailByRecord(record);
            if (ObjectUtils.isEmpty(inspectionDetectionInfo.getSequenceNbr())) {
                inspectionDetectionInfo.setRecord((String) map.get("equipId"));
            }
            inspectionDetectionInfo.setInspectOrgCode(String.valueOf(map.get("inspectOrgCode")));
            inspectionDetectionInfo.setInspectOrgName(String.valueOf(map.get("inspectOrgName")));
            inspectionDetectionInfo.setInspectConclusion(String.valueOf(map.get("inspectConclusion")));
            inspectionDetectionInfo.setInspectType(String.valueOf(map.get("inspectType")));
            inspectionDetectionInfo.setInspectDate(!StringUtils.isEmpty(map.get("inspectDate")) ? DateUtil.parse(String.valueOf(map.get("inspectDate")), "yyyy-MM-dd") : null);
            inspectionDetectionInfo.setInspectStaff(String.valueOf(map.get("inspectStaff")));
            inspectionDetectionInfo.setNextInspectDate(!StringUtils.isEmpty(map.get("nextInspectDate")) ? DateUtil.parse(String.valueOf(map.get("nextInspectDate")), "yyyy-MM-dd") : null);
            inspectionDetectionInfo.setInspectReport(JSONObject.toJSONString(map.get("inspectReport")));
            inspectionDetectionInfo.setInspectReportNo(String.valueOf(map.get("inspectReportNo")));
            iIdxBizJgInspectionDetectionInfoService.saveOrUpdateData(inspectionDetectionInfo);
            // 暂存历史表
            updateHistory(map, record, String.valueOf(jgUseRegistration.getSequenceNbr()), jgUseRegistration.getSupervisoryCode());
            return this.baseMapper.getDetailById(jgUseRegistration.getSequenceNbr());
        } catch (BadRequest | LocalBadRequest e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw e;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            this.rollBackForDelRedisData();
            throw new BadRequest("保存失败！");
        } finally {
            FlowingEquipRedisContext.clean();
        }
    }

    @Transactional
    public Object updateCylinderCategoryByEquCodeBatch(String cylinderCategory, List<String> equCodeList) {
        if (idxBizJgRegisterInfoMapper.updateCylinderCategoryByEquCodeBatch(cylinderCategory, equCodeList)){
            return this.baseMapper.updateByEquCodeList(cylinderCategory, equCodeList);
        }
        return true;
    }

    @Override
    public boolean beforeCheck(JgUseRegistration jgUseRegistration) {
        return jgUseRegistration.getInstanceId() != null && !jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_FINISHED.getName()) && !jgUseRegistration.getStatus().equals(FlowStatusEnum.TO_BE_DISCARD.getName());
    }

    @Override
    public void compensate(JgUseRegistration jgUseRegistration) {
        commonService.saveExecuteFlowData2Redis(jgUseRegistration.getInstanceId(), this.buildInstanceRuntimeData(jgUseRegistration));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public IPage<IdxBizJgProjectContraption> getJgProjectContraptionPage(String useUnitCreditCode, String dataSource, Page<IdxBizJgProjectContraption> page) {
        // 兼容个人业务
        if(useUnitCreditCode.contains("_")){
            useUnitCreditCode = useUnitCreditCode.split("_")[1];
        }
        // 查询流程中的装置
        List<JgUseRegistration> flowIngPros = this.list(new LambdaQueryWrapper<JgUseRegistration>().notIn(JgUseRegistration::getStatus, NOT_FLOWING_STATE).select(BaseEntity::getSequenceNbr, JgUseRegistration::getProjectContraptionId));
        Set<String> proIds = flowIngPros.stream().map(JgUseRegistration::getProjectContraptionId).collect(toSet());
        proIds.remove(null);
        proIds.remove("");
        // 查询已纳管且使用登记证编号不为空且非流程中的装置
        LambdaQueryWrapper<IdxBizJgProjectContraption> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizJgProjectContraption::getUseUnitCreditCode,useUnitCreditCode);
        if (Optional.ofNullable(dataSource).map(ds -> ds.contains("black")).orElse(false)) {
            wrapper.eq(IdxBizJgProjectContraption::getDataSource, dataSource);
        } else {
            wrapper.eq(IdxBizJgProjectContraption::getIsIntoManagement, true);
        }
        wrapper.eq(IdxBizJgProjectContraption::getEquCategory, "8300");
        wrapper.eq(IdxBizJgProjectContraption::getIsFirstMerge, false);
        wrapper.notIn(!proIds.isEmpty(), BaseEntity::getSequenceNbr, proIds);
        wrapper.isNull(IdxBizJgProjectContraption::getProjectContraptionParentId);
        wrapper.last("and (length(use_registration_code) = 0 or use_registration_code is null) order by rec_date desc");
        return jgProjectContraptionService.page(page, wrapper);
    }

    public List<IdxBizJgProjectContraption> jgProjectContraptionListMaster(String useUnitCreditCode) {
        // 兼容个人业务
        if(useUnitCreditCode.contains("_")){
            useUnitCreditCode = useUnitCreditCode.split("_")[1];
        }
        // 查询流程中的装置
        List<JgUseRegistration> flowIngPros = this.list(
                new LambdaQueryWrapper<JgUseRegistration>()
                        .notIn(JgUseRegistration::getStatus, NOT_FLOWING_STATE_FINISH)
                        .select(BaseEntity::getSequenceNbr, JgUseRegistration::getProjectContraptionId)
        );
        Set<String> proIds = flowIngPros.stream()
                .map(JgUseRegistration::getProjectContraptionId)
                .filter(id -> id != null && !id.isEmpty())
                .collect(toSet());
        LambdaQueryWrapper<IdxBizJgProjectContraption> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(IdxBizJgProjectContraption::getUseUnitCreditCode, useUnitCreditCode)
                .notIn(!proIds.isEmpty(), BaseEntity::getSequenceNbr, proIds)
                .and(w -> w.isNotNull(IdxBizJgProjectContraption::getUseRegistrationCode)
                        .or().eq(IdxBizJgProjectContraption::getIsFirstMerge, true));
        return jgProjectContraptionService.list(wrapper);
    }

    public Map<String, Object> getDeviceListByProjectContraption(String projectContraptionSeq, String[] originProjectContraptionIds) {
        // 获取工程信息
        IdxBizJgProjectContraption projectContraption = jgProjectContraptionService.getById(projectContraptionSeq);
        // 查询设备列表
        List<String> uniqueContraptionList = Stream.concat(Arrays.stream(originProjectContraptionIds), Stream.of(projectContraptionSeq))
                .distinct()
                .collect(Collectors.toList());
        List<Map<String, Object>> equList = this.getBaseMapper()
                .selectPieLineListByOfCanReg(uniqueContraptionList);
        // 检验报告数据格式化 转json
        equList.stream().filter(e-> e.get("inspectReport") != null).forEach(item->{
            item.put("inspectReport", JSON.parse(item.get("inspectReport").toString()));
        });
        // 根据设备判断工程装置安装位置是否西咸
        String isXixian = Optional.ofNullable(equList.get(0))
                .map(equ -> equ.get("record"))
                .map(String::valueOf)
                .flatMap(recordStr -> Optional.ofNullable(idxBizJgUseInfoService.getOneData(recordStr)))
                .flatMap(data -> Optional.ofNullable(data.getIsNotXiXian()))
                .map(String::valueOf)
                .orElse("0");
        // 计算管道长度总和
        double totalPipelineLength = BigDecimal.valueOf(equList.stream()
                .map(map -> map.get("pipeLength"))
                .filter(Objects::nonNull)
                .mapToDouble(value -> Double.parseDouble((String) value))
                .sum()).setScale(2, RoundingMode.HALF_UP).doubleValue();

        MapBuilder<String, Object> resultBuilder = MapBuilder.<String, Object>create()
                .put("equipmentLists", equList)
                .put("isXixian", isXixian)
                .put("projectContraption", projectContraption.getProjectContraption())
                .put("projectContraptionId", projectContraptionSeq)
                .put("projectContraptionNo", projectContraption.getProjectContraptionNo())
                .put("isFirstMerge", projectContraption.getIsFirstMerge())
                .put("pipelineLength", totalPipelineLength)
                .put("equListName", projectContraption.getEquListName())
                .put("equCategoryName", projectContraption.getEquCategoryName())
                .put("equDefineName", projectContraption.getEquDefineName());
        setProjectContraptionInfo(projectContraption, resultBuilder);
        return resultBuilder.build();
    }

    private void setProjectContraptionInfo(IdxBizJgProjectContraption projectContraption, MapBuilder<String, Object> re) {
        // 查询最新的历史记录
        JgRegistrationHistory history = jgRegistrationHistoryService.queryLatestRegistrationHistory(projectContraption.getSequenceNbr());

        Map<String, Object> fieldMappings = new HashMap<>();
        if (history != null && history.getChangeData() != null) {
            JSONObject hisJson = JSON.parseObject(history.getChangeData());
            fieldMappings.put("useRegistrationCode", projectContraption.getUseRegistrationCode());
            fieldMappings.put("safetyManager", hisJson.get("safetyManagerId") + "_" + hisJson.get("safetyManager"));
            fieldMappings.put("useDate", hisJson.get("useDate"));
            fieldMappings.put("otherAccessories", hisJson.get("otherAccessories"));
            fieldMappings.put("factoryUseSiteStreet", hisJson.get("factoryUseSiteStreet"));
            fieldMappings.put("province", hisJson.get("province"));
            fieldMappings.put("address", hisJson.get("address"));
            fieldMappings.put("city", hisJson.get("city"));
            fieldMappings.put("isXixian", hisJson.get("isXixian"));
            fieldMappings.put("county", hisJson.get("county"));
            fieldMappings.put("startLatitudeLongitude",
                    Objects.isNull(hisJson.get("startLatitudeLongitude")) ?
                            hisJson.get("longitudeLatitude") :
                            hisJson.get("startLatitudeLongitude"));
            fieldMappings.put("endLatitudeLongitude",
                    Objects.isNull(hisJson.get("startLatitudeLongitude")) ?
                            hisJson.get("longitudeLatitude") :
                            hisJson.get("endLatitudeLongitude"));
            fieldMappings.put("estateUnitName", hisJson.get("estateUnitName"));
            fieldMappings.put("orgBranchCode", hisJson.get("orgBranchCode"));
        } else {
            fieldMappings.put("province", projectContraption.getProvince());
            fieldMappings.put("city", projectContraption.getCity());
            fieldMappings.put("county", projectContraption.getCounty());
            fieldMappings.put("factoryUseSiteStreet", projectContraption.getStreet());
            fieldMappings.put("address", projectContraption.getAddress());
            fieldMappings.put("startLatitudeLongitude", JSON.parseObject(projectContraption.getStartLatitudeLongitude()));
            fieldMappings.put("endLatitudeLongitude", JSON.parseObject(projectContraption.getEndLatitudeLongitude()));
            fieldMappings.put("orgBranchCode", projectContraption.getOrgCode()+"_"+ projectContraption.getOrgName());
        }

        fieldMappings.forEach(re::put);
    }

    private void setConstructionInfo(String projectContraptionSeq, Map<String, Object> re) {
        LambdaQueryWrapper<IdxBizJgProjectConstruction> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizJgProjectConstruction::getProjectContraptionId, projectContraptionSeq)
                .orderByDesc(IdxBizJgProjectConstruction::getUscDate).last("limit 1");
        IdxBizJgProjectConstruction construction = idxBizJgProjectConstructionMapper.selectOne(queryWrapper);
        if(construction != null){
            re.put("installLeaderName", construction.getConstructionLeaderName());
            re.put("installLeaderPhone",construction.getConstructionLeaderPhone());
            re.put("installStartDate", construction.getUscDate());
            re.put("installPropertyUnitName", construction.getConstructionLeaderName());
            re.put("installProxyStatementAttachment", JSON.parse(construction.getProxyStatementAttachment()));
            re.put("installContractAttachment", JSON.parse(construction.getConstructionContractAttachment()));
            re.put("insOtherAccessories", JSON.parse(construction.getConstructionOtherAccessories()));
            re.put("installStreet", construction.getStreetName());
            re.put("installProvince", construction.getProvinceName());
            re.put("installAddress", construction.getAddress());
            re.put("installCity", construction.getCityName());
            re.put("installIsXixian", construction.getIsXixian());
            re.put("installCounty", construction.getCountyName());
            re.put("uscUnitCreditCode", construction.getUscUnitCreditCode());
            re.put("uscUnitName", construction.getUscUnitName());
        }
    }

    private void setPieLineInspectInfo(String projectContraptionSeq, Map<String, Object> re) {
        LambdaQueryWrapper<IdxBizJgProjectInspection> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(IdxBizJgProjectInspection::getProjectContraptionId, projectContraptionSeq)
                .orderByDesc(IdxBizJgProjectInspection::getInspectDate).last("limit 1");
        IdxBizJgProjectInspection inspection = projectInspectionMapper.selectOne(queryWrapper);
        if(inspection != null){
            re.put("inspectOrgCode", inspection.getInspectOrgCode());
            re.put("inspectOrgName", inspection.getInspectOrgCode());
            re.put("inspectConclusion", inspection.getInspectConclusion());
            re.put("inspectType", inspection.getInspectType());
            re.put("inspectDate", inspection.getInspectDate());
            re.put("inspectStaff", inspection.getInspectStaff());
            re.put("nextInspectDate", inspection.getNextInspectDate());
            re.put("inspectReport", JSON.parse(inspection.getInspectReport()));
            re.put("inspectReportNo",inspection.getInspectReportNo());
            // 返回代表是系统的数据，前端控制系统的检验信息不让编辑
            re.put("jySeq",inspection.getSequenceNbr());
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void initFormUrl() {
        LambdaQueryWrapper<JgUseRegistration> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgUseRegistration::getIsDelete, false)
                .isNull(JgUseRegistration::getUseRegistrationFormUrl)
                .ne(JgUseRegistration::getStatus, "已作废")
                .ne(JgUseRegistration::getRegType, "1");
        List<JgUseRegistration> useRegistrations = this.list(queryWrapper);
        if(CollUtil.isNotEmpty(useRegistrations)){
            for (JgUseRegistration useRegistration : useRegistrations) {
                try {
                    Map<String, Object> detail = this.getDetail(null, useRegistration.getSequenceNbr(), null);
                    String jsonString = JSONObject.toJSONString(detail);
                    JSONObject jsonObject = JSONObject.parseObject(jsonString);
                    FeignClientResult<AgencyUserModel> agencyUserModelFeignClientResult = Privilege.agencyUserClient.queryByUserId((String) detail.get("createUserId"));
                    jsonObject.put("userName",agencyUserModelFeignClientResult.getResult().getRealName());
                    String manageType = useRegistration.getManageType();
                    if(StringUtils.isEmpty(manageType)){
                        manageType="set";
                    }
                    Map<String, Object> formUrlMap = commonService.getRegistrationFormUrl(manageType, jsonObject);
                    if(Objects.nonNull(formUrlMap)){
                        LambdaUpdateWrapper<JgUseRegistration> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.set(JgUseRegistration::getUseRegistrationFormUrl,String.valueOf(formUrlMap.get("useRegistrationFormUrl")))
                                .eq(JgUseRegistration::getSequenceNbr,useRegistration.getSequenceNbr());
                        this.update(wrapper);
                    }
                }catch (BadRequest request){
                    log.error(request.getMessage(),request);
                }
            }
        }
    }

    public Object countUseTimesForInvalid(Object code) {
        return jgUseRegistrationMapper.countUseTimesForInvalid(code) == 0;
    }


    public JSONObject getHisData(JgUseRegistration jgUseRegistration){
        return commonService.queryHistoryData(jgUseRegistration.getSequenceNbr());
    }
}