package com.yeejoin.precontrol.common.dto;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @description: 技术交底
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
public class SingJobDisclosureDto extends BaseDto{

    //人员类型（0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员  99 发布人）
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "任务id")
    private Long id;
    @ApiModelProperty(value = "所属项目id")
    private Long projectId;
    @ApiModelProperty(value = "方案名称")
    private String name;
    @ApiModelProperty(value = "方案代号")
    private String code;
    @ApiModelProperty(value = "方案编号")
    private String number;
    @ApiModelProperty(value = "技术交底文件Id")
    private Long documentId;
    @ApiModelProperty(value = "技术交底文件名称")
    private String documentName;

    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<FileDto> attachment;

    @ApiModelProperty(value = "主持人")
    private List<Long> hostPersonId;
    @ApiModelProperty(value = "交底人")
    private List<Long> disclosurePersonId;
    @ApiModelProperty(value = "施工负责人")
    private List<Long> constructionDirectorId;
    @ApiModelProperty(value = "安全员")
    private List<Long> safetyOfficerId;
    @ApiModelProperty(value = "记录员")
    private List<Long> noteTakerId;
    @ApiModelProperty(value = "交底人员")
    private List<Long> participateDisclosureId;
    @ApiModelProperty(value = "项目部安全员")
    private List<Long> platformSafetyOfficerId;
}

