package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.equipmanage.common.enums.ConfigPageTopicEnum;
import com.yeejoin.equipmanage.common.enums.SourceTypeEnum;
import com.yeejoin.equipmanage.listener.IntegratePageDataListener;
import com.yeejoin.equipmanage.service.IMaintenanceResourceDataService;
import com.yeejoin.equipmanage.service.ISourceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

/**
 * @author keyong
 * @title: ApplicationRunnerImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/12/12 20:18
 */
@Component
public class ApplicationRunnerImpl implements ApplicationRunner {

    @Autowired
    private IMaintenanceResourceDataService maintenanceResourceDataService;

    @Autowired
    private EmqKeeper emqKeeper;

    @Autowired
    IntegratePageDataListener integratePageDataListener;

    @Autowired
    RedisUtils redisUtils;

    @Value("${redis_car_type_count}")
    private String carTypeAndCount;

    @Value("${redis_equip_type_count}")
    private String equipTypeAndCount;

    @Autowired
    ISourceStatistics iSourceStatistics;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 清空单位装备分类树缓存
        redisUtils.getAndDeletePatternKeys(carTypeAndCount + "*");
        // 清空车辆分类树缓存
        redisUtils.getAndDeletePatternKeys(equipTypeAndCount + "*");

        redisUtils.getAndDeletePatternKeys("iotTypeAndCount" + "*");

        // 清空单位分类数量统计缓存
        redisUtils.getAndDeletePatternKeys(SourcesStatisticsImpl.PREFIX_CATEGORY_COUNT + "*");
        // 刷新单位分类数量统计
        iSourceStatistics.initAllCategoryStatisticsData(SourceTypeEnum.EQUIPMENT);
        iSourceStatistics.initAllCategoryStatisticsData(SourceTypeEnum.CAR);
        iSourceStatistics.initAllCategoryStatisticsData(SourceTypeEnum.IOT);

        maintenanceResourceDataService.subscribeTopic();
        emqKeeper.subscript(ConfigPageTopicEnum.INTEGRATE.getTopic(), 2, integratePageDataListener);
        emqKeeper.subscript(ConfigPageTopicEnum.SYSTEMDETAIL.getTopic(), 2, integratePageDataListener);
    }
}
