package com.yeejoin.amos.boot.module.elevator.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备搜索DTO
 */
@Data
@ApiModel(value="EsSpecialEquipmentDto", description="特种设备搜索DTO")
public class EsSpecialEquipmentDto {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 左上经度
     */
    @ApiModelProperty(value = "左上经度")
    private Double startLongitude;

    /**
     * 左上纬度
     */
    @ApiModelProperty(value = "左上纬度")
    private Double startLatitude;


    /**
     * 右下经度
     */
    @ApiModelProperty(value = "右下经度")
    private Double endLongitude;

    /**
     * 右下纬度
     */
    @ApiModelProperty(value = "右下纬度")
    private Double endLatitude;

    /**
     * 搜索关键字
     */
    @ApiModelProperty(value = "搜索关键字")
    private String keyword;

    /**
     * 所属区域代码
     */
    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    /**
     * 设备类别编码
     */
    @ApiModelProperty(value = "设备类别编码")
    private String categoryCode;

    @ApiModelProperty(value = "聚合精确度1-12")
    private Integer precision;

    @ApiModelProperty(value = "后台聚合查询种类")
    private String selectType;


}
