package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 安全追溯-锅炉
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "IdxBizJgTechParamsBoilerDto", description = "安全追溯-锅炉")
public class IdxBizJgTechParamsBoilerDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    private String record;


    private String instanceId;

    private String status;

    @ApiModelProperty(value = "设备等级")
    private String deviceLevel;

    @ApiModelProperty(value = "额定蒸发量（热功率）")
    private String ratedEvaporationCapacityThermalPower;

    @ApiModelProperty(value = "额定工作压力")
    private String ratedWorkingPressure;

    @ApiModelProperty(value = "额定工作温度")
    private String ratedOperatingTemperature;

    @ApiModelProperty(value = "设计热效率")
    private String designThermalEfficiency;

    @ApiModelProperty(value = "给水温度")
    private String feedwaterTemperature;

    @ApiModelProperty(value = "额定出/回水(油)温度")
    private String ratedOutletReturnWaterOilTemperature;

    @ApiModelProperty(value = "锅炉本体水（油）容积")
    private String waterOilVolumeOfBoilerProper;

    @ApiModelProperty(value = "整装锅炉本体液压试验介质/压力")
    private String hydraulicTestMediumPressureOfPackagedBoilerBody;

    @ApiModelProperty(value = "再热器进（出）口温度")
    private String inletOutletTemperatureOfReheater;

    @ApiModelProperty(value = "再热器进（出）口压力")
    private String reheaterInletOutletPressure;

    @ApiModelProperty(value = "再热蒸汽流量")
    private String reheatSteamFlow;

    @ApiModelProperty(value = "有机热载体锅炉气密试验介质/压力")
    private String glAirtightTest;

    @ApiModelProperty(value = "燃料（热源）种类")
    private String fuelType;

    @ApiModelProperty(value = "受压部件名称")
    private String nameOfPressureParts;

    @ApiModelProperty(value = "受压部件材料")
    private String materialOfPressureParts;

    @ApiModelProperty(value = "受压部件壁厚")
    private String wallThicknessOfPressureParts;

    @ApiModelProperty(value = "受压部件无损检测方法")
    private String nonDestructiveTestingMethodsForPressureParts;

    @ApiModelProperty(value = "受压部件无损检测比例")
    private String proportionOfNdtForPressureParts;

    @ApiModelProperty(value = "受压部件热处理温度")
    private String heatTreatmentTemperatureOfPressureParts;

    @ApiModelProperty(value = "受压部件热处理时间")
    private String heatTreatmentTimeOfPressureParts;

    @ApiModelProperty(value = "受压部件水（耐）压试验介质")
    private String hydrostaticTestMedium;

    @ApiModelProperty(value = "受压部件水（耐）压试验压力")
    private String hydrostaticTestPressure;

    @ApiModelProperty(value = "燃烧方式")
    private String combustionMode;

    /**
     * 安装附件与有关装置
     */

    private String safetyAccessoriesAndRelatedDevices;

    /**
     * 参数是否完整齐全：1-齐全；2-不齐全 【历史无证设备需要】
     */
    private String techParamIsComplete;


}
