package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * <p>
 * 知识库文档存储
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_doc_content")
public class KnowledgeDocContent extends BaseEntity {


	/**
	 * 富文本内容存储
	 */
	@TableField("HTML_CONTENT")
	private String htmlContent;

	/**
	 * 文档状态：发布，未发布
	 */
	@TableField("DOC_STATUS")
	private String docStatus;

	/**
	 * 发布者
	 */
	@TableField("USER_ID")
	private String userId;

	/**
	 * 创建时间
	 */
	@TableField("CREATE_TIME")
	private Date createTime;

	/**
	 * 是否有附件
	 */
	@TableField("HAVE_ATTACHMENT")
	private Boolean haveAttachment;

	/**
	 * 摘要
	 */
	@TableField("SUMMARY")
	private String summary;

	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;

	/**
	 * 审核状态:通过，驳回，待审核，待提交
	 **/
	@TableField("AUDIT_STATUS")
	private String auditStatus;

	/**
	 * 驳回意见
	 **/
	@TableField("REJECTION_COMMENT")
	private String rejectionComment;

	/**
	 * 审核人id
	 **/
	@TableField("AUDITOR_USER_ID")
	private String auditorUserId;

	@TableField("ORG_CODE")
	private String orgCode;

	/**
	 * 纯文本内容
	 */
	@TableField("TEXT_CONTENT")
	private String textContent;

	/**
	 * 排序内容
	 */
	@TableField("SORT_STR")
	private String sortStr;

	/**
	 * 所属目录
	 */
	@TableField("DIRECTORY_ID")
	private Long directoryId;

	/**
	 * 文档标题
	 */
	@TableField("DOC_TITLE")
	private String docTitle;

}

