package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.Enum.FinancingAuditEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingAuditingDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.WorkflowResultDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfo;
import com.yeejoin.amos.boot.module.hygf.api.mapper.FinancingInfoMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IFinancingInfoService;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.*;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-04-01
 */
@Service
public class FinancingInfoServiceImpl extends BaseService<FinancingInfoDto,FinancingInfo,FinancingInfoMapper> implements IFinancingInfoService {
    /**
     * 分页查询
     */
    @Autowired
    private FinancingInfoMapper financingInfoMapper;
    @Autowired
    private WorkFlowService workFlowService;
    @Autowired
    private  WorkflowImpl workflow;
    @Autowired
    private FinancingAuditingServiceImpl financingAuditingService;

    private static  String  PROCESSKEY="StationFinancing";


    public Page<Map<String, String>> queryForFinancingInfoPage(Page<Map<String, String>> page)   {

        PageHelper.startPage((int)page.getCurrent(),(int)page.getSize());
        List<Map<String, String>> list = financingInfoMapper.getStationFinancingInfoList();
        PageInfo<Map<String, String>> infos = new PageInfo<>(list);
        page.setRecords(list);
        page.setTotal(infos.getTotal());
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<FinancingInfoDto> queryForFinancingInfoList()   {
        return this.queryForList("" , false);
    }

    @Transactional
    public FinancingInfoDto saveModel(FinancingInfoDto model) {
        List<String> ids ;
        if (model.getPeasantHouseholdIds().contains(",")) {
            ids= Arrays.asList(model.getPeasantHouseholdIds().split(","));
        }else {
            ids= Arrays.asList(new String[]{model.getPeasantHouseholdIds()});

        }

        ids.stream().forEach(e->{
            LambdaQueryWrapper<FinancingInfo> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(FinancingInfo::getPeasantHouseholdId,Long.valueOf(e));
            List<FinancingInfo> financingInfos = this.getBaseMapper().selectList(queryWrapper);
            if (CollectionUtils.isEmpty(financingInfos)){
                model.setStatus(FinancingAuditEnum.待融资审核.getName());
                model.setPeasantHouseholdId(Long.valueOf(e));
                FinancingInfoDto financingInfoDto = new FinancingInfoDto();
                BeanUtils.copyProperties(model,financingInfoDto);
                financingInfoDto.setSequenceNbr(null);
                this.createWithModel(financingInfoDto);
            }

            //开启工作流 并执行一步
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(PROCESSKEY);
            dto.setBusinessKey(String.valueOf(new Date().getTime()));
            dto.setCompleteFirstTask(true);
            list.add(dto);
            actWorkflowBatchDTO.setProcess(list);
            List<ProcessTaskDTO> processTaskDTOS = workFlowService.startBatch(actWorkflowBatchDTO);
            List<WorkflowResultDto> workflowResultDtos = workFlowService.buildWorkFlowInfo(processTaskDTOS);

            WorkflowResultDto workflowResultDto = workflowResultDtos.get(0);
            FinancingAuditingDto financingAuditingDto = new FinancingAuditingDto();
            BeanUtils.copyProperties(workflowResultDto,financingAuditingDto);
            financingAuditingDto.setPeasantHouseholdId(Long.valueOf(e));
            financingAuditingDto.setPromoter(RequestContext.getExeUserId());
            financingAuditingService.createWithModel(financingAuditingDto);

        });



        return model;
    }


    @Override
    public void rollback(String processId, String peasantHouseholdId) {
        workFlowService.stopProcess(processId);

        LambdaQueryWrapper<FinancingInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(FinancingInfo::getPeasantHouseholdId,peasantHouseholdId);
        List<FinancingInfo> financingInfos = this.getBaseMapper().selectList(queryWrapper);

        if (!CollectionUtils.isEmpty(financingInfos)){
            FinancingInfo financingInfo = financingInfos.get(0);
            financingInfo.setStatus("待推送");
            financingInfo.setFinancingCompaniesCode(null);
            financingInfo.setFinancingCompaniesSeq(null);
            financingInfo.setFinancingCompaniesName(null);
            this.updateById(financingInfo);
        }
    }

    @Override
    public FinancingInfoDto selectDataInfo(Long peasantHouseholdId) {
        return this.getBaseMapper().selectDataInfo(peasantHouseholdId);
    }
}