package com.yeejoin.amos.boot.module.jxiop.biz.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.github.pagehelper.PageInterceptor;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;
import java.util.Properties;
@Configuration
@MapperScan(basePackages  = "com.yeejoin.amos.boot.module.jxiop.biz.amosprojectmapper", sqlSessionFactoryRef = "amosProjectSqlSessionFactory")
public class AmosProjectDbConfig {
    private Logger logger = LoggerFactory.getLogger(AmosProjectDbConfig.class);
    // 精确到 master 目录，以便跟其他数据源隔离

    private static final String MAPPER_LOCATION = "classpath*:mapper/amosproject/*.xml";

    @Value("${spring.db2.datasource.url}")
    private String dbUrl;

    @Value("${spring.db2.datasource.username}")
    private String username;

    @Value("${spring.db2.datasource.password}")
    private String password;

    @Value("${spring.db2.datasource.driver-class-name}")
    private String driverClassName;


    @Bean(name="amosProjectDataSource")   //声明其为Bean实例
    public DataSource masterDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setDriverClassName(driverClassName);
        return datasource;
    }

    @Bean(name = "amosProjectTransactionManager")
    public DataSourceTransactionManager masterTransactionManager() {
        return new DataSourceTransactionManager(masterDataSource());
    }

    @Bean(name = "amosProjectSqlSessionFactory")
    public SqlSessionFactory masterSqlSessionFactory(@Qualifier("amosProjectDataSource") DataSource masterDataSource)
            throws Exception {
        final MybatisSqlSessionFactoryBean sessionFactory = new MybatisSqlSessionFactoryBean();
        sessionFactory.setDataSource(masterDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(AmosProjectDbConfig.MAPPER_LOCATION));
        sessionFactory.setTypeAliasesPackage("com.yeejoin.amos.boot.module.jxiop.biz.entity");
        //mybatis 数据库字段与实体类属性驼峰映射配置
        sessionFactory.getObject().getConfiguration().setMapUnderscoreToCamelCase(true);


        //分页插件
        Interceptor interceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("helperDialect", "mysql");
        properties.setProperty("offsetAsPageNum", "true");
        properties.setProperty("rowBoundsWithCount", "true");
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments","true");
        properties.setProperty("params","pageNum=pageNum;pageSize=pageSize" +
                "" +
                ";");
        interceptor.setProperties(properties);



        sessionFactory.setPlugins(new Interceptor[] {interceptor});

        return sessionFactory.getObject();
    }
}
