package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author DELL
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_user_registration")
@ApiModel(value = "UserRegistration对象", description = "用户注册基本信息")
public class UserRegistration extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户姓名")
    private String realName;

    @ApiModelProperty(value = "用户id")
    private String phoneNo;

    @ApiModelProperty(value = "证件类型")
    private Long idType;

    @ApiModelProperty(value = "证件号码")
    private String idNumber;

    @ApiModelProperty(value = "个人头像")
    @ImagePrefix
    private String profile;

    @ApiModelProperty(value = "身份证头像面")
    @ImagePrefix
    private String idCardHead;

    @ApiModelProperty(value = "身份证国徽面")
    @ImagePrefix
    private String idCardNational;

    @ApiModelProperty(value = "所在单位id")
    private Long companyId;

    @ApiModelProperty(value = "所在项目id")
    private Long projectId;

    @ApiModelProperty(value = "分包商审核人id")
    private Long fbsVerityId;

    @ApiModelProperty(value = "项目部审核人id")
    private Long projectDepartVerityId;

    @ApiModelProperty(value = "岗位key")
    private String postNameKey;

    @ApiModelProperty(value = "岗位")
    private String postName;

    @ApiModelProperty(value = "状态")
    private Integer verifyStatus;

    @ApiModelProperty(value = "userId")
    private Long userId;

    @ApiModelProperty(value = "三级安全考试成绩")
    private Long examineScore;

    @ApiModelProperty(value = "三级安全考试是否合格")
    private Integer qualified;

    @ApiModelProperty(value = "部门ID")
    private Long departmentId;

    @ApiModelProperty(value = "角色ID")
    private Long roleId;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @TableField(exist = false) 
    private Long personId;

}
