package com.yeejoin.amos.boot.module.jyjc.biz.rule;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author LiuLin
 * @date 2024年01月02日 16:47
 */
@Data
@ApiModel(value = "InspectionEquipInfo")
public class InspectionEquipInfo implements Serializable {

    @ApiModelProperty(value = "请求唯一标识")
    private String componentKey;

    @ApiModelProperty(value = "设备ID")
    private String record;

    @ApiModelProperty(value = "检验类型（大类与菜单对应）")
    private String bizType;

    @ApiModelProperty(value = "技术参数")
    private Map<String, Object> techParams;

    @ApiModelProperty(value = "是否防爆")
    private Boolean isAntiExplosion;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "检验类型（小类）")
    private String inspectionType;

    @ApiModelProperty(value = "请求类型：firstRequest-首次的提交，noAcceptRequest-不予受理的提交")
    private String requestType;

    @ApiModelProperty(value = "消息唯一标识用来判断消息重复")
    private String uuid;

    @ApiModelProperty(value = "最近不受理检验机构code")
    private String lastNoAcceptInspectionCode;

    @ApiModelProperty(value = "所在区域")
    private String areaCode;

    @ApiModelProperty(value = "设备所在区/县行政编码")
    private String districtOrCountyCode;

    @ApiModelProperty(value = "是否是球阀,压力容器定向规则使用")
    private Boolean isBallValve = false;

    @ApiModelProperty(value = "申请表主键")
    private String appSeq;

}
