package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.hygf.api.dto.PeasantHouseholdDtoP;
import com.yeejoin.amos.boot.module.hygf.api.dto.SurveyInformationDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.SurveyInformationServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.RegionModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.PeasantHouseholdServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.PeasantHouseholdDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@RestController
@Api(tags = "农户信息Api")
@RequestMapping(value = "/peasant-household")
public class PeasantHouseholdController extends BaseController {

	@Autowired
	SurveyInformationServiceImpl surveyInformationServiceImpl;

    @Autowired
    PeasantHouseholdServiceImpl peasantHouseholdServiceImpl;

	@Autowired
	RedisUtils redisUtils;

	private static final String regionRedis="app_region_redis";

    /**
     * 新增农户信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增农户信息", notes = "新增农户信息")
	public ResponseModel<PeasantHouseholdDto> save(@RequestBody PeasantHouseholdDto model) {

		SurveyInformationDto surveyInformationDto = new SurveyInformationDto();
		surveyInformationServiceImpl.createWithModel(surveyInformationDto);
		JSONArray regionName = getRegionName();
		List<RegionModel> list = JSONArray.parseArray(regionName.toJSONString(), RegionModel.class);
		// 处理地址
		String area = "";
		for (Integer reg : model.getProjectAddressArr())
			for (RegionModel re : list) {
				if (re.getRegionCode().equals(Integer.valueOf(reg))) {
					area = area + re.getRegionName() + "/";
				}
		}
		model.setProjectAddressName(area.substring(0, area.length() - 2));
		if (model.getProjectAddressArr().size()>0) {
			model.setProjectAddress(JSON.toJSONString(model.getProjectAddressArr()));
		}
		if (model.getPermanentAddressArr().size()>0) {
			model.setPermanentAddress(JSON.toJSONString(model.getPermanentAddressArr()));
		}
		if (model.getIsPermanent().size()>0) {
			model.setPermanentAddress(JSON.toJSONString(model.getProjectAddressArr()));
			model.setPermanentAddressDetail(model.getProjectAddressDetail());
		}
		model.setSurveyInformationId(surveyInformationDto.getSequenceNbr());
		PeasantHouseholdDto householdDto = peasantHouseholdServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(householdDto);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新农户信息", notes = "根据sequenceNbr更新农户信息")
	public ResponseModel<PeasantHouseholdDto> updateBySequenceNbrPeasantHousehold(@RequestBody PeasantHouseholdDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
		JSONArray regionName = getRegionName();
		List<RegionModel> list = JSONArray.parseArray(regionName.toJSONString(), RegionModel.class);
		// 处理地址
		String area = "";
		for (Integer reg : model.getProjectAddressArr())
			for (RegionModel re : list) {
				if (re.getRegionCode().equals(Integer.valueOf(reg))) {
					area = area + re.getRegionName() + "/";
				}
			}
		model.setProjectAddressName(area.substring(0, area.length() - 2));
		if (model.getProjectAddressArr().size()>0) {
			model.setProjectAddress(JSON.toJSONString(model.getProjectAddressArr()));
		}
		if (model.getPermanentAddressArr().size()>0) {
			model.setPermanentAddress(JSON.toJSONString(model.getPermanentAddressArr()));
		}
		if (model.getIsPermanent().size()>0) {
			model.setPermanentAddress(JSON.toJSONString(model.getProjectAddressArr()));
			model.setPermanentAddressDetail(model.getProjectAddressDetail());
		}
	    return ResponseHelper.buildResponse(peasantHouseholdServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除农户信息", notes = "根据sequenceNbr删除农户信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(peasantHouseholdServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个农户信息",  notes = "根据sequenceNbr查询单个农户信息")
	public ResponseModel<PeasantHouseholdDto> selectOne(@PathVariable Long sequenceNbr) {
		PeasantHouseholdDto peasantHouseholdDto = peasantHouseholdServiceImpl.queryBySeq(sequenceNbr);
		peasantHouseholdDto.setProjectAddressArr(JSON.parseArray(peasantHouseholdDto.getProjectAddress(), Integer.class));
		if(!StringUtils.isEmpty(peasantHouseholdDto.getPermanentAddress())){
			peasantHouseholdDto.setPermanentAddressArr(JSON.parseArray(peasantHouseholdDto.getPermanentAddress(), Integer.class));
		}else {
			peasantHouseholdDto.setPermanentAddressArr(JSON.parseArray("[]", Integer.class));
			peasantHouseholdDto.setIsPermanent(JSON.parseArray("[1]", String.class));
		}

		return ResponseHelper.buildResponse(peasantHouseholdDto);
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "农户信息分页查询",  notes = "农户信息分页查询")
	public ResponseModel<Page<PeasantHouseholdDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<PeasantHouseholdDto> page = new Page<PeasantHouseholdDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(peasantHouseholdServiceImpl.queryForPeasantHouseholdPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "农户信息列表全部数据查询",   notes = "农户信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<PeasantHouseholdDto>> selectForList() {
	    return ResponseHelper.buildResponse(peasantHouseholdServiceImpl.queryForPeasantHouseholdList());
	}

	public JSONArray getRegionName(){
		JSONArray jsonArray = new JSONArray();
		if (redisUtils.hasKey(regionRedis)) {
			jsonArray= JSONArray.parseArray(redisUtils.get(regionRedis).toString());
		}else {
			Collection<RegionModel> regionChild = new ArrayList<>();
			RegionModel regionModel1 = new RegionModel();
			regionChild.add(regionModel1);
			FeignClientResult<Collection<RegionModel>> collectionFeignClientResult = Systemctl.regionClient.queryForTreeParent(610000L);
			Collection<RegionModel> result = collectionFeignClientResult.getResult();
			for (RegionModel regionModel : result) {
				if(null != regionModel && null != regionModel.getChildren()) {
					for (RegionModel child : regionModel.getChildren()) {
						if(null != child && null != child.getChildren()) {
							for (RegionModel childChild : child.getChildren()) {
								jsonArray.add(childChild);
							}
							child.setChildren(regionChild);
							jsonArray.add(child);
						}
					}
					regionModel.setChildren(regionChild);
					jsonArray.add(regionModel);
				}
			}

			redisUtils.set(regionRedis,jsonArray);
		}
		return jsonArray;
	}
}
