package com.yeejoin.amos.boot.module.elevator.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 特种设备DTO
 */
@Data
@ApiModel(value="SpecialEquipmentDto", description="特种设备DTO")
public class SpecialEquipmentDto {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ExcelIgnore
    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "电梯应急救援识别码")
    private Integer rescueCode;

    @ApiModelProperty(value = "设备注册代码")
    private String registerCode;

    @ApiModelProperty(value = "所属省")
    private String province;

    @ApiModelProperty(value = "所属地市")
    private String city;

    @ApiModelProperty(value = "所属区县")
    private String district;

    @ApiModelProperty(value = "所属区域代码")
    private String regionCode;

    @ApiModelProperty(value = "安装地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "设备类别编码")
    private String categoryCode;

    @ApiModelProperty(value = "内部编码")
    private String innerNum;

    @ApiModelProperty(value = "产权单位")
    private String unitName;
}
