package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchConsultFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchRepairFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchSaveFeedbackDto;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.DispatchPaperServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 派遣单
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣单Api")
@RequestMapping(value = "/dispatch-paper")
public class DispatchPaperController extends BaseController {

    @Autowired
    DispatchPaperServiceImpl dispatchPaperServiceImpl;

	@Autowired
	RedisUtils redisUtils;

	/**
	 * 通过警情id 获取 救援回访相关信息
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/feedback/save/{alertId}")
	@ApiOperation(httpMethod = "GET", value = "通过警情id 获取 救援回访相关信息", notes = "通过警情id 获取 救援回访相关信息")
	public ResponseModel<DispatchSaveFeedbackDto> getSaveFeedback(@PathVariable Long alertId) {

		DispatchSaveFeedbackDto dispatchSaveFeedbackDto = dispatchPaperServiceImpl.getDispatchSaveFeedbackDtoByAlertId(alertId);
		ReginParams reginParams =getSelectedOrgInfo();
		AgencyUserModel user = reginParams.getUserModel();
		if(dispatchSaveFeedbackDto.getSaveFeedbackUid() == null && dispatchSaveFeedbackDto.getSaveFeedbackUser() == null) {
			dispatchSaveFeedbackDto.setSaveFeedbackUser(user.getRealName());
			dispatchSaveFeedbackDto.setSaveFeedbackUid(user.getUserId());
		}
		if(dispatchSaveFeedbackDto.getFeedbackUid() == null && dispatchSaveFeedbackDto.getFeedbackUname() == null) {
			dispatchSaveFeedbackDto.setFeedbackUid(user.getUserId());
			dispatchSaveFeedbackDto.setFeedbackUname(user.getRealName());
		}
		return ResponseHelper.buildResponse(dispatchSaveFeedbackDto);
	}

	/**
	 * 保存救援回访信息
	 * @param dispatchSaveFeedbackDto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/feedback/save")
	@ApiOperation(httpMethod = "POST", value = "保存救援回访信息", notes = "保存救援回访信息")
	public ResponseModel<Boolean> saveSaveFeedBack(@RequestBody DispatchSaveFeedbackDto dispatchSaveFeedbackDto) {
		if (ValidationUtil.isEmpty(dispatchSaveFeedbackDto)
				|| ValidationUtil.isEmpty(dispatchSaveFeedbackDto.getAlertId()))
			throw new BadRequest("参数校验失败.");
	    return ResponseHelper.buildResponse(dispatchPaperServiceImpl.saveDispatchSaveFeedback(dispatchSaveFeedbackDto,getSelectedOrgInfo().getUserModel()));
	}

	/**
	 * 通过警情id 获取 维修回访相关信息
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/feedback/repair/{alertId}")
	@ApiOperation(httpMethod = "GET", value = "通过警情id 获取 维修回访相关信息", notes = "通过警情id 获取 维修回访相关信息")
	public ResponseModel<DispatchRepairFeedbackDto> getRepairFeedBack(@PathVariable Long alertId) {

		DispatchRepairFeedbackDto dispatchRepairFeedbackDto = dispatchPaperServiceImpl.getDispatchRepairFeedbackDtoByAlertId(alertId);
		ReginParams reginParams =getSelectedOrgInfo();
		AgencyUserModel user = reginParams.getUserModel();
		if(dispatchRepairFeedbackDto.getFixFeedbackUid() == null && dispatchRepairFeedbackDto.getFixFeedbackUname() == null) {
			dispatchRepairFeedbackDto.setFixFeedbackUname(user.getRealName());
			dispatchRepairFeedbackDto.setFixFeedbackUid(user.getUserId());
		}
		if(dispatchRepairFeedbackDto.getFeedbackUid() == null && dispatchRepairFeedbackDto.getFeedbackUname() == null) {
			dispatchRepairFeedbackDto.setFeedbackUid(user.getUserId());
			dispatchRepairFeedbackDto.setFeedbackUname(user.getRealName());
		}
		return ResponseHelper.buildResponse(dispatchRepairFeedbackDto);
	}

	/**
	 * 保存维修回访信息
	 * @param dispatchRepairFeedbackDto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/feedback/repair")
	@ApiOperation(httpMethod = "POST", value = "保存维修回访信息", notes = "保存维修回访信息")
	public ResponseModel<Boolean> saveRepairFeedBack(@RequestBody DispatchRepairFeedbackDto dispatchRepairFeedbackDto) {
		if (ValidationUtil.isEmpty(dispatchRepairFeedbackDto)
				|| ValidationUtil.isEmpty(dispatchRepairFeedbackDto.getAlertId()))
			throw new BadRequest("参数校验失败.");
		boolean bool = dispatchPaperServiceImpl.saveDispatchRepairFeedback(dispatchRepairFeedbackDto,getSelectedOrgInfo().getUserModel());
		if (!bool) {
			return CommonResponseUtil.failure("请先派遣人员排查问题！");
		}
		return ResponseHelper.buildResponse(bool);
	}

	/**
	 * 通过警情id 获取 投诉回访相关信息
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/feedback/consult/{alertId}")
	@ApiOperation(httpMethod = "GET", value = "通过警情id 获取 投诉回访相关信息", notes = "通过警情id 获取 投诉回访相关信息")
	public ResponseModel<DispatchConsultFeedbackDto> getConsultFeedBack(@PathVariable Long alertId) {
		DispatchConsultFeedbackDto dispatchConsultFeedbackDto = dispatchPaperServiceImpl.getDispatchConsultFeedbackDtoByAlertId(alertId);
		ReginParams reginParams =getSelectedOrgInfo();
		AgencyUserModel user = reginParams.getUserModel();
		if(dispatchConsultFeedbackDto.getConsultFeedbackUid() == null && dispatchConsultFeedbackDto.getConsultFeedbackUname() == null) {
			dispatchConsultFeedbackDto.setConsultFeedbackUname(user.getRealName());
			dispatchConsultFeedbackDto.setConsultFeedbackUid(user.getUserId());
		}
		if(dispatchConsultFeedbackDto.getFeedbackUid() == null && dispatchConsultFeedbackDto.getFeedbackUname() == null) {
			dispatchConsultFeedbackDto.setFeedbackUid(user.getUserId());
			dispatchConsultFeedbackDto.setFeedbackUname(user.getRealName());
		}


		return ResponseHelper.buildResponse(dispatchConsultFeedbackDto);
	}

	/**
	 * 保存投诉回访信息
	 * @param dispatchConsultFeedbackDto
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/feedback/consult")
	@ApiOperation(httpMethod = "POST", value = "保存投诉回访信息", notes = "保存投诉回访信息")
	public ResponseModel<Boolean> saveConsultFeedBack(@RequestBody DispatchConsultFeedbackDto dispatchConsultFeedbackDto) {
		if (ValidationUtil.isEmpty(dispatchConsultFeedbackDto)
				|| ValidationUtil.isEmpty(dispatchConsultFeedbackDto.getAlertId()))
			throw new BadRequest("参数校验失败.");
		return ResponseHelper.buildResponse(dispatchPaperServiceImpl.saveDispatchConsultFeedback(dispatchConsultFeedbackDto,getSelectedOrgInfo().getUserModel()));
	}

	/**
	 * 根据警情id查询
	 *
	 * @param id
	 * @return
	 */
	@TycloudOperation(needAuth = true, ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/alert/{id}")
	@ApiOperation(httpMethod = "GET", value = "根据警情id查询", notes = "根据警情id查询")
	public ResponseModel<Object> selectById(@PathVariable Long id) {
		return ResponseHelper.buildResponse(dispatchPaperServiceImpl.selectDispatchPaperDtoByAlertId(id));

	}


}
