package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.biz.service.impl.ElevatorInsureServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorInsureDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 保险信息
 *
 * @author system_generator
 * @date 2021-10-29
 */
@RestController
@Api(tags = "保险信息Api")
@RequestMapping(value = "/elevator-insure")
public class ElevatorInsureController extends BaseController {

    @Autowired
    ElevatorInsureServiceImpl elevatorInsureServiceImpl;

    /**
     * 新增保险信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增保险信息", notes = "新增保险信息")
	public ResponseModel<ElevatorInsureDto> save(@RequestBody ElevatorInsureDto model) {
	    model = elevatorInsureServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新保险信息", notes = "根据sequenceNbr更新保险信息")
	public ResponseModel<ElevatorInsureDto> updateBySequenceNbrElevatorInsure(@RequestBody ElevatorInsureDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(elevatorInsureServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除保险信息", notes = "根据sequenceNbr删除保险信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(elevatorInsureServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个保险信息",  notes = "根据sequenceNbr查询单个保险信息")
	public ResponseModel<ElevatorInsureDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(elevatorInsureServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "保险信息分页查询",  notes = "保险信息分页查询")
	public ResponseModel<Page<ElevatorInsureDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ElevatorInsureDto> page = new Page<ElevatorInsureDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(elevatorInsureServiceImpl.queryForElevatorInsurePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "保险信息列表全部数据查询",   notes = "保险信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ElevatorInsureDto>> selectForList() {
	    return ResponseHelper.buildResponse(elevatorInsureServiceImpl.queryForElevatorInsureList());
	}
}
