package com.yeejoin.amos.boot.module.cylinder.biz.controller;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.CommonUtils;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzsCitInfo;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzsCitInfoService;
import org.springframework.http.MediaType;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;


/**
 * 
 *
 * @author duanwei
 * @date 2022-12-19
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/tzs-cit-info", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzsCitInfoController extends BaseController {

    @Autowired
    ITzsCitInfoService iTzsCitInfoService;


    /**
    * 新增
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveTzsCitInfo(HttpServletRequest request, @RequestBody TzsCitInfo tzsCitInfo){
        return iTzsCitInfoService.save(tzsCitInfo);
    }

    /**
    * 根据id删除
    * @param ids
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    @Transactional
    public ResponseModel<Boolean> deleteById(@PathVariable String ids){
        String[] idList = ids.split(",");
        for (String id : idList) {
            iTzsCitInfoService.removeById(id);
        }
        return ResponseHelper.buildResponse(true);
    }




    /**
    * 修改
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public ResponseModel<Boolean> updateByIdTzsCitInfo(@RequestBody TzsCitInfo tzsCitInfo){
    return ResponseHelper.buildResponse(iTzsCitInfoService.updateById(tzsCitInfo));
    }



    /**
    * 根据id查询
    * @param id
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public ResponseModel<TzsCitInfo> selectById(HttpServletRequest request, @PathVariable Long id){
      return ResponseHelper.buildResponse(iTzsCitInfoService.getById(id));
    }



    /**
    * 列表分页查询
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "列表分页查询", notes = "列表分页查询")
    public ResponseModel<IPage<TzsCitInfo>> listPage(String pageNum,String pageSize,@RequestBody TzsCitInfo tzsCitInfo){
        tzsCitInfo.setRegionCode(this.getSelectedOrgInfo().getCompany().getRegionCode());
        Page<TzsCitInfo> pageBean;
        QueryWrapper<TzsCitInfo> tzsCitInfoQueryWrapper = new QueryWrapper<>();
        Class<? extends TzsCitInfo> aClass = tzsCitInfo.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(tzsCitInfo);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                    Integer fileValue = (Integer) field.get(tzsCitInfo);
                    tzsCitInfoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                    Long fileValue = (Long) field.get(tzsCitInfo);
                    tzsCitInfoQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                    String fileValue = (String) field.get(tzsCitInfo);
                    tzsCitInfoQueryWrapper.eq(name, fileValue);
                    } else {
                    String fileValue = (String) field.get(tzsCitInfo);
                    tzsCitInfoQueryWrapper.eq(name, fileValue);
                }
              }
            }catch (Exception e) {
            }
        });
        IPage<TzsCitInfo> page;
        if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        }else{
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iTzsCitInfoService.page(pageBean, tzsCitInfoQueryWrapper);
        return ResponseHelper.buildResponse(page);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getUserList", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "获取值班所有人员列表", notes = "获取值班所有人员列表")
    public ResponseModel<List> getUserList(){
      return ResponseHelper.buildResponse(iTzsCitInfoService.getUserList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/saveInfo", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "保存人员及登录坐席参数", notes = "保存人员及登录坐席参数")
    public ResponseModel<String> saveInfo(@RequestBody TzsCitInfo tzsCitInfo) {
        String massage = iTzsCitInfoService.saveOrUpdateInfo(tzsCitInfo);
        if (!ValidationUtil.isEmpty(massage)) {
            return CommonResponseUtil.failure(massage);
        }
        return ResponseHelper.buildResponse("ok");
    }
}


