package com.yeejoin.amos.boot.module.cylinder.biz.service.impl;

import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.service.ISourceFileService;
import com.yeejoin.amos.boot.module.tzs.api.entity.ElevatorInsure;
import com.yeejoin.amos.boot.module.tzs.api.mapper.ElevatorInsureMapper;
import com.yeejoin.amos.boot.module.tzs.api.service.IElevatorInsureService;
import com.yeejoin.amos.boot.module.tzs.api.dto.ElevatorInsureDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 保险信息服务实现类
 *
 * @author system_generator
 * @date 2021-10-29
 */
@Service
public class ElevatorInsureServiceImpl extends BaseService<ElevatorInsureDto,ElevatorInsure,ElevatorInsureMapper> implements IElevatorInsureService {


    @Autowired
    ISourceFileService sourceFileService;

    /**
     * 分页查询
     */
    public Page<ElevatorInsureDto> queryForElevatorInsurePage(Page<ElevatorInsureDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ElevatorInsureDto> queryForElevatorInsureList()   {
        return this.queryForList("" , false);
    }

    @Override
    public ElevatorInsureDto getInsureInfoByElevatorCode(String elevatorCode) {
        ElevatorInsureDto tempDto = baseMapper.getInsureInfoByElevatorCode(elevatorCode);
        // 获取保险单附件信息
        if(tempDto != null) {
            Map<String, List<AttachmentDto>> attachMap = sourceFileService.getAttachments(tempDto.getSequenceNbr());
            List<AttachmentDto> attachment = attachMap.get("insure");
            tempDto.setInsureAttach(attachment);
        }
        return tempDto;
    }
}