package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylinderInfoDataServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderInfoDataDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶总量统计表
 *
 * @author system_generator
 * @date 2022-03-04
 */
@RestController
@Api(tags = "气瓶总量统计表Api")
@RequestMapping(value = "/cylinder-info-data")
public class CylinderInfoDataController extends BaseController {

    @Autowired
    CylinderInfoDataServiceImpl cylinderInfoDataServiceImpl;

    /**
     * 新增气瓶总量统计表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶总量统计表", notes = "新增气瓶总量统计表")
	public ResponseModel<CylinderInfoDataDto> save(@RequestBody CylinderInfoDataDto model) {
	    model = cylinderInfoDataServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶总量统计表", notes = "根据sequenceNbr更新气瓶总量统计表")
	public ResponseModel<CylinderInfoDataDto> updateBySequenceNbrCylinderInfoData(@RequestBody CylinderInfoDataDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderInfoDataServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶总量统计表", notes = "根据sequenceNbr删除气瓶总量统计表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderInfoDataServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶总量统计表",  notes = "根据sequenceNbr查询单个气瓶总量统计表")
	public ResponseModel<CylinderInfoDataDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderInfoDataServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶总量统计表分页查询",  notes = "气瓶总量统计表分页查询")
	public ResponseModel<Page<CylinderInfoDataDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderInfoDataDto> page = new Page<CylinderInfoDataDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderInfoDataServiceImpl.queryForCylinderInfoDataPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶总量统计表列表全部数据查询",   notes = "气瓶总量统计表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderInfoDataDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderInfoDataServiceImpl.queryForCylinderInfoDataList());
	}
}
