package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderUnitDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.CylinderUnit;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ICylinderInfoService;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylinderUnitServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 气瓶企业信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@RestController
@Api(tags = "气瓶企业信息Api")
@RequestMapping(value = "/cylinder-unit")
public class CylinderUnitController extends BaseController {

	@Autowired
	CylinderUnitServiceImpl cylinderUnitServiceImpl;

	@Autowired
	ICylinderInfoService iCylinderInfoService;



	/**
	 * 通过regionCode查询气瓶企业
	 *
	 * @return 查询结果
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@RequestMapping(value = "/queryCylinderUnitList", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "通过regionCode查询气瓶企业", notes = "通过regionCode查询气瓶企业")
	public ResponseModel<List<CylinderUnitDto>> querySpecialEquipmentList(@RequestParam String regionCode) {
		List<CylinderUnit> unitList = cylinderUnitServiceImpl
				.list(new LambdaQueryWrapper<CylinderUnit>().like(CylinderUnit::getRegionCode, regionCode));

		List<CylinderUnitDto> result = new ArrayList<>();
		unitList.stream().forEach(t -> {
			CylinderUnitDto temp = new CylinderUnitDto();
			BeanUtils.copyProperties(t, temp);
			temp.setOutOfDate(false);
			int num = cylinderUnitServiceImpl.getWarnNumByAppId(t.getAppId());
			if (num > 0) {
				temp.setOutOfDate(true);
			}
			num = cylinderUnitServiceImpl.getLicenseOutOfDate(temp.getCreditCode());
			if(num > 0){
				temp.setOutOfDate(true);
			}
			result.add(temp);
		});
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param id 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getUnitInfo")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个气瓶企业信息", notes = "根据sequenceNbr查询单个气瓶企业信息")
	public ResponseModel<CylinderUnitDto> selectOne(@RequestParam Long id) {
		CylinderUnitDto unit = cylinderUnitServiceImpl.queryBySeq(id);
		unit.setEvaluate("★★★★★");
		// 查询气瓶数量以及过期数量
		Map<String, String> cylinderInfo = iCylinderInfoService.queryNumAndOutOfDateNum(unit.getSequenceNbr());
		
		int num = cylinderUnitServiceImpl.getWarnNumByAppId(unit.getAppId());
		if (cylinderInfo != null) {
			if (cylinderInfo.get("cylinderNum") != null) {
				unit.setCylinderNumber(Integer.valueOf(String.valueOf(cylinderInfo.get("cylinderNum"))));
			}
//			if (cylinderInfo.get("outOfDateNum") != null) {
//				unit.setCylinderOutOfDate(String.valueOf(cylinderInfo.get("outOfDateNum")));
//			}
			unit.setCylinderOutOfDate(String.valueOf(num));
			if (cylinderInfo.get("fillingPermitDate") != null) {
				unit.setFillingPermitDate(String.valueOf(cylinderInfo.get("fillingPermitDate")));
			}
		}
		return ResponseHelper.buildResponse(unit);
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "气瓶企业信息分页查询", notes = "气瓶企业信息分页查询")
	public ResponseModel<Page<CylinderUnitDto>> queryForPage(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size) {
		Page<CylinderUnitDto> page = new Page<CylinderUnitDto>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper.buildResponse(cylinderUnitServiceImpl.queryForCylinderUnitPage(page));
	}

}
