package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.EndUserServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EndUserDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶终端用户
 *
 * @author system_generator
 * @date 2022-04-21
 */
@RestController
@Api(tags = "气瓶终端用户Api")
@RequestMapping(value = "/end-user")
public class EndUserController extends BaseController {

    @Autowired
    EndUserServiceImpl endUserServiceImpl;

    /**
     * 新增气瓶终端用户
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶终端用户", notes = "新增气瓶终端用户")
	public ResponseModel<EndUserDto> save(@RequestBody EndUserDto model) {
	    model = endUserServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶终端用户", notes = "根据sequenceNbr更新气瓶终端用户")
	public ResponseModel<EndUserDto> updateBySequenceNbrEndUser(@RequestBody EndUserDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(endUserServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶终端用户", notes = "根据sequenceNbr删除气瓶终端用户")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(endUserServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶终端用户",  notes = "根据sequenceNbr查询单个气瓶终端用户")
	public ResponseModel<EndUserDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(endUserServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶终端用户分页查询",  notes = "气瓶终端用户分页查询")
	public ResponseModel<Page<EndUserDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<EndUserDto> page = new Page<EndUserDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(endUserServiceImpl.queryForEndUserPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶终端用户列表全部数据查询",   notes = "气瓶终端用户列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<EndUserDto>> selectForList() {
	    return ResponseHelper.buildResponse(endUserServiceImpl.queryForEndUserList());
	}
}
