package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.CylinderAreaDataServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderAreaDataDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 气瓶区域统计表
 *
 * @author system_generator
 * @date 2022-03-08
 */
@RestController
@Api(tags = "气瓶区域统计表Api")
@RequestMapping(value = "/cylinder-area-data")
public class CylinderAreaDataController extends BaseController {

    @Autowired
    CylinderAreaDataServiceImpl cylinderAreaDataServiceImpl;

    /**
     * 新增气瓶区域统计表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶区域统计表", notes = "新增气瓶区域统计表")
	public ResponseModel<CylinderAreaDataDto> save(@RequestBody CylinderAreaDataDto model) {
	    model = cylinderAreaDataServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶区域统计表", notes = "根据sequenceNbr更新气瓶区域统计表")
	public ResponseModel<CylinderAreaDataDto> updateBySequenceNbrCylinderAreaData(@RequestBody CylinderAreaDataDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderAreaDataServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶区域统计表", notes = "根据sequenceNbr删除气瓶区域统计表")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderAreaDataServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶区域统计表",  notes = "根据sequenceNbr查询单个气瓶区域统计表")
	public ResponseModel<CylinderAreaDataDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderAreaDataServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶区域统计表分页查询",  notes = "气瓶区域统计表分页查询")
	public ResponseModel<Page<CylinderAreaDataDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderAreaDataDto> page = new Page<CylinderAreaDataDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderAreaDataServiceImpl.queryForCylinderAreaDataPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶区域统计表列表全部数据查询",   notes = "气瓶区域统计表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderAreaDataDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderAreaDataServiceImpl.queryForCylinderAreaDataList());
	}
}
