package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.CylinderInfoDataUnitServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderInfoDataUnitDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶总量统计表-企业
 *
 * @author system_generator
 * @date 2022-03-14
 */
@RestController
@Api(tags = "气瓶总量统计表-企业Api")
@RequestMapping(value = "/cylinder-info-data-unit")
public class CylinderInfoDataUnitController extends BaseController {

    @Autowired
    CylinderInfoDataUnitServiceImpl cylinderInfoDataUnitServiceImpl;

    /**
     * 新增气瓶总量统计表-企业
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶总量统计表-企业", notes = "新增气瓶总量统计表-企业")
	public ResponseModel<CylinderInfoDataUnitDto> save(@RequestBody CylinderInfoDataUnitDto model) {
	    model = cylinderInfoDataUnitServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶总量统计表-企业", notes = "根据sequenceNbr更新气瓶总量统计表-企业")
	public ResponseModel<CylinderInfoDataUnitDto> updateBySequenceNbrCylinderInfoDataUnit(@RequestBody CylinderInfoDataUnitDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderInfoDataUnitServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶总量统计表-企业", notes = "根据sequenceNbr删除气瓶总量统计表-企业")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderInfoDataUnitServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶总量统计表-企业",  notes = "根据sequenceNbr查询单个气瓶总量统计表-企业")
	public ResponseModel<CylinderInfoDataUnitDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderInfoDataUnitServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶总量统计表-企业分页查询",  notes = "气瓶总量统计表-企业分页查询")
	public ResponseModel<Page<CylinderInfoDataUnitDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderInfoDataUnitDto> page = new Page<CylinderInfoDataUnitDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderInfoDataUnitServiceImpl.queryForCylinderInfoDataUnitPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶总量统计表-企业列表全部数据查询",   notes = "气瓶总量统计表-企业列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderInfoDataUnitDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderInfoDataUnitServiceImpl.queryForCylinderInfoDataUnitList());
	}
}
