package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.CylinderDateInfoServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderTableDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;


@RestController
@Api(tags = "企业气瓶统计Api")
@RequestMapping(value = "/enterpriseStatistic")
public class EnterpriseStatisticController extends BaseController {

    @Autowired
    CylinderDateInfoServiceImpl cylinderDateInfoService;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "根据搜索信息获取表格数据")
    @GetMapping(value = "/getTableInfo")
    public ResponseModel<List<CylinderTableDto>> cylinderTableInfo() {
        List<CylinderTableDto> result = cylinderDateInfoService.selectTodayDate();
        return ResponseHelper.buildResponse(result);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "根据搜索信息获取表格数据")
    @GetMapping(value = "/getTableInfoPage")
    public ResponseModel<Page<CylinderTableDto>> cylinderTableInfoPage(String pageNumber, String pageSize,
                                                                       @RequestParam(value = "regionName", required = false) String regionName,
                                                                       @RequestParam(value = "unitName", required = false) String unitName) {
        Page<CylinderTableDto> cylinderTableDtoPage = cylinderDateInfoService.selectTodayDatePage(pageNumber, pageSize, regionName, unitName);
        return ResponseHelper.buildResponse(cylinderTableDtoPage);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "创建表格数据")
    @GetMapping(value = "/createTableInfoPage")
    public ResponseModel createTableInfoPage() {
        cylinderDateInfoService.fixedDelayJob();
        return ResponseHelper.buildResponse(null);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(value = "初始化统计数据")
    @GetMapping(value = "/initializeData")
    public ResponseModel initializeData() {
        cylinderDateInfoService.initializeData();
        return ResponseHelper.buildResponse(null);
    }
}
