package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.InformEquipmentServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.InformEquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.InformEquipment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 告知申请-设备信息表
 *
 * @author system_generator
 * @date 2021-12-10
 */
@RestController
@Api(tags = "告知申请-设备信息表Api")
@RequestMapping(value = "/inform-equipment")
public class InformEquipmentController extends BaseController {

    @Autowired
    InformEquipmentServiceImpl informEquipmentServiceImpl;

	/**
	 * 新增告知书设备
	 * @param model
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveInformEquipment")
	@ApiOperation(httpMethod = "POST", value = "新增告知书设备", notes = "新增告知书设备")
	public ResponseModel<InformEquipmentDto> save(@RequestBody InformEquipmentDto model) {
		if (ValidationUtil.isEmpty(model.getSourceEquipmentId())
				|| ValidationUtil.isEmpty(model.getInformId())) {
			throw new BadRequest("参数校验失败.");
		}
		model = informEquipmentServiceImpl.saveInformEquipment(model);
		return ResponseHelper.buildResponse(model);
	}


	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个装备信息", notes = "根据sequenceNbr查询单个装备信息")
	public ResponseModel<InformEquipmentDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(informEquipmentServiceImpl.getEquipmentById(sequenceNbr));
	}

	/**
	 * 根据告知书id 查询相关设备信息
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/getEquipListByInformId/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据告知书id 查询相关设备信息", notes = "根据告知书id 查询相关设备信息")
	public ResponseModel<List<InformEquipmentDto>> getEquipListByInformId(@PathVariable Long sequenceNbr) {
		List<InformEquipmentDto> result = informEquipmentServiceImpl.getEquipListByInformId(sequenceNbr);
		return ResponseHelper.buildResponse(result);
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/updateEquipment")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新装备信息表", notes = "根据sequenceNbr更新装备信息表")
	public ResponseModel<InformEquipmentDto> updateBySequenceNbrEquipment(@RequestBody InformEquipmentDto model) {
		if (ValidationUtil.isEmpty(model)
				|| ValidationUtil.isEmpty(model.getSequenceNbr())) {
			throw new BadRequest("参数校验失败.");
		}
		model = informEquipmentServiceImpl.updateEquipment(model);
		return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除告知申请-设备信息表", notes = "根据sequenceNbr删除告知申请-设备信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(informEquipmentServiceImpl.update(new LambdaUpdateWrapper<InformEquipment>().eq(InformEquipment::getSequenceNbr,sequenceNbr).set(InformEquipment::getIsDelete,true)));
    }


}
