package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.RegUnitIcServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.RegUnitIcDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 注册单位工商信息表
 *
 * @author system_generator
 * @date 2022-08-10
 */
@RestController
@Api(tags = "注册单位工商信息表Api")
@RequestMapping(value = "/reg-unit-ic")
public class RegUnitIcController extends BaseController {

    @Autowired
    RegUnitIcServiceImpl regUnitIcServiceImpl;

    /**
     * 新增注册单位工商信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增注册单位工商信息表", notes = "新增注册单位工商信息表")
    public ResponseModel<RegUnitIcDto> save(@RequestBody RegUnitIcDto model) {
        model = regUnitIcServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新注册单位工商信息表", notes = "根据sequenceNbr更新注册单位工商信息表")
    public ResponseModel<RegUnitIcDto> updateBySequenceNbrRegUnitIc(@RequestBody RegUnitIcDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(regUnitIcServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除注册单位工商信息表", notes = "根据sequenceNbr删除注册单位工商信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(regUnitIcServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个注册单位工商信息表", notes = "根据sequenceNbr查询单个注册单位工商信息表")
    public ResponseModel<RegUnitIcDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(regUnitIcServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "注册单位工商信息表分页查询", notes = "注册单位工商信息表分页查询")
    public ResponseModel<Page<RegUnitIcDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<RegUnitIcDto> page = new Page<RegUnitIcDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(regUnitIcServiceImpl.queryForRegUnitIcPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "注册单位工商信息表列表全部数据查询", notes = "注册单位工商信息表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<RegUnitIcDto>> selectForList() {
        return ResponseHelper.buildResponse(regUnitIcServiceImpl.queryForRegUnitIcList());
    }
}
