package com.yeejoin.amos.boot.module.jczs.flc.biz.controller;


import com.yeejoin.amos.boot.module.jczs.flc.biz.service.impl.TzCylinderServiceImpl;
import com.yeejoin.amos.boot.module.tzs.api.dto.CylinderFileUrlDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCylinderInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCylinderTraceDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ITzCylinderService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;

import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

@RestController
@Api(tags = "燃气气瓶Api")
@RequestMapping(value = "/cylinder")
public class TzCylinderController {

    @Autowired
    ITzCylinderService iTzCylinderService;
    @Autowired
    TzCylinderServiceImpl cylinderServiceImpl;

    /**
     * 气瓶基本信息列表分页查询
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "气瓶基本信息列表分页查询", notes = "气瓶基本信息列表分页查询")
    public ResponseModel<IPage<TzCylinderInfoDto>> listPage(PageParam pageParam, TzCylinderInfoDto tzCylinderInfoDto, String key){
        return ResponseHelper.buildResponse(iTzCylinderService.getCylinderInfoDtoList(pageParam,tzCylinderInfoDto,key));
    }

    /**
     * 根据id查询追溯详情
     * @param sequenceNbr 气瓶基本信息的sequenceNbr
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/trace/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询追溯详情", notes = "根据sequenceNbr查询追溯详情")
    public ResponseModel<TzCylinderTraceDto> selectById(HttpServletRequest request, @PathVariable String sequenceNbr){
        return ResponseHelper.buildResponse(iTzCylinderService.getCylinderTraceDto(sequenceNbr));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @RequestMapping(value = "/getCylinderTraceDto/{sequenceNbr}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询追溯详情", notes = "根据sequenceNbr查询追溯详情")
    public ResponseModel<CylinderFileUrlDto>   getCylinderTraceDto(@PathVariable String sequenceNbr){
        return ResponseHelper.buildResponse(cylinderServiceImpl.getFileUrlAndName(sequenceNbr));
    }


}
