package com.yeejoin.amos.boot.module.ymt.api.entity;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;


@Data
@Accessors(chain = true)
@Document(indexName = "cylinder_info", type = "tzs_cylinder_info", shards = 1, replicas = 0)
public class ESCylinderInfoDto {

    @Id
    private Long sequenceNbr;

    //产权单位名称
    @Field(type = FieldType.Text)
    private String unitName;

    //出厂编号
    @Field(type = FieldType.Text)
    private String factoryNum;

    //气瓶品种code
    @Field(type = FieldType.Integer)
    private Integer cylinderVariety;

    //气瓶品种名称
    @Field(type = FieldType.Text)
    private String cylinderVarietyName;

    //二维码标签
    @Field(type = FieldType.Text)
    private String qrCode;

    //电子标签编号
    @Field(type = FieldType.Text)
    private String electronicLabelCode;

    //气瓶状态code
    @Field(type = FieldType.Integer)
    private Integer cylinderStatus;

    //气瓶状态名称
    @Field(type = FieldType.Text)
    private String cylinderStatusStr;

    //充装介质
    @Field(type = FieldType.Text)
    private String fillingMediaName;

    //公称压力
    @Field(type = FieldType.Double)
    private Double nominalWorkPressure;

    //容积
    @Field(type = FieldType.Double)
    private Double volume;

    //制造日期
    @Field(type = FieldType.Text)
    private String manufacturingDate;

    //制造单位
    @Field(type = FieldType.Text)
    private String manufacturingUnit;

    //检验日期
    @Field(type = FieldType.Text)
    private String inspectionDate;

    //气瓶唯一标识
    @Field(type = FieldType.Text)
    private String sequenceCode;

    //单位内部编号
    @Field(type = FieldType.Text)
    private String unitInnerCode;

    //appid
    @Field(type = FieldType.Text)
    private String appId;

    //统一社会信用代码
    @Field(type = FieldType.Text)
    private String creditCode;

    @Field(type = FieldType.Text)
    private String regionCode;
}
