package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipExportDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.UseUnitCreditCodeCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.vo.EquipExportVo;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 装备分类 Mapper 接口
 *
 * @author system_generator
 * @date 2021-10-20
 */
public interface EquipmentCategoryMapper extends BaseMapper<EquipmentCategory> {

    @Select("select * from tz_equipment_category where code in('1000','2000','3000','4000','5000','6000','8000','9000')")
    List<EquipmentCategoryDto> selectClassify();

    List<Map<String, Object>> getCategoryCount(@Param("companyCode") String companyCode);


    Map<String, Object> getAdministrativeDivision(@Param("division") String division, @Param("county") String county);


    List<Map<String, Object>> getSrcee(@Param("tableName") String tableName,
                                       @Param("orgBranchName") String orgBranchName,
                                       @Param("equList") String equList,
                                       @Param("equCategory") String equCategory,
                                       @Param("usePlace") String usePlace,
                                       @Param("equState") String equState);


    Map<String, Object> getCategoryAndDefineByRecord(@Param("record") String record);

    List<Map<String, Object>> getAllUnit(@Param("unitCodes") List<String> unitCodes, @Param("orgBranchCodes") List<String> orgBranchCodes);

    List<Map<String, Object>> getCategoryData(String level, String orgCode, String companyCode);

    String getUnitCodeByRecord(String record);


    List<UseUnitCreditCodeCategoryDto> useUnitCreditCodeCategoryCount();


    List<EquipExportVo> getEquipExportData(@Param("dto") EquipExportDto dto);
}
