package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.common.api.entity.AlertStatistics;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertPaperInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.Elevator;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-11-02
 */
@Mapper
public interface AlertStatisticsMapper extends BaseMapper<AlertStatistics> {

    AlertStatistics getStatisticsMessage(@Param("orgCode") String orgCode, @Param("startDate") String startDate, @Param("endDate") String endDate);

    AlertStatistics statisticsInfoByRegionAndDate(@Param("regionCode") String regionCode, @Param("startDate") String startDate, @Param("endDate") String endDate);

    Long countProblemByTypeDateAndOrgCode(@Param("problemType") String problemType, @Param("dto") DPFilterParamDto params, @Param("orgCode") String orgCode);

    String getOrgCodeByCompanyCode(String cityCode);

    Long countEmergencyEventsByOrgCodeAndDate(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto);

    List<CountDto>countEmergencyEventsByOrgCodeAndDate2(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto);

    Long countAlertRecordByOrgCodeAndDate(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamForDetailDto filterParamDto);

    /**
     * 统计被困人数
     * @param orgCode 区域对应的orgCode
     * @param filterParamDto 日期
     * @return 被困人数
     */
    Long countRescuedPersonNum(@Param("orgCode") String orgCode, @Param("dto") DPFilterParamDto filterParamDto);

    @MapKey(value = "alertRecordForPage")
    Page<Map<String, Object>> alertRecordForPage(@Param("page") Page<Map<String, Object>> page,
                                                 @Param("dto") DPFilterParamForDetailDto dto,
                                                 @Param("orgCode") String orgCode);

    Map<String, Object> selectUseUnitByAlertId(String sequenceNbr);

    Map<String,Object> selectElevator(@Param("elevator") Elevator elevator);

    List<Map<String, Object>> selectMtByAlertId(String sequenceNbr);

    Page<AlertCalledQueryDto> getAlertCalledRecords(IPage<AlertCalledQueryDto> page, @Param("dto")AlertCalledQueryDto dto, @Param("orgCode") String orgCode);

    List<AlertPaperInfoDto> getAlertPaperInfoList(@Param("regionCodes") List<String> regionCodes, @Param("isHistory") Boolean isHistory);

    List<JSONObject> getUseUnitByCreditCode(@Param("useUnitCreditCode")Set<String> useUnitCreditCode);
}
