package com.yeejoin.amos.supervision.dao.entity;

import javax.persistence.*;
import java.util.Date;


/**
 * 任务回复信息表
 * 
 */
@Entity
@Table(name="p_task_feedback")
@NamedQuery(name="TaskFeedback.findAll", query="SELECT t FROM TaskFeedback t")
public class TaskFeedback extends BasicEntity{
	private static final long serialVersionUID = 1L;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name="feedback_time")
	private Date feedbackTime; // 回复时间

	@Lob
	private String message; //回复信息

	@Column(name="org_code")
	private String orgCode; // 组织编码

	@Column(name="picture_number")
	private int pictureNumber; // 回复照片

	@Column(name="task_id")
	private long taskId; // 任务ID

	@Column(name="user_id")
	private String userId; // 回复人ID

	@Column(name="user_name")
	private String userName; // 回复人名称
	
	@Column(name="message_type")
	private String messageType;

	public TaskFeedback() {
	}

	public Date getFeedbackTime() {
		return this.feedbackTime;
	}

	public void setFeedbackTime(Date feedbackTime) {
		this.feedbackTime = feedbackTime;
	}

	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public int getPictureNumber() {
		return this.pictureNumber;
	}

	public void setPictureNumber(int pictureNumber) {
		this.pictureNumber = pictureNumber;
	}

	public long getTaskId() {
		return this.taskId;
	}

	public void setTaskId(long taskId) {
		this.taskId = taskId;
	}

	public String getUserId() {
		return this.userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getUserName() {
		return this.userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getMessageType() {
		return messageType;
	}

	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}

}