package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 施工电站工程信息
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerStationEngineeringInfoDto", description="施工电站工程信息")
public class PowerStationEngineeringInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "组件规格")
    private String componentSpecification;

    @ApiModelProperty(value = "上网类型")
    private String gridConnectionType;

    @ApiModelProperty(value = "组件数量")
    private Integer componentQuantity;

    @ApiModelProperty(value = "逆变器数量")
    private Integer inverterQuantity;

    @ApiModelProperty(value = "并网箱数量")
    private Integer gridBoxQuantity;

    @ApiModelProperty(value = "电缆规格")
    private String cableSpecification;

    @ApiModelProperty(value = "电站设计方案")
    private String powerStationDesignPlan;

    @ApiModelProperty(value = "屋顶类型")
    private String roofType;

    @ApiModelProperty(value = "组件类型")
    private String componentType;

    @ApiModelProperty(value = "并网箱类型")
    private String gridBoxType;

    @ApiModelProperty(value = "并网箱功能")
    private String gridBoxFunction;

    private Long workOrderId;

    private Long workOrderPowerStationId;

}
